/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.ChangeSet;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.VectorObject;
import java.util.ArrayList;

public class ComponentObject {
    ArrayList<VectorObject> vecObjs = null;
    protected ArrayList<Long> selectIDs = null;
    private ArrayList<Long> texIDs = null;
    private ArrayList<Long> markerIDs = null;
    private ArrayList<Long> stickerIDs = null;
    private ArrayList<Long> vectorIDs = null;
    private ArrayList<Long> labelIDs = null;
    private ArrayList<Long> particleSystemIDs = null;
    private ArrayList<Long> geometryIDs = null;
    private ArrayList<Long> shapeID = null;
    private ArrayList<Long> billIDs = null;

    long[] convertIDs(ArrayList<Long> inIDs) {
        int which = 0;
        long[] ids = new long[inIDs.size()];
        for (Long id : inIDs) {
            ids[which] = id;
            ++which;
        }
        return ids;
    }

    void addSelectID(long id) {
        if (this.selectIDs == null) {
            this.selectIDs = new ArrayList();
        }
        this.selectIDs.add(id);
    }

    void addTexID(long id) {
        if (this.texIDs == null) {
            this.texIDs = new ArrayList();
        }
        this.texIDs.add(id);
    }

    void addMarkerID(long id) {
        if (this.markerIDs == null) {
            this.markerIDs = new ArrayList();
        }
        this.markerIDs.add(id);
    }

    void addStickerID(long id) {
        if (this.stickerIDs == null) {
            this.stickerIDs = new ArrayList();
        }
        this.stickerIDs.add(id);
    }

    long[] getStickerIDs() {
        if (this.stickerIDs == null) {
            return null;
        }
        long[] retIDs = new long[this.stickerIDs.size()];
        int which = 0;
        for (Long id : this.stickerIDs) {
            retIDs[which++] = id;
        }
        return retIDs;
    }

    void addVectorID(long id) {
        if (this.vectorIDs == null) {
            this.vectorIDs = new ArrayList();
        }
        this.vectorIDs.add(id);
    }

    void addVector(VectorObject vecObj) {
        if (this.vecObjs == null) {
            this.vecObjs = new ArrayList();
        }
        this.vecObjs.add(vecObj);
    }

    long[] getVectorIDs() {
        if (this.vectorIDs == null) {
            return null;
        }
        long[] retIDs = new long[this.vectorIDs.size()];
        int which = 0;
        for (Long id : this.vectorIDs) {
            retIDs[which++] = id;
        }
        return retIDs;
    }

    void addLabelID(long id) {
        if (this.labelIDs == null) {
            this.labelIDs = new ArrayList();
        }
        this.labelIDs.add(id);
    }

    public void addShapeID(long shapeId) {
        if (this.shapeID == null) {
            this.shapeID = new ArrayList();
        }
        this.shapeID.add(shapeId);
    }

    public void addBillboardID(long billId) {
        if (this.billIDs == null) {
            this.billIDs = new ArrayList();
        }
        this.billIDs.add(billId);
    }

    void addParticleSystemID(long id) {
        if (this.particleSystemIDs == null) {
            this.particleSystemIDs = new ArrayList();
        }
        this.particleSystemIDs.add(id);
    }

    long[] getParticleSystemIDs() {
        if (this.particleSystemIDs == null) {
            return null;
        }
        long[] retIDs = new long[this.particleSystemIDs.size()];
        int which = 0;
        for (Long id : this.particleSystemIDs) {
            retIDs[which++] = id;
        }
        return retIDs;
    }

    void addGeometryID(long id) {
        if (this.geometryIDs == null) {
            this.geometryIDs = new ArrayList();
        }
        this.geometryIDs.add(id);
    }

    long[] getGeometryIDs() {
        if (this.geometryIDs == null) {
            return null;
        }
        long[] retIDs = new long[this.geometryIDs.size()];
        int which = 0;
        for (Long id : this.geometryIDs) {
            retIDs[which++] = id;
        }
        return retIDs;
    }

    void enable(MaplyBaseController control, boolean enable, ChangeSet changes) {
        if (this.vectorIDs != null && this.vectorIDs.size() > 0) {
            control.vecManager.enableVectors(this.convertIDs(this.vectorIDs), enable, changes);
        }
        if (this.markerIDs != null && this.markerIDs.size() > 0) {
            control.markerManager.enableMarkers(this.convertIDs(this.markerIDs), enable, changes);
        }
        if (this.stickerIDs != null && this.stickerIDs.size() > 0) {
            control.stickerManager.enableStickers(this.convertIDs(this.stickerIDs), enable, changes);
        }
        if (this.labelIDs != null && this.labelIDs.size() > 0) {
            control.labelManager.enableLabels(this.convertIDs(this.labelIDs), enable, changes);
        }
        if (this.particleSystemIDs != null && this.particleSystemIDs.size() > 0) {
            for (Long id : this.particleSystemIDs) {
                control.particleSystemManager.enableParticleSystem(id, enable, changes);
            }
        }
        if (this.geometryIDs != null && this.geometryIDs.size() > 0) {
            control.geomManager.enableGeometry(this.convertIDs(this.geometryIDs), enable, changes);
        }
        if (this.shapeID != null && this.shapeID.size() > 0) {
            control.shapeManager.enableShapes(this.convertIDs(this.shapeID), enable, changes);
        }
        if (this.billIDs != null && this.billIDs.size() > 0) {
            control.billboardManager.enableBillboards(this.convertIDs(this.billIDs), enable, changes);
        }
    }

    void clear(MaplyBaseController control, ChangeSet changes) {
        if (this.vectorIDs != null && this.vectorIDs.size() > 0) {
            control.vecManager.removeVectors(this.convertIDs(this.vectorIDs), changes);
            this.vectorIDs.clear();
        }
        if (this.markerIDs != null && this.markerIDs.size() > 0) {
            control.markerManager.removeMarkers(this.convertIDs(this.markerIDs), changes);
            this.markerIDs.clear();
        }
        if (this.stickerIDs != null && this.stickerIDs.size() > 0) {
            control.stickerManager.removeStickers(this.convertIDs(this.stickerIDs), changes);
            this.stickerIDs.clear();
        }
        if (this.labelIDs != null && this.labelIDs.size() > 0) {
            control.labelManager.removeLabels(this.convertIDs(this.labelIDs), changes);
            this.labelIDs.clear();
        }
        if (this.particleSystemIDs != null && this.particleSystemIDs.size() > 0) {
            for (Long id : this.particleSystemIDs) {
                control.particleSystemManager.removeParticleSystem(id, changes);
            }
            this.particleSystemIDs.clear();
        }
        if (this.geometryIDs != null && this.geometryIDs.size() > 0) {
            control.geomManager.removeGeometry(this.convertIDs(this.labelIDs), changes);
            this.labelIDs.clear();
        }
        if (this.texIDs != null && this.texIDs.size() > 0) {
            for (long texID : this.texIDs) {
                control.texManager.removeTexture(texID, changes);
            }
            this.texIDs.clear();
        }
        if (this.shapeID != null && this.shapeID.size() > 0) {
            control.shapeManager.removeShapes(this.convertIDs(this.shapeID), changes);
            this.shapeID.clear();
        }
        if (this.billIDs != null && this.billIDs.size() > 0) {
            control.billboardManager.removeBillboards(this.convertIDs(this.billIDs), changes);
            this.billIDs.clear();
        }
    }
}

