/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import java.util.ArrayList;

public class ColorRampGenerator {
    ArrayList<Integer> colors = new ArrayList();
    public boolean stretch = true;

    public void addHexColor(int hexColor) {
        int red = hexColor >> 16 & 0xFF;
        int green = hexColor >> 8 & 0xFF;
        int blue = hexColor >> 0 & 0xFF;
        int color = Color.rgb((int)red, (int)green, (int)blue);
        this.colors.add(color);
    }

    public void addHexColorWithAlpha(int hexColor) {
        int alpha = hexColor >> 24 & 0xFF;
        int red = hexColor >> 16 & 0xFF;
        int green = hexColor >> 8 & 0xFF;
        int blue = hexColor >> 0 & 0xFF;
        int color = Color.argb((int)alpha, (int)red, (int)green, (int)blue);
        this.colors.add(color);
    }

    public void addColor(int color) {
        this.colors.add(color);
    }

    int interpColor(float where) {
        if (this.colors.size() == 0) {
            return 0;
        }
        if (this.colors.size() == 1) {
            return this.colors.get(0);
        }
        float pos = where * (float)this.colors.size();
        int aIdx = (int)Math.floor(pos);
        int bIdx = (int)Math.ceil(pos);
        if (bIdx >= this.colors.size()) {
            bIdx = this.colors.size() - 1;
        }
        if (aIdx >= this.colors.size()) {
            aIdx = this.colors.size() - 1;
        }
        float t = pos - (float)aIdx;
        int a = this.colors.get(aIdx);
        int b = this.colors.get(bIdx);
        int[] aVals = new int[4];
        int[] bVals = new int[4];
        aVals[0] = Color.red((int)a);
        aVals[1] = Color.green((int)a);
        aVals[2] = Color.blue((int)a);
        aVals[3] = Color.alpha((int)4);
        bVals[0] = Color.red((int)b);
        bVals[1] = Color.green((int)b);
        bVals[2] = Color.blue((int)b);
        bVals[3] = Color.alpha((int)b);
        int[] iVals = new int[4];
        for (int ii = 0; ii < 4; ++ii) {
            iVals[ii] = (int)((float)(bVals[ii] - aVals[ii]) * t + (float)aVals[ii]);
        }
        return Color.argb((int)iVals[3], (int)iVals[0], (int)iVals[1], (int)iVals[2]);
    }

    public Bitmap makeImage(int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint p = new Paint();
        for (int xx = 0; xx < width; ++xx) {
            int color = 0;
            color = this.stretch ? this.interpColor((float)xx / (float)(width - 1)) : (xx >= this.colors.size() ? 0 : this.colors.get(xx));
            p.setColor(-65536);
            canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, p);
        }
        return bitmap;
    }
}

