/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextPaint;
import com.mousebird.maply.ClusterGenerator;
import com.mousebird.maply.ClusterGroup;
import com.mousebird.maply.ClusterInfo;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyTexture;
import com.mousebird.maply.Point2d;
import java.awt.font.TextAttribute;
import java.util.HashMap;

public class BasicClusterGenerator
extends ClusterGenerator {
    private int clusterNumber;
    private Point2d clusterLayoutSize;
    private boolean selectable;
    private double markerAnimationTime;
    private int[] colors;
    private Bitmap bitmap;
    private Point2d size;
    private TextAttribute font;
    private float scale;
    private float textSize = 0.0f;
    private HashMap<Integer, MaplyTexture> texByNumber;
    private MaplyBaseController viewC;
    private boolean correct = false;
    private Activity activity;
    MaplyBaseController.TextureSettings texSettings = new MaplyBaseController.TextureSettings();

    public BasicClusterGenerator(int[] colors, int clusterNumber, Point2d markerSize, MaplyBaseController viewC, Activity activity) {
        boolean bl = this.correct = colors.length > 0;
        if (!this.correct) {
            return;
        }
        this.colors = colors;
        this.size = markerSize;
        this.clusterNumber = clusterNumber;
        this.scale = 1.0f;
        this.activity = activity;
        this.clusterLayoutSize = markerSize;
        this.selectable = true;
        this.markerAnimationTime = 0.2;
        this.viewC = viewC;
    }

    public BasicClusterGenerator(Bitmap bitmap, int clusterNumber, Point2d markerSize, float textSize, MaplyBaseController viewC, Activity activity) {
        this.correct = true;
        this.bitmap = bitmap;
        this.size = markerSize;
        this.textSize = textSize;
        this.clusterNumber = clusterNumber;
        this.scale = 1.0f;
        this.activity = activity;
        this.clusterLayoutSize = markerSize;
        this.selectable = true;
        this.markerAnimationTime = 0.2;
        this.viewC = viewC;
    }

    public void shutdown() {
        this.viewC = null;
        this.activity = null;
    }

    @Override
    public void startClusterGroup() {
        super.startClusterGroup();
        this.texByNumber = new HashMap();
    }

    @Override
    public ClusterGroup makeClusterGroup(ClusterInfo clusterInfo) {
        if (!this.correct) {
            return null;
        }
        ClusterGroup group = new ClusterGroup();
        MaplyTexture tex = this.texByNumber.get(clusterInfo.numObjects);
        if (tex == null) {
            Bitmap image = Bitmap.createBitmap((int)((int)this.size.getX()), (int)((int)this.size.getY()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(image);
            Paint background = new Paint();
            if (this.colors != null) {
                background.setColor(this.colors[0]);
                background.setStyle(Paint.Style.FILL);
            }
            Paint stroke = new Paint();
            stroke.setColor(-1);
            stroke.setStyle(Paint.Style.STROKE);
            TextPaint text = new TextPaint();
            text.setColor(-1);
            if ((double)this.textSize != 0.0) {
                text.setTextSize(this.textSize);
            } else {
                text.setTextSize((float)(this.size.getX() / 2.0));
            }
            text.setTextAlign(Paint.Align.CENTER);
            if (this.colors != null) {
                float x = c.getWidth() / 2;
                float y = c.getHeight() / 2;
                float radius = c.getWidth() / 2;
                c.drawCircle(x, y, radius, background);
                c.drawCircle(x, y, radius, stroke);
            } else {
                c.drawBitmap(this.bitmap, new Rect(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight()), new Rect(0, 0, (int)this.size.getX(), (int)this.size.getY()), stroke);
            }
            int xPos = c.getWidth() / 2;
            int yPos = (int)((float)(c.getHeight() / 2) - (text.descent() + text.ascent()) / 2.0f);
            c.drawText(Integer.toString(clusterInfo.numObjects), (float)xPos, (float)yPos, (Paint)text);
            tex = this.baseController.addTexture(image, this.texSettings, MaplyBaseController.ThreadMode.ThreadCurrent);
            this.texByNumber.put(clusterInfo.numObjects, tex);
        }
        group.tex = tex;
        group.size = this.size;
        return group;
    }

    @Override
    public void endClusterGroup() {
        super.endClusterGroup();
        this.texByNumber.clear();
        this.texByNumber = null;
    }

    @Override
    public int clusterNumber() {
        return this.clusterNumber;
    }

    @Override
    public Point2d clusterLayoutSize() {
        return this.clusterLayoutSize;
    }

    @Override
    public boolean selectable() {
        return this.selectable;
    }

    @Override
    public double markerAnimationTime() {
        return this.markerAnimationTime;
    }
}

