/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.ComponentObject;
import com.mousebird.maply.GlobeController;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.Point4d;
import com.mousebird.maply.Shader;
import com.mousebird.maply.Shape;
import com.mousebird.maply.ShapeInfo;
import com.mousebird.maply.ShapeSphere;
import com.mousebird.maply.SunUpdater;
import java.util.ArrayList;

public class Atmosphere {
    public static final String k_v3CameraPos = "u_v3CameraPos";
    public static final String k_v3LightPos = "u_v3LightPos";
    public static final String k_fCameraHeight = "u_fCameraHeight";
    public static final String k_fCameraHeight2 = "u_fCameraHeight2";
    public static final String k_fInnerRadius = "u_fInnerRadius";
    public static final String k_fInnerRadius2 = "u_fInnerRadius2";
    public static final String k_fOuterRadius = "u_fOuterRadius";
    public static final String k_fOuterRadius2 = "u_fOuterRadius2";
    public static final String k_fScale = "u_fScale";
    public static final String k_fScaleDepth = "u_fScaleDepth";
    public static final String k_fScaleOverScaleDepth = "u_fScaleOverScaleDepth";
    public static final String k_Kr = "u_Kr";
    public static final String k_Kr4PI = "u_Kr4PI";
    public static final String k_Km = "u_Km";
    public static final String k_Km4PI = "u_Km4PI";
    public static final String k_ESun = "u_ESun";
    public static final String k_KmESun = "u_KmESun";
    public static final String k_KrESun = "u_KrESun";
    public static final String k_v3InvWavelength = "u_v3InvWavelength";
    public static final String k_fSamples = "u_fSamples";
    public static final String k_nSamples = "u_nSamples";
    public static final String k_g = "g";
    public static final String k_g2 = "g2";
    public static final String k_fExposure = "fExposure";
    public static final String k_blendColor = "u_blendColor";
    public static final String vertexShaderAtmosTri = "precision highp float;\n\nuniform mat4  u_mvpMatrix;\nuniform vec3 u_v3CameraPos;\nuniform float u_fCameraHeight2;\nuniform vec3 u_v3LightPos;\n\nuniform float u_fInnerRadius;\nuniform float u_fInnerRadius2;\nuniform float u_fOuterRadius;\nuniform float u_fOuterRadius2;\nuniform float u_fScale;\nuniform float u_fScaleDepth;\nuniform float u_fScaleOverScaleDepth;\n\nuniform float u_Kr;\nuniform float u_Kr4PI;\nuniform float u_Km;\nuniform float u_Km4PI;\nuniform float u_ESun;\nuniform float u_KmESun;\nuniform float u_KrESun;\nuniform vec3 u_v3InvWavelength ;\nuniform float u_fSamples;\nuniform int u_nSamples;\n\nattribute vec3 a_position;\n\nvarying highp vec3 v3Direction;varying highp vec3 v3RayleighColor;\nvarying highp vec3 v3MieColor;\n\nfloat scale(float fCos)\n{\n  float x = 1.0 - fCos;\n  return u_fScaleDepth * exp(-0.00287 + x*(0.459 + x*(3.83 + x*(-6.80 + x*5.25))));\n}\n\nvoid main()\n{   vec3 v3Pos = a_position.xyz;\n   vec3 v3Ray = v3Pos - u_v3CameraPos;\n   float fFar = length(v3Ray);\n   v3Ray /= fFar;\n\n  float B = 2.0 * dot(u_v3CameraPos, v3Ray);\n  float C = u_fCameraHeight2 - u_fOuterRadius2;\n  float fDet = max(0.0, B*B - 4.0 * C);\n  float fNear = 0.5 * (-B - sqrt(fDet));\n\n   vec3 v3Start = u_v3CameraPos + v3Ray * fNear;\n   fFar -= fNear;\n\n   float fStartAngle = dot(v3Ray, v3Start) / u_fOuterRadius;\n   float fStartDepth = exp(-1.0/u_fScaleDepth);\n   float fStartOffset = fStartDepth * scale(fStartAngle);\n\n   float fSampleLength = fFar / u_fSamples;\n   float fScaledLength = fSampleLength * u_fScale;\n   vec3 v3SampleRay = v3Ray * fSampleLength;\n   vec3 v3SamplePoint = v3Start + v3SampleRay * 0.5;\n\n   vec3 v3FrontColor = vec3(0.0, 0.0, 0.0);\n   vec3 v3Attenuate;\n   for (int i=0; i<u_nSamples; i++)\n   {\n     float fHeight = length(v3SamplePoint);\n     float fDepth = exp(u_fScaleOverScaleDepth * (u_fInnerRadius - fHeight));\n     float fLightAngle = dot(u_v3LightPos, v3SamplePoint) / fHeight;\n     float fCameraAngle = dot(v3Ray, v3SamplePoint) / fHeight;\n     float fScatter = (fStartOffset + fDepth *(scale(fLightAngle) - scale(fCameraAngle)));\n     v3Attenuate = exp(-fScatter * (u_v3InvWavelength * u_Kr4PI + u_Km4PI));\n     v3FrontColor += v3Attenuate * (fDepth * fScaledLength);\n     v3SamplePoint += v3SampleRay;\n   }\n\n   v3MieColor = v3FrontColor * u_KmESun;\n   v3RayleighColor = v3FrontColor * (u_v3InvWavelength * u_KrESun + u_Km4PI);\n   v3Direction = u_v3CameraPos - v3Pos;\n\n   gl_Position = u_mvpMatrix * vec4(a_position,1.0);\n}\n";
    public static final String fragmentShaderAtmosTri = "precision highp float;\n\nuniform float g;\nuniform float g2;\nuniform float fExposure;\nuniform vec3 u_v3LightPos;\n\nvarying highp vec3 v3Direction;varying highp vec3 v3RayleighColor;\nvarying highp vec3 v3MieColor;\n\nvoid main()\n{\n  float fCos = dot(u_v3LightPos, normalize(v3Direction)) / length(v3Direction);\n  float fCos2 = fCos*fCos;\n  float rayPhase = 0.75 + 0.75*fCos2;\n  float miePhase = 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos2) / pow(1.0 + g2 - 2.0*g*fCos, 1.5);\n  vec3 color = rayPhase * v3RayleighColor + miePhase * v3MieColor;\n  color = 1.0 - exp(color * -fExposure);  gl_FragColor = vec4(color,color.b);\n}\n";
    public static final String kAtmosphereShader = "Atmosphere Shader";
    public static final String vertexShaderGroundTri = "precision highp float;\n\nuniform mat4  u_mvpMatrix;\nuniform vec3 u_v3CameraPos;\nuniform float u_fCameraHeight2;\nuniform vec3 u_v3LightPos;\n\nuniform float u_fInnerRadius;\nuniform float u_fInnerRadius2;\nuniform float u_fOuterRadius;\nuniform float u_fOuterRadius2;\nuniform float u_fScale;\nuniform float u_fScaleDepth;\nuniform float u_fScaleOverScaleDepth;\n\nuniform float u_Kr;\nuniform float u_Kr4PI;\nuniform float u_Km;\nuniform float u_Km4PI;\nuniform float u_ESun;\nuniform float u_KmESun;\nuniform float u_KrESun;\nuniform vec3 u_v3InvWavelength ;\nuniform float u_fSamples;\nuniform int u_nSamples;\n\nattribute vec3 a_position;\nattribute vec3 a_normal;\nattribute vec2 a_texCoord0;\nattribute vec2 a_texCoord1;\n\nvarying mediump vec3 v_color;\nvarying mediump vec3 v_v3attenuate;\nvarying mediump vec2 v_texCoord0;varying mediump vec2 v_texCoord1;\n\nfloat scale(float fCos)\n{\n  float x = 1.0 - fCos;\n  return u_fScaleDepth * exp(-0.00287 + x*(0.459 + x*(3.83 + x*(-6.80 + x*5.25))));\n}\n\nvoid main()\n{   vec3 v3Pos = a_normal.xyz;\n   vec3 v3Ray = v3Pos - u_v3CameraPos;\n   float fFar = length(v3Ray);\n   v3Ray /= fFar;\n\n  float B = 2.0 * dot(u_v3CameraPos, v3Ray);\n  float C = u_fCameraHeight2 - u_fOuterRadius2;\n  float fDet = max(0.0, B*B - 4.0 * C);\n  float fNear = 0.5 * (-B - sqrt(fDet));\n\n   vec3 v3Start = u_v3CameraPos + v3Ray * fNear;\n   fFar -= fNear;\n\n   float fDepth = exp((u_fInnerRadius - u_fOuterRadius) / u_fScaleDepth);\n   float fCameraAngle = dot(-v3Ray, v3Pos) / length (v3Pos);\n   float fLightAngle = dot(u_v3LightPos, v3Pos) / length(v3Pos);\n   float fCameraScale = scale(fCameraAngle);\n   float fLightScale = scale(fLightAngle);\n   float fCameraOffset = fDepth*fCameraScale;\n   float fTemp = (fLightScale + fCameraScale);\n\n   float fSampleLength = fFar / u_fSamples;\n   float fScaledLength = fSampleLength * u_fScale;\n   vec3 v3SampleRay = v3Ray * fSampleLength;\n   vec3 v3SamplePoint = v3Start + v3SampleRay * 0.5;\n\n   vec3 v3FrontColor = vec3(0.0, 0.0, 0.0);\n   vec3 v3Attenuate;\n   for (int i=0; i<u_nSamples; i++)\n   {\n     float fHeight = length(v3SamplePoint);\n     float fDepth = exp(u_fScaleOverScaleDepth * (u_fInnerRadius - fHeight));\n     float fScatter = fDepth*fTemp - fCameraOffset;\n     v3Attenuate = exp(-fScatter * (u_v3InvWavelength * u_Kr4PI + u_Km4PI));\n     v3FrontColor += v3Attenuate * (fDepth * fScaledLength);\n     v3SamplePoint += v3SampleRay;\n   }\n\n   v_v3attenuate = v3Attenuate;\n   v_color = v3FrontColor * (u_v3InvWavelength * u_KrESun + u_KmESun);\n   v_texCoord0 = a_texCoord0;\n   v_texCoord1 = a_texCoord1;\n\n   gl_Position = u_mvpMatrix * vec4(a_position,1.0);\n}\n";
    public static final String fragmentShaderGroundTri = "precision mediump float;\n\nuniform sampler2D s_baseMap0;\nuniform sampler2D s_baseMap1;\nuniform vec4 u_blendColor;\n\nvarying vec3      v_color;\nvarying vec2      v_texCoord0;\nvarying vec2      v_texCoord1;\nvarying vec3      v_v3attenuate;\n\nvoid main()\n{\n  vec3 dayColor = texture2D(s_baseMap0, v_texCoord0).xyz * v_v3attenuate;\n  vec3 nightColor = texture2D(s_baseMap1, v_texCoord1).xyz * (1.0 - v_v3attenuate);\n  gl_FragColor = (vec4(v_color, 1.0) + vec4(dayColor + nightColor, 1.0)) * u_blendColor;\n}\n";
    public static final String kAtmosphereGroundShader = "Atmosphere Ground Shader";
    public static final int kMaplyAtmosphereDrawPriorityDefault = 10;
    private float kr;
    private float km;
    private float eSun;
    private int numSamples;
    private float outerRadius;
    private float g;
    private float exposure;
    private Shader shader;
    private Shader groundShader;
    private GlobeController viewC;
    private ComponentObject comObj;
    private SunUpdater sunUpdater;
    float[] waveLength;
    boolean lockToCamera = false;

    public float getKr() {
        return this.kr;
    }

    public void setKr(float kr) {
        this.kr = kr;
    }

    public float getKm() {
        return this.km;
    }

    public void setKm(float km) {
        this.km = km;
    }

    public float geteSun() {
        return this.eSun;
    }

    public void seteSun(float eSun) {
        this.eSun = eSun;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public float getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(float outerRadius) {
        this.outerRadius = outerRadius;
    }

    public float getG() {
        return this.g;
    }

    public void setG(float g) {
        this.g = g;
    }

    public float getExposure() {
        return this.exposure;
    }

    public void setExposure(float exposure) {
        this.exposure = exposure;
    }

    public Shader getGroundShader() {
        return this.groundShader;
    }

    public Atmosphere(GlobeController inViewC, MaplyBaseController.ThreadMode mode) {
        this.viewC = inViewC;
        this.kr = 0.0025f;
        this.km = 0.001f;
        this.eSun = 20.0f;
        this.numSamples = 3;
        this.outerRadius = 1.05f;
        this.g = -0.95f;
        this.exposure = 2.0f;
        this.waveLength = new float[3];
        this.waveLength[0] = 0.65f;
        this.waveLength[1] = 0.57f;
        this.waveLength[2] = 0.475f;
        this.shader = this.setupShader();
        if (this.shader == null) {
            return;
        }
        this.groundShader = this.setupGroundShader();
        this.complexAtmosphere(mode);
    }

    public void setLockToCamera(boolean newVal) {
        this.lockToCamera = newVal;
        if (this.sunUpdater != null) {
            this.sunUpdater.setLockToCamera(this.lockToCamera);
        }
    }

    public void setWaveLength(float[] waveLength) {
        if (waveLength == null) {
            waveLength = new float[3];
        }
        this.waveLength[0] = waveLength[0];
        this.waveLength[1] = waveLength[1];
        this.waveLength[2] = waveLength[2];
    }

    public void setWaveLength(float redWavelength, float greenWavelength, float blueWavelength) {
        if (this.waveLength == null) {
            this.waveLength = new float[3];
        }
        this.waveLength[0] = redWavelength;
        this.waveLength[1] = greenWavelength;
        this.waveLength[2] = blueWavelength;
    }

    public float[] getWaveLength() {
        return (float[])this.waveLength.clone();
    }

    public float getWavelengthForComponent(short component) {
        return this.waveLength[component];
    }

    private void complexAtmosphere(MaplyBaseController.ThreadMode mode) {
        ShapeSphere sphere = new ShapeSphere();
        sphere.setLoc(new Point2d(0.0, 0.0));
        sphere.setRadius(this.outerRadius);
        sphere.setHeight(-1.0f);
        sphere.setSampleX(120);
        sphere.setSampleY(60);
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        shapes.add(sphere);
        ShapeInfo shapeInfo = new ShapeInfo();
        shapeInfo.disposeAfterUse = true;
        shapeInfo.setZBufferRead(false);
        shapeInfo.setZBufferWrite(false);
        shapeInfo.setInsideOut(true);
        shapeInfo.setCenter(new Point3d(0.0, 0.0, 0.0));
        shapeInfo.setDrawPriority(10);
        shapeInfo.setShader(this.shader);
        this.comObj = this.viewC.addShapes(shapes, shapeInfo, mode);
        this.sunUpdater = new SunUpdater(this.shader, this.groundShader, this, this.viewC);
        this.sunUpdater.setLockToCamera(this.lockToCamera);
        this.viewC.addActiveObject(this.sunUpdater);
    }

    private Shader setupGroundShader() {
        Shader theShader = new Shader(kAtmosphereGroundShader, vertexShaderGroundTri, fragmentShaderGroundTri, this.viewC);
        if (!theShader.valid()) {
            return null;
        }
        this.viewC.addShaderProgram(theShader, kAtmosphereGroundShader);
        theShader.setUniform(k_blendColor, new Point4d(1.0, 1.0, 1.0, 1.0));
        return theShader;
    }

    public void setSunPosition(Point3d sunDir) {
        if (this.sunUpdater != null) {
            this.sunUpdater.setSunPosition(sunDir);
        }
    }

    public Shader setupShader() {
        Shader theShader = new Shader(kAtmosphereShader, vertexShaderAtmosTri, fragmentShaderAtmosTri, this.viewC);
        if (!theShader.valid()) {
            return null;
        }
        this.viewC.addShaderProgram(theShader, kAtmosphereShader);
        return theShader;
    }

    public void removeFromController() {
        if (this.comObj != null) {
            this.viewC.removeObject(this.comObj, MaplyBaseController.ThreadMode.ThreadAny);
        }
        this.comObj = null;
        if (this.sunUpdater != null) {
            this.viewC.removeActiveObject(this.sunUpdater);
        }
        this.sunUpdater = null;
    }
}

