/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Typeface;
import com.mousebird.maply.AttrDictionary;
import com.mousebird.maply.ComponentObject;
import com.mousebird.maply.LabelInfo;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.ScreenLabel;
import com.mousebird.maply.VectorInfo;
import com.mousebird.maply.VectorObject;
import com.mousebird.maply.VectorStyle;
import com.mousebird.maply.VectorStyleInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VectorStyleSimpleGenerator
implements VectorStyleInterface {
    MaplyBaseController.ThreadMode threadMode = MaplyBaseController.ThreadMode.ThreadCurrent;
    MaplyBaseController controller = null;
    HashMap<String, VectorStyleSimple> stylesByUUID = new HashMap();
    HashMap<String, VectorStyleSimple> stylesByLayerName = new HashMap();

    public VectorStyleSimpleGenerator(MaplyBaseController inControl) {
        this.controller = inControl;
    }

    @Override
    public VectorStyle[] stylesForFeature(AttrDictionary attrs, MaplyTileID tileID, String layerName, MaplyBaseController controller) {
        VectorStyleSimple style = this.stylesByLayerName.get(layerName);
        if (style == null) {
            int layerOrder = attrs.getInt("layer_order");
            int geomType = attrs.getInt("geometry_type");
            switch (geomType) {
                case 1: {
                    style = new VectorStyleSimplePoint(LabelInfo.LabelPriorityDefault + layerOrder);
                    break;
                }
                case 2: {
                    style = new VectorStyleSimpleLinear(VectorInfo.VectorPriorityDefault + layerOrder);
                    break;
                }
                case 3: {
                    style = new VectorStyleSimplePolygon(VectorInfo.VectorPriorityDefault + layerOrder);
                    break;
                }
            }
            this.stylesByLayerName.put(layerName, style);
            this.stylesByUUID.put(style.getUuid(), style);
        }
        return new VectorStyle[]{style};
    }

    @Override
    public boolean layerShouldDisplay(String layerName, MaplyTileID tileID) {
        return true;
    }

    @Override
    public VectorStyle styleForUUID(String uuid, MaplyBaseController controller) {
        VectorStyle style = this.stylesByUUID.get(uuid);
        return style;
    }

    public class VectorStyleSimplePolygon
    extends VectorStyleSimple {
        double red;
        double green;
        double blue;

        VectorStyleSimplePolygon(int priority) {
            this.drawPriority = priority;
            this.red = Math.random() / 2.0 + 0.5;
            this.green = Math.random() / 2.0 + 0.5;
            this.blue = 0.0;
        }

        @Override
        public ComponentObject[] buildObjects(List<VectorObject> vecObjs, MaplyTileID tileID, MaplyBaseController controller) {
            VectorInfo vecInfo = new VectorInfo();
            vecInfo.disposeAfterUse = true;
            vecInfo.setColor((float)this.red, (float)this.green, (float)this.blue, 1.0f);
            vecInfo.setFilled(true);
            vecInfo.setDrawPriority(this.drawPriority);
            vecInfo.setEnable(false);
            ComponentObject compObj = controller.addVectors(vecObjs, vecInfo, VectorStyleSimpleGenerator.this.threadMode);
            if (compObj != null) {
                return new ComponentObject[]{compObj};
            }
            return null;
        }
    }

    public class VectorStyleSimpleLinear
    extends VectorStyleSimple {
        double red;
        double green;
        double blue;

        VectorStyleSimpleLinear(int priority) {
            this.drawPriority = priority;
            this.red = Math.random() / 2.0 + 0.5;
            this.green = Math.random() / 2.0 + 0.5;
            this.blue = Math.random() / 2.0 + 0.5;
        }

        @Override
        public ComponentObject[] buildObjects(List<VectorObject> vecObjs, MaplyTileID tileID, MaplyBaseController controller) {
            VectorInfo vecInfo = new VectorInfo();
            vecInfo.disposeAfterUse = true;
            vecInfo.setColor((float)this.red, (float)this.green, (float)this.blue, 1.0f);
            vecInfo.setLineWidth(4.0f);
            vecInfo.setFilled(false);
            vecInfo.setDrawPriority(this.drawPriority);
            vecInfo.setEnable(false);
            ComponentObject compObj = controller.addVectors(vecObjs, vecInfo, VectorStyleSimpleGenerator.this.threadMode);
            if (compObj != null) {
                return new ComponentObject[]{compObj};
            }
            return null;
        }
    }

    public class VectorStyleSimplePoint
    extends VectorStyleSimple {
        LabelInfo labelInfo;

        VectorStyleSimplePoint(int inPriority) {
            this.drawPriority = inPriority;
            this.labelInfo = new LabelInfo();
            this.labelInfo.setFontSize(32.0f);
            this.labelInfo.setTextColor(-1);
            this.labelInfo.setTypeface(Typeface.DEFAULT);
            this.labelInfo.setDrawPriority(this.drawPriority);
            this.labelInfo.setEnable(false);
        }

        @Override
        public ComponentObject[] buildObjects(List<VectorObject> vecObjs, MaplyTileID tileID, MaplyBaseController controller) {
            ArrayList<ScreenLabel> labels = new ArrayList<ScreenLabel>();
            for (VectorObject point : vecObjs) {
                String name = point.getAttributes().getString("name");
                Point2d pt = point.centroid();
                if (pt == null) continue;
                ScreenLabel label = new ScreenLabel();
                label.text = name != null ? name : ".";
                label.loc = pt;
                labels.add(label);
            }
            ComponentObject compObj = controller.addScreenLabels(labels, this.labelInfo, VectorStyleSimpleGenerator.this.threadMode);
            if (compObj != null) {
                return new ComponentObject[]{compObj};
            }
            return null;
        }
    }

    public abstract class VectorStyleSimple
    implements VectorStyle {
        String uuid = null;
        public int drawPriority = VectorInfo.VectorPriorityDefault;

        @Override
        public String getUuid() {
            if (this.uuid == null) {
                this.uuid = " " + Math.random() * 1000000.0 + Math.random() * 10000.0;
            }
            return this.uuid;
        }

        @Override
        public boolean geomIsAdditive() {
            return false;
        }
    }
}

