/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.ActiveObject;
import com.mousebird.maply.Atmosphere;
import com.mousebird.maply.GlobeController;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.Point4d;
import com.mousebird.maply.Shader;

public class SunUpdater
implements ActiveObject {
    private boolean changed;
    private boolean started;
    private Point3d sunPos;
    private Shader shader;
    private Shader groundShader;
    private Atmosphere atm;
    public GlobeController viewC;
    Point3d oldCameraPos = null;
    boolean lockToCamera = false;

    public SunUpdater(Shader inShader, Shader inGroundShader, Atmosphere inAtmosphere, GlobeController viewC) {
        this.shader = inShader;
        this.groundShader = inGroundShader;
        this.atm = inAtmosphere;
        this.viewC = viewC;
        this.changed = true;
        this.started = false;
    }

    public void setSunPosition(Point3d inSunPos) {
        this.sunPos = inSunPos;
        this.changed = true;
    }

    public void setLockToCamera(boolean newVal) {
        this.lockToCamera = newVal;
        this.changed = true;
    }

    @Override
    public boolean hasChanges() {
        Point3d cameraPos = this.viewC.getGlobeView().getEyePosition();
        if (!this.changed && this.started && cameraPos.equals(this.oldCameraPos)) {
            return false;
        }
        return this.sunPos != null;
    }

    @Override
    public void activeUpdate() {
        Point3d cameraPos = this.viewC.getGlobeView().getEyePosition();
        if (!this.changed && this.started && cameraPos.equals(this.oldCameraPos)) {
            return;
        }
        if (this.sunPos == null) {
            return;
        }
        Point4d sunDir4d = new Point4d(this.sunPos.getX(), this.sunPos.getY(), this.sunPos.getZ(), 1.0);
        Point3d sunDir3d = new Point3d(sunDir4d.getX(), sunDir4d.getY(), sunDir4d.getZ());
        if (this.lockToCamera) {
            sunDir3d = new Point3d(cameraPos.getX(), cameraPos.getY(), cameraPos.getZ());
        }
        sunDir3d.normalize();
        double cameraHeight = cameraPos.norm();
        float scale = 1.0f / (this.atm.getOuterRadius() - 1.0f);
        float scaleDepth = 0.25f;
        float[] wavelength = this.atm.getWaveLength();
        for (int ii = 0; ii < 3; ++ii) {
            wavelength[ii] = (float)(1.0 / Math.pow(wavelength[ii], 4.0));
        }
        Shader[] shaders = new Shader[]{this.shader, this.groundShader};
        for (int ii = 0; ii < 2; ++ii) {
            Shader thisShader = shaders[ii];
            thisShader.setUniform("u_v3CameraPos", cameraPos);
            thisShader.setUniform("u_fCameraHeight", (float)cameraHeight);
            thisShader.setUniform("u_fCameraHeight2", (float)(cameraHeight * cameraHeight));
            thisShader.setUniform("u_v3LightPos", sunDir3d);
            thisShader.setUniform("u_fInnerRadius", 1.0);
            thisShader.setUniform("u_fInnerRadius2", 1.0);
            thisShader.setUniform("u_fOuterRadius", this.atm.getOuterRadius());
            thisShader.setUniform("u_fOuterRadius2", this.atm.getOuterRadius() * this.atm.getOuterRadius());
            thisShader.setUniform("u_fScale", scale);
            thisShader.setUniform("u_fScaleDepth", scaleDepth);
            thisShader.setUniform("u_fScaleOverScaleDepth", scale / scaleDepth);
            thisShader.setUniform("u_Kr", this.atm.getKr());
            thisShader.setUniform("u_Kr4PI", (float)((double)this.atm.getKr() * 4.0 * Math.PI));
            thisShader.setUniform("u_Km", this.atm.getKm());
            thisShader.setUniform("u_Km4PI", (float)((double)this.atm.getKm() * 4.0 * Math.PI));
            thisShader.setUniform("u_ESun", this.atm.geteSun());
            thisShader.setUniform("u_KmESun", this.atm.getKm() * this.atm.geteSun());
            thisShader.setUniform("u_KrESun", this.atm.getKr() * this.atm.geteSun());
            thisShader.setUniform("u_v3InvWavelength", new Point3d(wavelength[0], wavelength[1], wavelength[2]));
            thisShader.setUniform("u_fSamples", (double)this.atm.getNumSamples());
            thisShader.setUniform("u_nSamples", this.atm.getNumSamples());
            thisShader.setUniform("g", this.atm.getG());
            thisShader.setUniform("g2", this.atm.getG() * this.atm.getG());
            thisShader.setUniform("fExposure", this.atm.getExposure());
        }
        this.changed = false;
        this.started = true;
        this.oldCameraPos = cameraPos;
    }
}

