/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.MaplyTexture;
import com.mousebird.maply.Matrix3d;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.SimplePoly;
import com.mousebird.maply.StringWrapper;

public class ScreenObject {
    private long nativeHandle;

    public ScreenObject() {
        this.initialise();
    }

    public void finalize() {
        this.dispose();
    }

    public native void addPoly(SimplePoly var1);

    public native void addString(StringWrapper var1);

    public void addTexture(MaplyTexture tex, float[] color, float width, float height) {
        this.addTextureNative(tex.texID, color[0], color[1], color[2], color[3], width, height);
    }

    public native void addTextureNative(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    public native void addScreenObject(ScreenObject var1);

    public BoundingBox getSize() {
        BoundingBox bbox = new BoundingBox();
        this.getSizeNative(bbox.ll, bbox.ur);
        return bbox;
    }

    public native void getSizeNative(Point2d var1, Point2d var2);

    public void scale(double x, double y) {
        Matrix3d mat = Matrix3d.scale(x, y);
        this.transform(mat);
    }

    public void translateX(double x, double y) {
        Matrix3d mat = Matrix3d.translate(x, y);
        this.transform(mat);
    }

    public native void transform(Matrix3d var1);

    private static native void nativeInit();

    native void initialise();

    native void dispose();

    static {
        ScreenObject.nativeInit();
    }

    public class BoundingBox {
        public Point2d ll = new Point2d();
        public Point2d ur = new Point2d();
    }
}

