/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Color;
import android.graphics.Typeface;
import android.os.AsyncTask;
import android.util.Log;
import com.mousebird.maply.AttrDictionary;
import com.mousebird.maply.ComponentObject;
import com.mousebird.maply.LabelInfo;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.QuadPagingLayer;
import com.mousebird.maply.ScreenLabel;
import com.mousebird.maply.VectorInfo;
import com.mousebird.maply.VectorObject;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSMVectorTilePager
implements QuadPagingLayer.PagingInterface {
    MaplyBaseController maplyControl = null;
    String remotePath = null;
    int minZoom = 0;
    int maxZoom = 0;
    File cacheDir = null;
    OkHttpClient client = new OkHttpClient();
    HashMap<String, RoadStyle> roadStyles = null;
    Typeface roadTypeface = Typeface.defaultFromStyle((int)1);
    HashMap<String, Integer> landStyles = null;

    public OSMVectorTilePager(MaplyBaseController inMaplyControl, String inRemotePath, int inMinZoom, int inMaxZoom, int numThreads) {
        this.maplyControl = inMaplyControl;
        this.remotePath = inRemotePath;
        this.minZoom = inMinZoom;
        this.maxZoom = inMaxZoom;
    }

    @Override
    public int minZoom() {
        return this.minZoom;
    }

    @Override
    public int maxZoom() {
        return this.maxZoom;
    }

    public void setCacheDir(File inDir) {
        this.cacheDir = inDir;
    }

    @Override
    public void startFetchForTile(QuadPagingLayer layer, MaplyTileID tileID) {
        Log.i((String)"OSMVectorTilePager", (String)("Starting Tile : " + tileID.level + " (" + tileID.x + "," + tileID.y + ")"));
        int maxY = 1 << tileID.level;
        int remoteY = maxY - tileID.y - 1;
        String tileURL = this.remotePath + "/" + tileID.level + "/" + tileID.x + "/" + remoteY + ".json";
        ConnectionTask task = new ConnectionTask(this, layer, tileID);
        Object[] params = new String[]{tileURL};
        task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, params);
    }

    @Override
    public void tileDidUnload(MaplyTileID tileID) {
    }

    HashMap<String, VectorGroup> sortIntoGroups(VectorObject vecs) {
        HashMap<String, VectorGroup> groups = new HashMap<String, VectorGroup>();
        for (VectorObject vec : vecs) {
            AttrDictionary attrs = vec.getAttributes();
            String kind = attrs.getString("kind");
            VectorGroup group = null;
            if (groups.containsKey(kind)) {
                group = groups.get(kind);
            } else {
                group = new VectorGroup();
                groups.put(kind, group);
            }
            group.vecs.add(vec);
            attrs.dispose();
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initRoadStyles() {
        OSMVectorTilePager oSMVectorTilePager = this;
        synchronized (oSMVectorTilePager) {
            if (this.roadStyles == null) {
                this.roadStyles = new HashMap();
                this.roadStyles.put("highway", new RoadStyle(true, 10.0f, 204.0f, 141.0f, 4.0f, 400));
                this.roadStyles.put("major_road", new RoadStyle(true, 6.0f, 239.0f, 237.0f, 88.0f, 402));
                this.roadStyles.put("minor_road", new RoadStyle(false, 2.0f, 64.0f, 64.0f, 64.0f, 404));
                this.roadStyles.put("rail", new RoadStyle(true, 6.0f, 100.0f, 100.0f, 100.0f, 406));
                this.roadStyles.put("path", new RoadStyle(false, 1.0f, 64.0f, 64.0f, 64.0f, 408));
            }
        }
    }

    void styleRoads(VectorObject roads, List<ComponentObject> compObjs) {
        if (roads == null) {
            return;
        }
        this.initRoadStyles();
        HashMap<String, VectorGroup> groups = this.sortIntoGroups(roads);
        float scale = 2.0f;
        for (String roadType : groups.keySet()) {
            VectorInfo roadInfo;
            VectorGroup group = groups.get(roadType);
            RoadStyle roadStyle = this.roadStyles.get(roadType);
            if (roadStyle == null) {
                roadStyle = this.roadStyles.get("minor_road");
            }
            if (roadStyle.twoLines) {
                roadInfo = new VectorInfo();
                roadInfo.disposeAfterUse = true;
                roadInfo.setColor(roadStyle.red / 2.0f, roadStyle.green / 2.0f, roadStyle.blue / 2.0f, 1.0f);
                roadInfo.setDrawPriority(roadStyle.drawPriority);
                roadInfo.setLineWidth(roadStyle.width * scale);
                roadInfo.setEnable(false);
                compObjs.add(this.maplyControl.addVectors(group.vecs, roadInfo, MaplyBaseController.ThreadMode.ThreadCurrent));
            }
            roadInfo = new VectorInfo();
            roadInfo.disposeAfterUse = true;
            roadInfo.setColor(roadStyle.red, roadStyle.green, roadStyle.blue, 1.0f);
            roadInfo.setDrawPriority(roadStyle.drawPriority + 1);
            roadInfo.setLineWidth(roadStyle.width * scale);
            roadInfo.setEnable(false);
            compObjs.add(this.maplyControl.addVectors(group.vecs, roadInfo, MaplyBaseController.ThreadMode.ThreadCurrent));
        }
    }

    void styleRoadLabels(VectorObject roads, List<ComponentObject> compObjs) {
        if (roads == null) {
            return;
        }
        ArrayList<ScreenLabel> labels = new ArrayList<ScreenLabel>();
        for (VectorObject road : roads) {
            AttrDictionary attrs = road.getAttributes();
            String name = attrs.getString("name");
            Point2d mid = new Point2d();
            ScreenLabel label = new ScreenLabel();
            label.loc = mid;
            label.text = name;
            labels.add(label);
        }
        LabelInfo labelInfo = new LabelInfo();
        labelInfo.setTextColor(0.0f, 0.0f, 0.0f, 1.0f);
        labelInfo.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.0f);
        labelInfo.setTypeface(this.roadTypeface);
        compObjs.add(this.maplyControl.addScreenLabels(labels, labelInfo, MaplyBaseController.ThreadMode.ThreadAny));
    }

    void styleBuildings(VectorObject buildings, List<ComponentObject> compObjs) {
        if (buildings == null) {
            return;
        }
        VectorInfo buildingInfo = new VectorInfo();
        buildingInfo.disposeAfterUse = true;
        buildingInfo.setColor(1.0f, 0.7294118f, 0.40392157f, 1.0f);
        buildingInfo.setFilled(true);
        buildingInfo.setDrawPriority(601);
        ComponentObject compObj = this.maplyControl.addVector(buildings, buildingInfo, MaplyBaseController.ThreadMode.ThreadCurrent);
        compObjs.add(compObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initLandStyles() {
        OSMVectorTilePager oSMVectorTilePager = this;
        synchronized (oSMVectorTilePager) {
            if (this.landStyles == null) {
                this.landStyles = new HashMap();
                int alpha = 63;
                Integer green = Color.argb((int)alpha, (int)111, (int)224, (int)136);
                Integer darkGreen = Color.argb((int)alpha, (int)111, (int)224, (int)136);
                Integer tan = Color.argb((int)alpha, (int)210, (int)180, (int)140);
                Integer gray = Color.argb((int)alpha, (int)0, (int)0, (int)0);
                Integer grayer = Color.argb((int)alpha, (int)0, (int)0, (int)0);
                Integer grayest = Color.argb((int)alpha, (int)0, (int)0, (int)0);
                this.landStyles.put("scrub", green);
                this.landStyles.put("park", green);
                this.landStyles.put("school", gray);
                this.landStyles.put("meadow", tan);
                this.landStyles.put("nature_reserve", green);
                this.landStyles.put("garden", green);
                this.landStyles.put("pitch", green);
                this.landStyles.put("wood", darkGreen);
                this.landStyles.put("farm", tan);
                this.landStyles.put("farmyard", tan);
                this.landStyles.put("recreation_ground", green);
                this.landStyles.put("commercial", grayer);
                this.landStyles.put("residential", gray);
                this.landStyles.put("industrial", grayest);
                this.landStyles.put("common", gray);
                this.landStyles.put("parking", gray);
                this.landStyles.put("default", gray);
            }
        }
    }

    void styleLandUsage(VectorObject land, List<ComponentObject> compObjs) {
        if (land == null) {
            return;
        }
        this.initLandStyles();
        HashMap<String, VectorGroup> groups = this.sortIntoGroups(land);
        for (String landType : groups.keySet()) {
            VectorGroup group = groups.get(landType);
            Integer landStyle = this.landStyles.get(landType);
            if (landStyle == null) {
                landStyle = this.landStyles.get("default");
            }
            if (landStyle == null) continue;
            VectorInfo landInfo = new VectorInfo();
            landInfo.disposeAfterUse = true;
            landInfo.setColor((float)Color.red((int)landStyle) / 255.0f, (float)Color.green((int)landStyle) / 255.0f, (float)Color.blue((int)landStyle) / 255.0f, (float)Color.alpha((int)landStyle) / 255.0f);
            landInfo.setDrawPriority(200);
            landInfo.setFilled(true);
            compObjs.add(this.maplyControl.addVectors(group.vecs, landInfo, MaplyBaseController.ThreadMode.ThreadCurrent));
        }
    }

    void styleWater(VectorObject water, List<ComponentObject> compObjs) {
        if (water == null) {
            return;
        }
        VectorInfo waterInfo = new VectorInfo();
        waterInfo.disposeAfterUse = true;
        waterInfo.setFilled(true);
        waterInfo.setColor(0.5372549f, 0.7372549f, 0.89411765f, 1.0f);
        waterInfo.setDrawPriority(100);
        ComponentObject compObj = this.maplyControl.addVector(water, waterInfo, MaplyBaseController.ThreadMode.ThreadCurrent);
        compObjs.add(compObj);
    }

    void showData(final QuadPagingLayer layer, Map<String, VectorObject> vecData, final MaplyTileID tileID) {
        ArrayList<ComponentObject> compObjs = new ArrayList<ComponentObject>();
        this.styleRoads(vecData.get("highroad"), compObjs);
        this.styleRoadLabels(vecData.get("skeletron"), compObjs);
        this.styleBuildings(vecData.get("buildings"), compObjs);
        this.styleLandUsage(vecData.get("land-usages"), compObjs);
        this.styleWater(vecData.get("water-areas"), compObjs);
        layer.addData(compObjs, tileID);
        layer.layerThread.addTask(new Runnable(){

            @Override
            public void run() {
                layer.tileDidLoad(tileID);
            }
        });
    }

    void didLoad(QuadPagingLayer layer, MaplyTileID tileID, String json, boolean wasCached) {
        Log.i((String)"OSMVectorTilePager", (String)("Loaded Tile : " + tileID.level + " (" + tileID.x + "," + tileID.y + ")"));
        Map<String, VectorObject> vecData = VectorObject.FromGeoJSONAssembly(json);
        this.showData(layer, vecData, tileID);
        if (!wasCached) {
            this.writeToCache(vecData, tileID);
        }
    }

    void didNotLoad(final QuadPagingLayer layer, final MaplyTileID tileID) {
        Log.i((String)"OSMVectorTilePager", (String)("Failed Tile : " + tileID.level + " (" + tileID.x + "," + tileID.y + ")"));
        layer.layerThread.addTask(new Runnable(){

            @Override
            public void run() {
                layer.tileFailedToLoad(tileID);
            }
        });
    }

    String cacheName(MaplyTileID tileID, String type) {
        String fileName = type + "_" + tileID.level + "_" + tileID.x + "_" + tileID.y + ".bvec";
        return this.maplyControl.activity.getCacheDir().getAbsolutePath() + "/" + fileName;
    }

    void writeToCache(Map<String, VectorObject> vecData, MaplyTileID tileID) {
        for (String type : vecData.keySet()) {
            VectorObject vecObj = vecData.get(type);
            String fileName = this.cacheName(tileID, type);
            vecObj.writeToFile(fileName);
        }
    }

    Map<String, VectorObject> readFromCache(MaplyTileID tileID) {
        String[] types;
        HashMap<String, VectorObject> vecData = new HashMap<String, VectorObject>();
        for (String type : types = new String[]{"highroad", "skeletron", "buildings", "land-usages", "water-areas"}) {
            String fileName = this.cacheName(tileID, type);
            File theFile = new File(fileName);
            if (!theFile.exists()) continue;
            VectorObject vecObj = new VectorObject();
            vecObj.readFromFile(fileName);
            vecData.put(type, vecObj);
        }
        if (vecData.size() > 0) {
            return vecData;
        }
        return null;
    }

    class RoadStyle {
        public boolean twoLines;
        public float width;
        public float red;
        public float green;
        public float blue;
        public int drawPriority;

        RoadStyle(boolean inTL, float inW, float inR, float inG, float inB, int inDP) {
            this.twoLines = inTL;
            this.width = inW;
            this.red = inR / 255.0f;
            this.green = inG / 255.0f;
            this.blue = inB / 255.0f;
            this.drawPriority = inDP;
        }
    }

    class VectorGroup {
        public ArrayList<VectorObject> vecs = new ArrayList();

        VectorGroup() {
        }
    }

    private class ConnectionTask
    extends AsyncTask<String, Void, String> {
        QuadPagingLayer layer = null;
        MaplyTileID tileID = null;
        OSMVectorTilePager pager = null;

        ConnectionTask(OSMVectorTilePager inPager, QuadPagingLayer inLayer, MaplyTileID inTileID) {
            this.layer = inLayer;
            this.tileID = inTileID;
            this.pager = inPager;
        }

        protected String doInBackground(String ... urls) {
            String aString = null;
            try {
                Map<String, VectorObject> vecData;
                URL url = new URL(urls[0]);
                if (OSMVectorTilePager.this.cacheDir != null && (vecData = OSMVectorTilePager.this.readFromCache(this.tileID)) != null) {
                    OSMVectorTilePager.this.showData(this.layer, vecData, this.tileID);
                    return null;
                }
                Request request = new Request.Builder().url(url).build();
                Response response = OSMVectorTilePager.this.client.newCall(request).execute();
                aString = response.body().string();
            }
            catch (IOException e) {
                this.pager.didNotLoad(this.layer, this.tileID);
            }
            if (aString != null) {
                this.pager.didLoad(this.layer, this.tileID, aString, false);
            } else {
                this.pager.didNotLoad(this.layer, this.tileID);
            }
            return null;
        }

        protected void onPostExecute(String result) {
        }
    }
}

