/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.mousebird.maply.GeometryUtils;
import com.mousebird.maply.MapAnimateTranslate;
import com.mousebird.maply.MapAnimateTranslateMomentum;
import com.mousebird.maply.MapController;
import com.mousebird.maply.MapView;
import com.mousebird.maply.Matrix4d;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;

public class MapGestureHandler {
    MapController mapControl = null;
    MapView mapView = null;
    public boolean allowRotate = false;
    ScaleGestureDetector sgd = null;
    ScaleListener sl = null;
    GestureDetector gd = null;
    GestureListener gl = null;
    View view = null;
    double zoomLimitMin = 0.0;
    double zoomLimitMax = 1000.0;
    double startRot = Double.MAX_VALUE;
    double startViewRot = Double.MAX_VALUE;

    public MapGestureHandler(MapController inControl, View inView) {
        this.mapControl = inControl;
        this.mapView = this.mapControl.mapView;
        this.view = inView;
        this.sl = new ScaleListener(this.mapControl);
        this.sgd = new ScaleGestureDetector(this.view.getContext(), (ScaleGestureDetector.OnScaleGestureListener)this.sl);
        this.gl = new GestureListener(this.mapControl);
        this.gd = new GestureDetector(this.view.getContext(), (GestureDetector.OnGestureListener)this.gl);
        this.sl.gl = this.gl;
    }

    public void shutdown() {
        this.sgd = null;
        if (this.sl != null) {
            this.sl.maplyControl = null;
        }
        this.sl = null;
        this.gd = null;
        if (this.gl != null) {
            this.gl.maplyControl = null;
        }
        this.gl = null;
        this.view = null;
    }

    public void setZoomLimits(double inMin, double inMax) {
        this.zoomLimitMin = inMin;
        this.zoomLimitMax = inMax;
    }

    public static boolean withinBounds(MapView mapView, Point2d frameSize, Point3d newLocalPos, Point2d[] bounds) {
        if (bounds == null) {
            return true;
        }
        MapView thisMapView = mapView.clone();
        thisMapView.setLoc(newLocalPos);
        Matrix4d fullMatrix = thisMapView.calcModelViewMatrix();
        Point2d[] corners = new Point2d[]{new Point2d(0.0, 0.0), new Point2d(frameSize.getX(), 0.0), new Point2d(frameSize.getX(), frameSize.getY()), new Point2d(0.0, frameSize.getY())};
        for (int ii = 0; ii < 4; ++ii) {
            Point3d hit = thisMapView.pointOnPlaneFromScreen(corners[ii], fullMatrix, frameSize, false);
            if (GeometryUtils.PointInPolygon(new Point2d(hit.getX(), hit.getY()), bounds)) continue;
            return false;
        }
        return true;
    }

    void handleRotation(MotionEvent event) {
        if (this.allowRotate) {
            MotionEvent.PointerCoords p0 = new MotionEvent.PointerCoords();
            MotionEvent.PointerCoords p1 = new MotionEvent.PointerCoords();
            event.getPointerCoords(0, p0);
            event.getPointerCoords(1, p1);
            double cX = (double)(p0.x + p1.x) / 2.0;
            double cY = (double)(p0.y + p1.y) / 2.0;
            double dx = (double)p0.x - cX;
            double dy = (double)p0.y - cY;
            if (this.startRot == Double.MAX_VALUE) {
                this.startRot = Math.atan2(dy, dx);
                this.startViewRot = this.mapView.getRot();
            } else {
                double curRot = Math.atan2(dy, dx);
                double diffRot = curRot - this.startRot;
                this.mapView.setRot(this.startViewRot + diffRot);
            }
        }
    }

    void cancelRotation() {
        this.startRot = Double.MAX_VALUE;
    }

    public boolean onTouch(View v, MotionEvent event) {
        boolean rotWasActive;
        boolean slWasActive = this.sl.isActive;
        boolean glWasActive = this.gl.isActive;
        boolean bl = rotWasActive = this.startRot != Double.MAX_VALUE;
        if (event.getPointerCount() == 2) {
            this.gl.isActive = false;
        }
        if (this.sl.isActive || event.getPointerCount() == 2) {
            this.sgd.onTouchEvent(event);
            this.handleRotation(event);
        }
        if (!this.sl.isActive && event.getPointerCount() == 1) {
            this.gd.onTouchEvent(event);
            if (event.getAction() == 1) {
                this.gl.isActive = false;
            }
            this.cancelRotation();
        }
        if (!(this.sl.isActive || this.gl.isActive || slWasActive || event.getPointerCount() != 2 || event.getActionMasked() != 6)) {
            Point3d loc = this.mapView.getLoc();
            double newZ = loc.getZ() * 2.0;
            newZ = Math.min(newZ, this.zoomLimitMax);
            newZ = Math.max(newZ, this.zoomLimitMin);
            loc.setValue(loc.getX(), loc.getY(), newZ);
            this.mapView.setAnimationDelegate(new MapAnimateTranslate(this.mapView, this.mapControl.renderWrapper.maplyRender, loc, 0.1f, this.mapControl.viewBounds));
            this.sl.isActive = false;
            this.gl.isActive = false;
        }
        if (!glWasActive && this.gl.isActive) {
            this.mapControl.panDidStart(true);
        }
        if (glWasActive && !this.gl.isActive) {
            this.mapControl.panDidEnd(true);
        }
        if (!slWasActive && this.sl.isActive) {
            this.mapControl.zoomDidStart(true);
        }
        if (slWasActive && !this.sl.isActive) {
            this.mapControl.zoomDidEnd(true);
        }
        if (!rotWasActive && this.startRot != Double.MAX_VALUE) {
            this.mapControl.rotateDidStart(true);
        }
        if (rotWasActive && this.startRot == Double.MAX_VALUE) {
            this.mapControl.rotateDidEnd(true);
        }
        return true;
    }

    private class GestureListener
    implements GestureDetector.OnGestureListener,
    GestureDetector.OnDoubleTapListener {
        MapController maplyControl;
        public boolean isActive = false;
        Point2d startScreenPos = null;
        Point3d startLoc = null;
        Point3d startOnPlane = null;
        Matrix4d startTransform = null;
        static final double AnimMomentumTime = 1.0;

        GestureListener(MapController inMaplyControl) {
            this.maplyControl = inMaplyControl;
        }

        public boolean onDown(MotionEvent e) {
            this.startScreenPos = new Point2d(e.getX(), e.getY());
            this.startTransform = this.maplyControl.mapView.calcModelViewMatrix();
            this.startLoc = this.maplyControl.mapView.getLoc();
            this.startOnPlane = this.maplyControl.mapView.pointOnPlaneFromScreen(this.startScreenPos, this.startTransform, this.maplyControl.getViewSize(), false);
            this.isActive = true;
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!this.isActive) {
                return false;
            }
            Point2d newScreenPos = new Point2d(e2.getX(), e2.getY());
            Point3d hit = this.maplyControl.mapView.pointOnPlaneFromScreen(newScreenPos, this.startTransform, this.maplyControl.getViewSize(), false);
            if (hit != null) {
                Point3d newPos = new Point3d(this.startOnPlane.getX() - hit.getX() + this.startLoc.getX(), this.startOnPlane.getY() - hit.getY() + this.startLoc.getY(), this.maplyControl.mapView.getLoc().getZ());
                MapGestureHandler.this.mapView.cancelAnimation();
                Point3d locPos = newPos;
                if (locPos == null) {
                    return true;
                }
                if (MapGestureHandler.withinBounds(MapGestureHandler.this.mapView, this.maplyControl.getViewSize(), locPos, this.maplyControl.viewBounds)) {
                    this.maplyControl.mapView.setLoc(locPos);
                }
            }
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            Matrix4d mapTransform = this.maplyControl.mapView.calcModelViewMatrix();
            Point2d touch0 = new Point2d(e1.getX(), e1.getY());
            Point2d touch1 = touch0.addTo(new Point2d(velocityX, velocityY));
            Point2d viewSize = this.maplyControl.getViewSize();
            Point3d pt0 = MapGestureHandler.this.mapView.pointOnPlaneFromScreen(touch0, mapTransform, viewSize, false);
            Point3d pt1 = MapGestureHandler.this.mapView.pointOnPlaneFromScreen(touch1, mapTransform, viewSize, false);
            Point3d dir = pt0.subtract(pt1);
            dir.multiplyBy(-1.0);
            double len = dir.length();
            dir = dir.multiplyBy(1.0 / len);
            double modelVel = len / 1.0;
            double accel = -modelVel / 1.0;
            MapGestureHandler.this.mapView.setAnimationDelegate(new MapAnimateTranslateMomentum(MapGestureHandler.this.mapView, MapGestureHandler.this.mapControl.renderWrapper.maplyRender, modelVel, accel, dir, this.maplyControl.viewBounds));
            this.isActive = false;
            return true;
        }

        public void onLongPress(MotionEvent e) {
            if (!MapGestureHandler.this.sl.isActive && MapGestureHandler.this.gl.isActive && e.getPointerCount() == 1) {
                MapGestureHandler.this.mapControl.processLongPress(new Point2d(e.getX(), e.getY()));
            }
        }

        public void onShowPress(MotionEvent e) {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return false;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            MapGestureHandler.this.mapControl.processTap(new Point2d(e.getX(), e.getY()));
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            Matrix4d mapTransform;
            Point2d touch = new Point2d(e.getX(), e.getY());
            Point3d pt = MapGestureHandler.this.mapView.pointOnPlaneFromScreen(touch, mapTransform = this.maplyControl.mapView.calcModelViewMatrix(), this.maplyControl.getViewSize(), false);
            if (pt == null) {
                return false;
            }
            Point3d locPt = MapGestureHandler.this.mapView.getCoordAdapter().displayToLocal(pt);
            if (locPt == null) {
                return false;
            }
            Point3d loc = MapGestureHandler.this.mapView.getLoc();
            double newZ = loc.getZ() / 2.0;
            newZ = Math.min(newZ, MapGestureHandler.this.zoomLimitMax);
            newZ = Math.max(newZ, MapGestureHandler.this.zoomLimitMin);
            loc.setValue(locPt.getX(), locPt.getY(), newZ);
            MapGestureHandler.this.mapView.setAnimationDelegate(new MapAnimateTranslate(MapGestureHandler.this.mapView, MapGestureHandler.this.mapControl.renderWrapper.maplyRender, loc, 0.1f, this.maplyControl.viewBounds));
            this.isActive = false;
            return true;
        }
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        MapController maplyControl;
        double startZ;
        float startDist;
        GestureListener gl = null;
        public boolean isActive = false;

        ScaleListener(MapController inMaplyControl) {
            this.maplyControl = inMaplyControl;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            this.startZ = this.maplyControl.mapView.getLoc().getZ();
            this.startDist = detector.getCurrentSpan();
            if (this.gl != null) {
                this.gl.isActive = false;
            }
            this.isActive = true;
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float curDist = detector.getCurrentSpan();
            if ((double)curDist > 0.0 && (double)this.startDist > 0.0) {
                float scale = this.startDist / curDist;
                Point3d pos = this.maplyControl.mapView.getLoc();
                MapGestureHandler.this.mapView.cancelAnimation();
                Point3d newPos = new Point3d(pos.getX(), pos.getY(), this.startZ * (double)scale);
                if (MapGestureHandler.withinBounds(MapGestureHandler.this.mapView, this.maplyControl.getViewSize(), newPos, this.maplyControl.viewBounds)) {
                    double newZ = newPos.getZ();
                    newZ = Math.min(newZ, MapGestureHandler.this.zoomLimitMax);
                    newZ = Math.max(newZ, MapGestureHandler.this.zoomLimitMin);
                    this.maplyControl.mapView.setLoc(new Point3d(newPos.getX(), newPos.getY(), newZ));
                }
                return true;
            }
            this.isActive = false;
            return false;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            this.isActive = false;
        }
    }
}

