/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.MapGestureHandler;
import com.mousebird.maply.MapView;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.Mbr;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;

public class MapAnimateTranslateMomentum
implements MapView.AnimationDelegate {
    MapView mapView = null;
    MaplyRenderer renderer = null;
    double velocity;
    double acceleration;
    Point3d dir = null;
    Mbr bounds = null;
    double startTime;
    double maxTime;
    Point3d org = null;
    Point2d[] viewBounds = null;

    MapAnimateTranslateMomentum(MapView inView, MaplyRenderer inRender, double inVel, double inAcc, Point3d inDir, Point2d[] inBounds) {
        this.mapView = inView;
        this.renderer = inRender;
        this.velocity = inVel;
        this.acceleration = inAcc;
        this.dir = inDir;
        this.viewBounds = inBounds;
        this.startTime = (double)System.currentTimeMillis() / 1000.0;
        this.org = this.mapView.getLoc();
        if (this.acceleration != 0.0) {
            this.maxTime = -this.velocity / this.acceleration;
            if (this.maxTime < 0.0) {
                this.maxTime = 0.0;
            }
            if (this.maxTime == 0.0) {
                this.startTime = 0.0;
            }
        } else {
            this.maxTime = Double.MAX_VALUE;
        }
    }

    @Override
    public void updateView(MapView view) {
        double dist;
        Point3d newPos;
        if (this.startTime == 0.0) {
            return;
        }
        double sinceStart = (double)System.currentTimeMillis() / 1000.0 - this.startTime;
        if (sinceStart > this.maxTime) {
            sinceStart = this.maxTime;
            this.startTime = 0.0;
            view.cancelAnimation();
        }
        if (MapGestureHandler.withinBounds(view, this.renderer.frameSize, newPos = this.org.addTo(this.dir.multiplyBy(dist = (this.velocity + 0.5 * this.acceleration * sinceStart) * sinceStart)), this.viewBounds)) {
            view.setLoc(newPos);
        }
    }
}

