/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.MapGestureHandler;
import com.mousebird.maply.MapView;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;

public class MapAnimateTranslate
implements MapView.AnimationDelegate {
    MaplyRenderer renderer = null;
    MapView view = null;
    Point3d startLoc = null;
    Point3d endLoc = null;
    Point2d[] viewBounds = null;
    double startTime;
    double endTime;

    MapAnimateTranslate(MapView inView, MaplyRenderer inRender, Point3d newLoc, float duration, Point2d[] inBounds) {
        this.view = inView;
        this.renderer = inRender;
        this.endLoc = newLoc;
        this.viewBounds = inBounds;
        this.startLoc = this.view.getLoc();
        this.startTime = (double)System.currentTimeMillis() / 1000.0;
        this.endTime = this.startTime + (double)duration;
    }

    @Override
    public void updateView(MapView view) {
        if (this.startTime == 0.0 || this.renderer == null) {
            return;
        }
        double curTime = (double)System.currentTimeMillis() / 1000.0;
        if (curTime > this.endTime) {
            curTime = this.endTime;
            this.startTime = 0.0;
            view.cancelAnimation();
        }
        double t = (curTime - this.startTime) / (this.endTime - this.startTime);
        Point3d newPos = this.endLoc.subtract(this.startLoc).multiplyBy(t).addTo(this.startLoc);
        if (MapGestureHandler.withinBounds(view, this.renderer.frameSize, newPos, this.viewBounds)) {
            view.setLoc(newPos);
        }
    }
}

