/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.mousebird.maply.LabelInfo;

class CharRenderer {
    static int fontPadX = 2;
    static int fontPadY = 2;

    CharRenderer() {
    }

    Glyph renderChar(int charInt, LabelInfo labelInfo, float fontSize) {
        Paint textFillPaint = new Paint();
        String str = new String(Character.toChars(charInt));
        textFillPaint.setTextSize(fontSize);
        int textColor = labelInfo.getTextColor();
        textFillPaint.setColor(textColor);
        textFillPaint.setAntiAlias(true);
        if (labelInfo != null) {
            textFillPaint.setTypeface(labelInfo.getTypeface());
        }
        Paint.FontMetrics fm = textFillPaint.getFontMetrics();
        float fontHeight = (float)Math.ceil(Math.abs(fm.bottom) + Math.abs(fm.top));
        float fontDescent = (float)Math.ceil(Math.abs(fm.descent));
        float[] widths = new float[2];
        textFillPaint.getTextWidths(str, widths);
        int width = (int)(widths[0] + (float)(fontPadX * 2));
        int height = (int)(fontHeight + (float)(fontPadY * 2));
        Paint textOutlinePaint = null;
        if (labelInfo.getOutlineSize() > 0.0f) {
            textOutlinePaint = new Paint(textFillPaint);
            textOutlinePaint.setStyle(Paint.Style.STROKE);
            textOutlinePaint.setStrokeWidth(labelInfo.getOutlineSize());
            textOutlinePaint.setColor(labelInfo.getOutlineColor());
            textOutlinePaint.setAntiAlias(true);
            textOutlinePaint.setTypeface(textFillPaint.getTypeface());
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.eraseColor(0);
        Canvas canvas = new Canvas(bitmap);
        if (textOutlinePaint != null) {
            canvas.drawText(str, 0, 1, (float)fontPadX, (float)height - fontDescent - (float)fontPadY, textOutlinePaint);
        }
        canvas.drawText(str, 0, 1, (float)fontPadX, (float)height - fontDescent - (float)fontPadY, textFillPaint);
        Glyph glyph = new Glyph();
        glyph.bitmap = bitmap;
        glyph.sizeX = width;
        glyph.sizeY = height;
        glyph.textureOffsetX = 1.0f;
        glyph.textureOffsetY = 1.0f;
        glyph.offsetX = 0.0f;
        glyph.offsetY = 0.0f;
        glyph.glyphSizeX = widths[0];
        glyph.glyphSizeY = fontHeight;
        return glyph;
    }

    public class Glyph {
        public Bitmap bitmap = null;
        public float sizeX;
        public float sizeY;
        public float glyphSizeX;
        public float glyphSizeY;
        public float offsetX;
        public float offsetY;
        public float textureOffsetX;
        public float textureOffsetY;
    }
}

