/*
 *  StringWrapper.java
 *  WhirlyGlobeLib
 *
 *  Created by jmnavarro
 *  Copyright 2011-2016 mousebird consulting
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package com.mousebird.maply;


/**
 * Wraps strings with size and translation
 */
public class StringWrapper {

    public StringWrapper() {
        initialise();
    }

    public StringWrapper(int width, int height, Matrix3d mat){
        initialise(width, height, mat);
    }


    public void finalize() {
        dispose();
    }

    public native void setSize(int width, int height);

    public native int[] getSize();

    public native void setMat(Matrix3d mat);

    public native Matrix3d getMat();

    static
    {
        nativeInit();
    }
    private static native void nativeInit();

    native void initialise(int width, int height, Matrix3d mat);

    native void initialise();
    native void dispose();

    private long nativeHandle;

}
