/*
 * Decompiled with CFR 0.152.
 */
package com.mottimotti.android.airbrake;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import android.util.Xml;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Random;
import org.xmlpull.v1.XmlSerializer;

public class AirbrakeNotifier {
    private static final String LOG_TAG = "AirbrakeNotifier";
    private static final String AIRBRAKE_ENDPOINT = "https://exceptions.codebasehq.com/notifier_api/v2/notices";
    private static final String AIRBRAKE_API_VERSION = "2.0";
    private static final String NOTIFIER_NAME = "Android Airbrake Notifier";
    private static final String NOTIFIER_VERSION = "1.3.1";
    private static final String NOTIFIER_URL = "http://mottimotti.com/";
    private static final String UNSENT_EXCEPTION_PATH = "/unsent_airbrake_exceptions/";
    private static final String ENVIRONMENT_PRODUCTION = "production";
    private static final String ENVIRONMENT_DEFAULT = "production";
    private static String environmentName = "production";
    private static String packageName = "unknown";
    private static String versionName = "unknown";
    private static String phoneModel = Build.MODEL;
    private static String androidVersion = Build.VERSION.RELEASE;
    private static Map<String, String> extraData;
    private static String apiKey;
    private static boolean notifyOnlyProduction;
    private static String filePath;
    private static boolean diskStorageEnabled;

    public static void register(Context context, String apiKey) {
        AirbrakeNotifier.register(context, apiKey, "production", true);
    }

    public static void register(Context context, String apiKey, String environmentName) {
        AirbrakeNotifier.register(context, apiKey, environmentName, true);
    }

    public static void register(Context context, String apiKey, String environmentName, boolean notifyOnlyProduction) {
        if (apiKey == null) {
            throw new RuntimeException("AirbrakeNotifier requires an Airbrake API key.");
        }
        AirbrakeNotifier.apiKey = apiKey;
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        if (environmentName != null) {
            AirbrakeNotifier.environmentName = environmentName;
        }
        AirbrakeNotifier.notifyOnlyProduction = notifyOnlyProduction;
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!(currentHandler instanceof AirbrakeExceptionHandler || !environmentName.equals("production") && notifyOnlyProduction)) {
            Thread.setDefaultUncaughtExceptionHandler(new AirbrakeExceptionHandler(currentHandler));
        }
        try {
            packageName = context.getPackageName();
            PackageInfo pi = context.getPackageManager().getPackageInfo(packageName, 0);
            if (pi.versionName != null) {
                versionName = pi.versionName;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        filePath = context.getFilesDir().getAbsolutePath() + UNSENT_EXCEPTION_PATH;
        File outFile = new File(filePath);
        outFile.mkdirs();
        diskStorageEnabled = outFile.exists();
        Log.d((String)LOG_TAG, (String)"Registered and ready to handle exceptions.");
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... voi) {
                AirbrakeNotifier.flushExceptions();
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    public static void setExtraData(Map<String, String> extraData) {
        AirbrakeNotifier.extraData = extraData;
    }

    public static void notify(Throwable e) {
        AirbrakeNotifier.notify(e, null);
    }

    public static void notify(final Throwable e, final Map<String, String> metaData) {
        if (!environmentName.equals("production")) {
            return;
        }
        if (e != null && diskStorageEnabled) {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... voi) {
                    AirbrakeNotifier.writeExceptionToDisk(e, metaData);
                    AirbrakeNotifier.flushExceptions();
                    return null;
                }
            }.execute((Object[])new Void[0]);
        }
    }

    private static void writeExceptionToDisk(Throwable e, Map<String, String> metaData) {
        try {
            int random = new Random().nextInt(99999);
            String filename = filePath + versionName + "-" + String.valueOf(random) + ".xml";
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            XmlSerializer s = Xml.newSerializer();
            s.setOutput((Writer)writer);
            s.startDocument("UTF-8", Boolean.valueOf(true));
            s.startTag("", "notice");
            s.attribute("", "version", AIRBRAKE_API_VERSION);
            s.startTag("", "api-key");
            s.text(apiKey);
            s.endTag("", "api-key");
            s.startTag("", "notifier");
            s.startTag("", "name");
            s.text(NOTIFIER_NAME);
            s.endTag("", "name");
            s.startTag("", "version");
            s.text(NOTIFIER_VERSION);
            s.endTag("", "version");
            s.startTag("", "url");
            s.text(NOTIFIER_URL);
            s.endTag("", "url");
            s.endTag("", "notifier");
            s.startTag("", "error");
            s.startTag("", "class");
            s.text(e.getClass().getName());
            s.endTag("", "class");
            s.startTag("", "message");
            s.text("[" + versionName + "] " + e.toString());
            s.endTag("", "message");
            s.startTag("", "backtrace");
            Throwable currentEx = e;
            while (currentEx != null) {
                try {
                    StackTraceElement[] stackTrace;
                    for (StackTraceElement el : stackTrace = currentEx.getStackTrace()) {
                        s.startTag("", "line");
                        try {
                            s.attribute("", "method", el.getClassName() + "." + el.getMethodName());
                            s.attribute("", "file", el.getFileName() == null ? "Unknown" : el.getFileName());
                            s.attribute("", "number", String.valueOf(el.getLineNumber()));
                        }
                        catch (Throwable ex) {
                            Log.v((String)LOG_TAG, (String)"Exception caught:", (Throwable)ex);
                        }
                        s.endTag("", "line");
                    }
                    if ((currentEx = currentEx.getCause()) == null) continue;
                    s.startTag("", "line");
                    try {
                        s.attribute("", "file", "### CAUSED BY ###: " + currentEx.toString());
                        s.attribute("", "number", "");
                    }
                    catch (Throwable ex) {
                        Log.v((String)LOG_TAG, (String)"Exception caught:", (Throwable)ex);
                    }
                    s.endTag("", "line");
                }
                catch (Throwable innerException) {
                    Log.v((String)LOG_TAG, (String)"Exception caught:", (Throwable)e);
                    break;
                }
            }
            s.endTag("", "backtrace");
            s.endTag("", "error");
            s.startTag("", "request");
            s.startTag("", "url");
            s.endTag("", "url");
            s.startTag("", "component");
            s.endTag("", "component");
            s.startTag("", "action");
            s.endTag("", "action");
            s.startTag("", "cgi-data");
            s.startTag("", "var");
            s.attribute("", "key", "Device");
            s.text(phoneModel);
            s.endTag("", "var");
            s.startTag("", "var");
            s.attribute("", "key", "Android Version");
            s.text(androidVersion);
            s.endTag("", "var");
            s.startTag("", "var");
            s.attribute("", "key", "App Version");
            s.text(versionName);
            s.endTag("", "var");
            if (extraData != null && !extraData.isEmpty()) {
                for (Map.Entry<String, String> extra : extraData.entrySet()) {
                    s.startTag("", "var");
                    s.attribute("", "key", extra.getKey());
                    s.text(extra.getValue());
                    s.endTag("", "var");
                }
            }
            if (metaData != null && !metaData.isEmpty()) {
                for (Map.Entry<String, String> extra : metaData.entrySet()) {
                    s.startTag("", "var");
                    s.attribute("", "key", extra.getKey());
                    s.text(extra.getValue());
                    s.endTag("", "var");
                }
            }
            s.endTag("", "cgi-data");
            s.endTag("", "request");
            s.startTag("", "server-environment");
            s.startTag("", "environment-name");
            s.text(environmentName);
            s.endTag("", "environment-name");
            s.startTag("", "app-version");
            s.text(versionName);
            s.endTag("", "app-version");
            s.endTag("", "server-environment");
            s.endTag("", "notice");
            s.endDocument();
            writer.flush();
            writer.close();
            Log.d((String)LOG_TAG, (String)("Writing new " + e.getClass().getName() + " exception to disk."));
        }
        catch (Exception ex) {
            Log.v((String)LOG_TAG, (String)"Exception caught:", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendExceptionData(File file) {
        try {
            boolean sent = false;
            URL url = new URL(AIRBRAKE_ENDPOINT);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            try {
                int numRead;
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
                FileInputStream is = new FileInputStream(file);
                OutputStream os = conn.getOutputStream();
                byte[] buffer = new byte[4096];
                while ((numRead = is.read(buffer)) >= 0) {
                    os.write(buffer, 0, numRead);
                }
                os.flush();
                os.close();
                is.close();
                int response = conn.getResponseCode();
                Log.d((String)LOG_TAG, (String)("Sent exception file " + file.getName() + " to airbrake. Got response code " + String.valueOf(response)));
                sent = true;
            }
            catch (IOException e) {
                Log.v((String)LOG_TAG, (String)"Exception caught:", (Throwable)e);
            }
            finally {
                if (sent) {
                    file.delete();
                }
                conn.disconnect();
            }
        }
        catch (Exception e) {
            Log.v((String)LOG_TAG, (String)"Exception caught:", (Throwable)e);
        }
    }

    private static synchronized void flushExceptions() {
        File exceptionDir = new File(filePath);
        if (exceptionDir.exists() && exceptionDir.isDirectory()) {
            File[] exceptions;
            for (File f : exceptions = exceptionDir.listFiles()) {
                if (!f.exists() || !f.isFile()) continue;
                AirbrakeNotifier.sendExceptionData(f);
            }
        }
    }

    static {
        notifyOnlyProduction = false;
        diskStorageEnabled = false;
    }

    private static class AirbrakeExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private Thread.UncaughtExceptionHandler defaultExceptionHandler;

        public AirbrakeExceptionHandler(Thread.UncaughtExceptionHandler defaultExceptionHandlerIn) {
            this.defaultExceptionHandler = defaultExceptionHandlerIn;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            AirbrakeNotifier.notify(e);
            this.defaultExceptionHandler.uncaughtException(t, e);
        }
    }
}

