/*
 * Decompiled with CFR 0.152.
 */
package com.mottimotti.android.widget;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.widget.EditText;
import com.mottimotti.android.R;

public class TypeFaceEditText
extends EditText {
    public TypeFaceEditText(Context context) {
        super(context);
    }

    public TypeFaceEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.TypeFaceView);
        this.loadResources(array);
    }

    public TypeFaceEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.TypeFaceView, defStyle, 0);
        this.loadResources(array);
    }

    private void loadResources(TypedArray array) {
        String typefaceReference = array.getString(0);
        this.loadTypeface(typefaceReference);
    }

    public void loadTypeface(String typefaceReference) {
        if (typefaceReference == null) {
            return;
        }
        Typeface type = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)typefaceReference);
        this.setTypeface(type);
    }
}

