/*
 * Decompiled with CFR 0.152.
 */
package com.mottimotti.android.widget;

import android.util.MonthDisplayHelper;
import java.util.Calendar;

public class CalendarFilter {
    private final MonthDisplayHelper helper;
    private final int startDay;
    private final int endDay;

    public CalendarFilter(MonthDisplayHelper helper) {
        this.helper = helper;
        this.startDay = helper.getDayAt(0, 0);
        this.endDay = helper.getDayAt(5, 6);
    }

    public Calendar getStartCalendar() {
        return this.getFilters()[0];
    }

    public Calendar[] getFilters() {
        if (this.previousMonthVisible() && this.nextMonthVisible()) {
            return this.getFiltersForPastAndNextMonth();
        }
        if (this.previousMonthVisible() && !this.nextMonthVisible()) {
            return this.getFiltersForPastAndCurrentMonth();
        }
        if (!this.previousMonthVisible() && this.nextMonthVisible()) {
            return this.getFiltersForCurrentAndNext();
        }
        return this.getFiltersForCurrentMonth();
    }

    public boolean nextMonthVisible() {
        int daysInMonth;
        int firstDayInLastWeek = this.helper.getDayAt(5, 0);
        return firstDayInLastWeek + 6 != (daysInMonth = this.helper.getNumberOfDaysInMonth());
    }

    public boolean previousMonthVisible() {
        return this.helper.getOffset() > 0;
    }

    private Calendar[] getFiltersForPastAndNextMonth() {
        Calendar previousCalendar = this.getCurrentCalendar();
        previousCalendar.add(2, -1);
        previousCalendar.set(5, this.startDay);
        previousCalendar.getTimeInMillis();
        Calendar nextCalendar = this.getCurrentCalendar();
        nextCalendar.add(2, 1);
        nextCalendar.set(5, this.endDay);
        nextCalendar.getTimeInMillis();
        return new Calendar[]{previousCalendar, nextCalendar};
    }

    private Calendar[] getFiltersForPastAndCurrentMonth() {
        Calendar previousCalendar = this.getCurrentCalendar();
        previousCalendar.add(2, -1);
        previousCalendar.set(5, this.startDay);
        previousCalendar.getTimeInMillis();
        Calendar currentCalendar = this.getCurrentCalendar();
        currentCalendar.set(5, this.endDay);
        currentCalendar.getTimeInMillis();
        return new Calendar[]{previousCalendar, currentCalendar};
    }

    private Calendar[] getFiltersForCurrentAndNext() {
        Calendar currentCalendar = this.getCurrentCalendar();
        currentCalendar.set(5, this.startDay);
        currentCalendar.getTimeInMillis();
        Calendar nextCalendar = this.getCurrentCalendar();
        nextCalendar.add(2, 1);
        nextCalendar.set(5, this.endDay);
        nextCalendar.getTimeInMillis();
        return new Calendar[]{currentCalendar, nextCalendar};
    }

    private Calendar[] getFiltersForCurrentMonth() {
        Calendar startCalendar = this.getCurrentCalendar();
        startCalendar.set(5, this.startDay);
        startCalendar.getTimeInMillis();
        Calendar endCalendar = this.getCurrentCalendar();
        startCalendar.set(5, this.endDay);
        startCalendar.getTimeInMillis();
        return new Calendar[]{startCalendar, endCalendar};
    }

    private Calendar getCurrentCalendar() {
        Calendar currentCalendar = Calendar.getInstance();
        currentCalendar.set(1, this.helper.getYear());
        currentCalendar.set(2, this.helper.getMonth());
        currentCalendar.set(5, 1);
        currentCalendar.set(11, 0);
        currentCalendar.set(12, 0);
        currentCalendar.set(13, 0);
        currentCalendar.set(14, 0);
        currentCalendar.getTimeInMillis();
        return currentCalendar;
    }
}

