/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.TextView;
import java.util.Locale;

public class CapitalizingTextView
extends TextView {
    private static final boolean SANS_ICE_CREAM = Build.VERSION.SDK_INT < 14;
    private static final boolean IS_GINGERBREAD = Build.VERSION.SDK_INT >= 9;
    private static final int[] R_styleable_TextView = new int[]{16843660};
    private static final int R_styleable_TextView_textAllCaps = 0;
    private boolean mAllCaps;

    public CapitalizingTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CapitalizingTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R_styleable_TextView, defStyle, 0);
        this.mAllCaps = a.getBoolean(0, true);
        a.recycle();
    }

    public void setTextCompat(CharSequence text) {
        if (SANS_ICE_CREAM && this.mAllCaps && text != null) {
            if (IS_GINGERBREAD) {
                try {
                    this.setText(((Object)text).toString().toUpperCase(Locale.ROOT));
                }
                catch (NoSuchFieldError e) {
                    this.setText(((Object)text).toString().toUpperCase());
                }
            } else {
                this.setText(((Object)text).toString().toUpperCase());
            }
        } else {
            this.setText(text);
        }
    }
}

