/*
 * Decompiled with CFR 0.152.
 */
package com.svgandroid;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.Log;
import com.svgandroid.PathParser;
import com.svgandroid.SVG;
import com.svgandroid.SVGParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SVGParser {
    static final String TAG = "SVGAndroid";

    public static SVG getSVGFromInputStream(InputStream svgData) throws SVGParseException {
        return SVGParser.parse(svgData, 0, 0, false);
    }

    public static SVG getSVGFromInputStream(InputStream svgData, int targetWidth, int targetHeight) throws SVGParseException {
        return SVGParser.parse(svgData, 0, 0, false, targetWidth, targetHeight);
    }

    public static SVG getSVGFromResource(Resources resources, int resId) throws SVGParseException {
        return SVGParser.parse(resources.openRawResource(resId), 0, 0, false);
    }

    public static SVG getSVGFromAsset(AssetManager assetMngr, String svgPath) throws SVGParseException, IOException {
        InputStream inputStream = assetMngr.open(svgPath);
        SVG svg = SVGParser.getSVGFromInputStream(inputStream);
        inputStream.close();
        return svg;
    }

    public static SVG getSVGFromInputStream(InputStream svgData, int searchColor, int replaceColor, int targetWidth, int targetHeight) throws SVGParseException {
        return SVGParser.parse(svgData, searchColor, replaceColor, false, targetWidth, targetHeight);
    }

    public static SVG getSVGFromString(String svgData, int searchColor, int replaceColor) throws SVGParseException {
        return SVGParser.parse(new ByteArrayInputStream(svgData.getBytes()), searchColor, replaceColor, false);
    }

    public static SVG getSVGFromResource(Resources resources, int resId, int searchColor, int replaceColor) throws SVGParseException {
        return SVGParser.parse(resources.openRawResource(resId), searchColor, replaceColor, false);
    }

    public static SVG getSVGFromAsset(AssetManager assetMngr, String svgPath, int searchColor, int replaceColor) throws SVGParseException, IOException {
        InputStream inputStream = assetMngr.open(svgPath);
        SVG svg = SVGParser.getSVGFromInputStream(inputStream, searchColor, replaceColor);
        inputStream.close();
        return svg;
    }

    public static Path parsePath(String pathString) {
        return SVGParser.doPath(pathString);
    }

    private static SVG parse(InputStream in, Integer searchColor, Integer replaceColor, boolean whiteMode, int targetWidth, int targetHeight) throws SVGParseException {
        try {
            long start = System.currentTimeMillis();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            Picture picture = new Picture();
            SVGHandler handler = new SVGHandler(picture, targetWidth, targetHeight);
            handler.setColorSwap(searchColor, replaceColor);
            handler.setWhiteMode(whiteMode);
            xr.setContentHandler(handler);
            xr.parse(new InputSource(in));
            SVG result = new SVG(picture, handler.bounds);
            if (!Float.isInfinite(handler.limits.top)) {
                result.setLimits(handler.limits);
            }
            return result;
        }
        catch (Exception e) {
            throw new SVGParseException(e);
        }
    }

    private static SVG parse(InputStream in, Integer searchColor, Integer replaceColor, boolean whiteMode) throws SVGParseException {
        return SVGParser.parse(in, searchColor, replaceColor, whiteMode, 0, 0);
    }

    protected static NumberParse parseNumbers(String s) {
        int n = s.length();
        int p = 0;
        ArrayList<Float> numbers = new ArrayList<Float>();
        boolean skipChar = false;
        block6: for (int i = 1; i < n; ++i) {
            if (skipChar) {
                skipChar = false;
                continue;
            }
            char c = s.charAt(i);
            switch (c) {
                case ')': 
                case 'A': 
                case 'C': 
                case 'H': 
                case 'L': 
                case 'M': 
                case 'Q': 
                case 'S': 
                case 'T': 
                case 'V': 
                case 'Z': 
                case 'a': 
                case 'c': 
                case 'h': 
                case 'l': 
                case 'm': 
                case 'q': 
                case 's': 
                case 't': 
                case 'v': 
                case 'z': {
                    Float f;
                    String str = s.substring(p, i);
                    if (str.trim().length() > 0) {
                        f = Float.valueOf(Float.parseFloat(str));
                        numbers.add(f);
                    }
                    p = i;
                    return new NumberParse(numbers, p);
                }
                case '\t': 
                case '\n': 
                case ' ': 
                case ',': 
                case '-': {
                    Float f;
                    String str = s.substring(p, i);
                    if (str.trim().length() > 0) {
                        f = Float.valueOf(Float.parseFloat(str));
                        numbers.add(f);
                        if (c == '-') {
                            p = i;
                            continue block6;
                        }
                        p = i + 1;
                        skipChar = true;
                        continue block6;
                    }
                    ++p;
                    continue block6;
                }
            }
        }
        String last = s.substring(p);
        if (last.length() > 0) {
            try {
                numbers.add(Float.valueOf(Float.parseFloat(last)));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            p = s.length();
        }
        return new NumberParse(numbers, p);
    }

    private static Matrix parseTransform(String s) {
        NumberParse np;
        if (s.startsWith("matrix(")) {
            NumberParse np2 = SVGParser.parseNumbers(s.substring("matrix(".length()));
            if (np2.numbers.size() == 6) {
                Matrix matrix = new Matrix();
                matrix.setValues(new float[]{((Float)np2.numbers.get(0)).floatValue(), ((Float)np2.numbers.get(2)).floatValue(), ((Float)np2.numbers.get(4)).floatValue(), ((Float)np2.numbers.get(1)).floatValue(), ((Float)np2.numbers.get(3)).floatValue(), ((Float)np2.numbers.get(5)).floatValue(), 0.0f, 0.0f, 1.0f});
                return matrix;
            }
        } else if (s.startsWith("translate(")) {
            NumberParse np3 = SVGParser.parseNumbers(s.substring("translate(".length()));
            if (!np3.numbers.isEmpty()) {
                float tx = ((Float)np3.numbers.get(0)).floatValue();
                float ty = 0.0f;
                if (np3.numbers.size() > 1) {
                    ty = ((Float)np3.numbers.get(1)).floatValue();
                }
                Matrix matrix = new Matrix();
                matrix.postTranslate(tx, ty);
                return matrix;
            }
        } else if (s.startsWith("scale(")) {
            NumberParse np4 = SVGParser.parseNumbers(s.substring("scale(".length()));
            if (!np4.numbers.isEmpty()) {
                float sx = ((Float)np4.numbers.get(0)).floatValue();
                float sy = 0.0f;
                if (np4.numbers.size() > 1) {
                    sy = ((Float)np4.numbers.get(1)).floatValue();
                }
                Matrix matrix = new Matrix();
                matrix.postScale(sx, sy);
                return matrix;
            }
        } else if (s.startsWith("skewX(")) {
            NumberParse np5 = SVGParser.parseNumbers(s.substring("skewX(".length()));
            if (!np5.numbers.isEmpty()) {
                float angle = ((Float)np5.numbers.get(0)).floatValue();
                Matrix matrix = new Matrix();
                matrix.postSkew((float)Math.tan(angle), 0.0f);
                return matrix;
            }
        } else if (s.startsWith("skewY(")) {
            NumberParse np6 = SVGParser.parseNumbers(s.substring("skewY(".length()));
            if (!np6.numbers.isEmpty()) {
                float angle = ((Float)np6.numbers.get(0)).floatValue();
                Matrix matrix = new Matrix();
                matrix.postSkew(0.0f, (float)Math.tan(angle));
                return matrix;
            }
        } else if (s.startsWith("rotate(") && !(np = SVGParser.parseNumbers(s.substring("rotate(".length()))).numbers.isEmpty()) {
            float angle = ((Float)np.numbers.get(0)).floatValue();
            float cx = 0.0f;
            float cy = 0.0f;
            if (np.numbers.size() > 2) {
                cx = ((Float)np.numbers.get(1)).floatValue();
                cy = ((Float)np.numbers.get(2)).floatValue();
            }
            Matrix matrix = new Matrix();
            matrix.postTranslate(cx, cy);
            matrix.postRotate(angle);
            matrix.postTranslate(-cx, -cy);
            return matrix;
        }
        return null;
    }

    private static Path doPath(String s) {
        Path path = new Path();
        PathParser.parse(s, path);
        return path;
    }

    private static NumberParse getNumberParseAttr(String name, Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            if (!attributes.getLocalName(i).equals(name)) continue;
            return SVGParser.parseNumbers(attributes.getValue(i));
        }
        return null;
    }

    private static String getStringAttr(String name, Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            if (!attributes.getLocalName(i).equals(name)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    private static Float getFloatAttr(String name, Attributes attributes) {
        return SVGParser.getFloatAttr(name, attributes, null);
    }

    private static Float getFloatAttr(String name, Attributes attributes, Float defaultValue) {
        String v = SVGParser.getStringAttr(name, attributes);
        if (v == null) {
            return defaultValue;
        }
        if (v.endsWith("px")) {
            v = v.substring(0, v.length() - 2);
        }
        return Float.valueOf(Float.parseFloat(v));
    }

    protected static Integer getHexAttr(String name, Attributes attributes) {
        String v = SVGParser.getStringAttr(name, attributes);
        if (v == null) {
            return null;
        }
        try {
            return Integer.parseInt(v.substring(1), 16);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    protected static class SVGHandler
    extends DefaultHandler {
        Picture picture;
        Canvas canvas;
        Paint paint;
        RectF rect = new RectF();
        RectF bounds = null;
        RectF limits = new RectF(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Integer searchColor = null;
        Integer replaceColor = null;
        int targetWidth;
        int targetHeight;
        boolean whiteMode = false;
        boolean pushed = false;
        HashMap<String, Shader> gradientMap = new HashMap();
        HashMap<String, Gradient> gradientRefMap = new HashMap();
        Gradient gradient = null;
        private boolean hidden = false;
        private int hiddenLevel = 0;
        private boolean boundsMode = false;

        protected SVGHandler(Picture picture) {
            this.picture = picture;
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
        }

        protected SVGHandler(Picture picture, int targetWidth, int targetHeight) {
            this(picture);
            this.targetWidth = targetWidth;
            this.targetHeight = targetHeight;
        }

        public void setColorSwap(Integer searchColor, Integer replaceColor) {
            this.searchColor = searchColor;
            this.replaceColor = replaceColor;
        }

        public void setWhiteMode(boolean whiteMode) {
            this.whiteMode = whiteMode;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        protected boolean doFill(Properties atts, HashMap<String, Shader> gradients) {
            if ("none".equals(atts.getString("display"))) {
                return false;
            }
            if (this.whiteMode) {
                this.paint.setStyle(Paint.Style.FILL);
                this.paint.setColor(-1);
                return true;
            }
            String fillString = atts.getString("fill");
            if (fillString != null && fillString.startsWith("url(#")) {
                String id = fillString.substring("url(#".length(), fillString.length() - 1);
                Shader shader = gradients.get(id);
                if (shader != null) {
                    this.paint.setShader(shader);
                    this.paint.setStyle(Paint.Style.FILL);
                    return true;
                }
                return false;
            }
            this.paint.setShader(null);
            Integer color = atts.getHex("fill");
            if (color != null) {
                this.doColor(atts, color, true);
                this.paint.setStyle(Paint.Style.FILL);
                return true;
            }
            if (atts.getString("fill") == null && atts.getString("stroke") == null) {
                this.paint.setStyle(Paint.Style.FILL);
                this.paint.setColor(-16777216);
                return true;
            }
            return false;
        }

        protected boolean doStroke(Properties atts) {
            if (this.whiteMode) {
                return false;
            }
            if ("none".equals(atts.getString("display"))) {
                return false;
            }
            Integer color = atts.getHex("stroke");
            if (color != null) {
                String linecap;
                this.doColor(atts, color, false);
                Float width = atts.getFloat("stroke-width");
                if (width != null) {
                    this.paint.setStrokeWidth(width.floatValue());
                }
                if ("round".equals(linecap = atts.getString("stroke-linecap"))) {
                    this.paint.setStrokeCap(Paint.Cap.ROUND);
                } else if ("square".equals(linecap)) {
                    this.paint.setStrokeCap(Paint.Cap.SQUARE);
                } else if ("butt".equals(linecap)) {
                    this.paint.setStrokeCap(Paint.Cap.BUTT);
                }
                String linejoin = atts.getString("stroke-linejoin");
                if ("miter".equals(linejoin)) {
                    this.paint.setStrokeJoin(Paint.Join.MITER);
                } else if ("round".equals(linejoin)) {
                    this.paint.setStrokeJoin(Paint.Join.ROUND);
                } else if ("bevel".equals(linejoin)) {
                    this.paint.setStrokeJoin(Paint.Join.BEVEL);
                }
                this.paint.setStyle(Paint.Style.STROKE);
                return true;
            }
            return false;
        }

        private Gradient doGradient(boolean isLinear, Attributes atts) {
            String xlink;
            Gradient gradient = new Gradient();
            gradient.id = SVGParser.getStringAttr("id", atts);
            gradient.isLinear = isLinear;
            if (isLinear) {
                gradient.x1 = SVGParser.getFloatAttr("x1", atts, Float.valueOf(0.0f)).floatValue();
                gradient.x2 = SVGParser.getFloatAttr("x2", atts, Float.valueOf(0.0f)).floatValue();
                gradient.y1 = SVGParser.getFloatAttr("y1", atts, Float.valueOf(0.0f)).floatValue();
                gradient.y2 = SVGParser.getFloatAttr("y2", atts, Float.valueOf(0.0f)).floatValue();
            } else {
                gradient.x = SVGParser.getFloatAttr("cx", atts, Float.valueOf(0.0f)).floatValue();
                gradient.y = SVGParser.getFloatAttr("cy", atts, Float.valueOf(0.0f)).floatValue();
                gradient.radius = SVGParser.getFloatAttr("r", atts, Float.valueOf(0.0f)).floatValue();
            }
            String transform = SVGParser.getStringAttr("gradientTransform", atts);
            if (transform != null) {
                gradient.matrix = SVGParser.parseTransform(transform);
            }
            if ((xlink = SVGParser.getStringAttr("href", atts)) != null) {
                if (xlink.startsWith("#")) {
                    xlink = xlink.substring(1);
                }
                gradient.xlink = xlink;
            }
            return gradient;
        }

        private void doColor(Properties atts, Integer color, boolean fillMode) {
            int c = 0xFFFFFF & color | 0xFF000000;
            if (this.searchColor != null && this.searchColor == c) {
                c = this.replaceColor;
            }
            this.paint.setColor(c);
            Float opacity = atts.getFloat("opacity");
            if (opacity == null) {
                opacity = atts.getFloat(fillMode ? "fill-opacity" : "stroke-opacity");
            }
            if (opacity == null) {
                this.paint.setAlpha(255);
            } else {
                this.paint.setAlpha((int)(255.0f * opacity.floatValue()));
            }
        }

        private void doLimits(float x, float y) {
            if (x < this.limits.left) {
                this.limits.left = x;
            }
            if (x > this.limits.right) {
                this.limits.right = x;
            }
            if (y < this.limits.top) {
                this.limits.top = y;
            }
            if (y > this.limits.bottom) {
                this.limits.bottom = y;
            }
        }

        private void doLimits(float x, float y, float width, float height) {
            this.doLimits(x, y);
            this.doLimits(x + width, y + height);
        }

        private void doLimits(Path path) {
            path.computeBounds(this.rect, false);
            this.doLimits(this.rect.left, this.rect.top);
            this.doLimits(this.rect.right, this.rect.bottom);
        }

        private void pushTransform(Attributes atts) {
            String transform = SVGParser.getStringAttr("transform", atts);
            boolean bl = this.pushed = transform != null;
            if (this.pushed) {
                Matrix matrix = SVGParser.parseTransform(transform);
                this.canvas.save();
                this.canvas.concat(matrix);
            }
        }

        private void popTransform() {
            if (this.pushed) {
                this.canvas.restore();
            }
        }

        private Canvas beginRecordingPicture(int imageWidth, int imageHeight) {
            if (this.targetWidth == 0 || this.targetHeight == 0) {
                return this.picture.beginRecording(imageWidth, imageHeight);
            }
            Canvas canvas = this.picture.beginRecording(this.targetWidth, this.targetHeight);
            SVGHandler.prepareScaledCanvas(canvas, imageWidth, imageHeight);
            return canvas;
        }

        private static final void prepareScaledCanvas(Canvas canvas, float imageWidth, float imageHeight) {
            float scaleY;
            float scaleX = (float)canvas.getWidth() / imageWidth;
            if (scaleX > (scaleY = (float)canvas.getHeight() / imageHeight)) {
                float dx = (scaleX - scaleY) * imageWidth / 2.0f;
                canvas.translate(dx, 0.0f);
                canvas.scale(scaleY, scaleY);
            } else {
                float dy = (scaleY - scaleX) * imageHeight / 2.0f;
                canvas.translate(0.0f, dy);
                canvas.scale(scaleX, scaleX);
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.paint.setAlpha(255);
            if (this.boundsMode) {
                if (localName.equals("rect")) {
                    Float y;
                    Float x = SVGParser.getFloatAttr("x", atts);
                    if (x == null) {
                        x = Float.valueOf(0.0f);
                    }
                    if ((y = SVGParser.getFloatAttr("y", atts)) == null) {
                        y = Float.valueOf(0.0f);
                    }
                    Float width = SVGParser.getFloatAttr("width", atts);
                    Float height = SVGParser.getFloatAttr("height", atts);
                    this.bounds = new RectF(x.floatValue(), y.floatValue(), x.floatValue() + width.floatValue(), y.floatValue() + width.floatValue());
                }
                return;
            }
            if (localName.equals("svg")) {
                int imageWidth = (int)Math.ceil(SVGParser.getFloatAttr("width", atts).floatValue());
                int imageHeight = (int)Math.ceil(SVGParser.getFloatAttr("height", atts).floatValue());
                this.canvas = this.beginRecordingPicture(imageWidth, imageHeight);
            } else if (!localName.equals("defs")) {
                if (localName.equals("linearGradient")) {
                    this.gradient = this.doGradient(true, atts);
                } else if (localName.equals("radialGradient")) {
                    this.gradient = this.doGradient(false, atts);
                } else if (localName.equals("stop")) {
                    if (this.gradient != null) {
                        String opacityStyle;
                        float offset = SVGParser.getFloatAttr("offset", atts).floatValue();
                        String styles = SVGParser.getStringAttr("style", atts);
                        StyleSet styleSet = new StyleSet(styles);
                        String colorStyle = styleSet.getStyle("stop-color");
                        int color = -16777216;
                        if (colorStyle != null) {
                            color = colorStyle.startsWith("#") ? Integer.parseInt(colorStyle.substring(1), 16) : Integer.parseInt(colorStyle, 16);
                        }
                        if ((opacityStyle = styleSet.getStyle("stop-opacity")) != null) {
                            float alpha = Float.parseFloat(opacityStyle);
                            int alphaInt = Math.round(255.0f * alpha);
                            color |= alphaInt << 24;
                        } else {
                            color |= 0xFF000000;
                        }
                        this.gradient.positions.add(Float.valueOf(offset));
                        this.gradient.colors.add(color);
                    }
                } else if (localName.equals("g")) {
                    if ("bounds".equalsIgnoreCase(SVGParser.getStringAttr("id", atts))) {
                        this.boundsMode = true;
                    }
                    if (this.hidden) {
                        ++this.hiddenLevel;
                    }
                    if ("none".equals(SVGParser.getStringAttr("display", atts)) && !this.hidden) {
                        this.hidden = true;
                        this.hiddenLevel = 1;
                    }
                } else if (!this.hidden && localName.equals("rect")) {
                    Float y;
                    Float x = SVGParser.getFloatAttr("x", atts);
                    if (x == null) {
                        x = Float.valueOf(0.0f);
                    }
                    if ((y = SVGParser.getFloatAttr("y", atts)) == null) {
                        y = Float.valueOf(0.0f);
                    }
                    Float width = SVGParser.getFloatAttr("width", atts);
                    Float height = SVGParser.getFloatAttr("height", atts);
                    this.pushTransform(atts);
                    Properties props = new Properties(atts);
                    if (this.doFill(props, this.gradientMap)) {
                        this.doLimits(x.floatValue(), y.floatValue(), width.floatValue(), height.floatValue());
                        this.canvas.drawRect(x.floatValue(), y.floatValue(), x.floatValue() + width.floatValue(), y.floatValue() + height.floatValue(), this.paint);
                    }
                    if (this.doStroke(props)) {
                        this.canvas.drawRect(x.floatValue(), y.floatValue(), x.floatValue() + width.floatValue(), y.floatValue() + height.floatValue(), this.paint);
                    }
                    this.popTransform();
                } else if (!this.hidden && localName.equals("line")) {
                    Float x1 = SVGParser.getFloatAttr("x1", atts);
                    Float x2 = SVGParser.getFloatAttr("x2", atts);
                    Float y1 = SVGParser.getFloatAttr("y1", atts);
                    Float y2 = SVGParser.getFloatAttr("y2", atts);
                    Properties props = new Properties(atts);
                    if (this.doStroke(props)) {
                        this.pushTransform(atts);
                        this.doLimits(x1.floatValue(), y1.floatValue());
                        this.doLimits(x2.floatValue(), y2.floatValue());
                        this.canvas.drawLine(x1.floatValue(), y1.floatValue(), x2.floatValue(), y2.floatValue(), this.paint);
                        this.popTransform();
                    }
                } else if (!this.hidden && localName.equals("circle")) {
                    Float centerX = SVGParser.getFloatAttr("cx", atts);
                    Float centerY = SVGParser.getFloatAttr("cy", atts);
                    Float radius = SVGParser.getFloatAttr("r", atts);
                    if (centerX != null && centerY != null && radius != null) {
                        this.pushTransform(atts);
                        Properties props = new Properties(atts);
                        if (this.doFill(props, this.gradientMap)) {
                            this.doLimits(centerX.floatValue() - radius.floatValue(), centerY.floatValue() - radius.floatValue());
                            this.doLimits(centerX.floatValue() + radius.floatValue(), centerY.floatValue() + radius.floatValue());
                            this.canvas.drawCircle(centerX.floatValue(), centerY.floatValue(), radius.floatValue(), this.paint);
                        }
                        if (this.doStroke(props)) {
                            this.canvas.drawCircle(centerX.floatValue(), centerY.floatValue(), radius.floatValue(), this.paint);
                        }
                        this.popTransform();
                    }
                } else if (!this.hidden && localName.equals("ellipse")) {
                    Float centerX = SVGParser.getFloatAttr("cx", atts);
                    Float centerY = SVGParser.getFloatAttr("cy", atts);
                    Float radiusX = SVGParser.getFloatAttr("rx", atts);
                    Float radiusY = SVGParser.getFloatAttr("ry", atts);
                    if (centerX != null && centerY != null && radiusX != null && radiusY != null) {
                        this.pushTransform(atts);
                        Properties props = new Properties(atts);
                        this.rect.set(centerX.floatValue() - radiusX.floatValue(), centerY.floatValue() - radiusY.floatValue(), centerX.floatValue() + radiusX.floatValue(), centerY.floatValue() + radiusY.floatValue());
                        if (this.doFill(props, this.gradientMap)) {
                            this.doLimits(centerX.floatValue() - radiusX.floatValue(), centerY.floatValue() - radiusY.floatValue());
                            this.doLimits(centerX.floatValue() + radiusX.floatValue(), centerY.floatValue() + radiusY.floatValue());
                            this.canvas.drawOval(this.rect, this.paint);
                        }
                        if (this.doStroke(props)) {
                            this.canvas.drawOval(this.rect, this.paint);
                        }
                        this.popTransform();
                    }
                } else if (!this.hidden && (localName.equals("polygon") || localName.equals("polyline"))) {
                    NumberParse numbers = SVGParser.getNumberParseAttr("points", atts);
                    if (numbers != null) {
                        Path p = new Path();
                        ArrayList points = numbers.numbers;
                        if (points.size() > 1) {
                            this.pushTransform(atts);
                            Properties props = new Properties(atts);
                            p.moveTo(((Float)points.get(0)).floatValue(), ((Float)points.get(1)).floatValue());
                            for (int i = 2; i < points.size(); i += 2) {
                                float x = ((Float)points.get(i)).floatValue();
                                float y = ((Float)points.get(i + 1)).floatValue();
                                p.lineTo(x, y);
                            }
                            if (localName.equals("polygon")) {
                                p.close();
                            }
                            if (this.doFill(props, this.gradientMap)) {
                                this.doLimits(p);
                                this.canvas.drawPath(p, this.paint);
                            }
                            if (this.doStroke(props)) {
                                this.canvas.drawPath(p, this.paint);
                            }
                            this.popTransform();
                        }
                    }
                } else if (!this.hidden && localName.equals("path")) {
                    Path p = SVGParser.doPath(SVGParser.getStringAttr("d", atts));
                    this.pushTransform(atts);
                    Properties props = new Properties(atts);
                    if (this.doFill(props, this.gradientMap)) {
                        this.doLimits(p);
                        this.canvas.drawPath(p, this.paint);
                    }
                    if (this.doStroke(props)) {
                        this.canvas.drawPath(p, this.paint);
                    }
                    this.popTransform();
                } else if (!this.hidden) {
                    Log.d((String)SVGParser.TAG, (String)("UNRECOGNIZED SVG COMMAND: " + localName));
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("svg")) {
                this.picture.endRecording();
            } else if (localName.equals("linearGradient")) {
                if (this.gradient.id != null) {
                    Gradient parent;
                    if (this.gradient.xlink != null && (parent = this.gradientRefMap.get(this.gradient.xlink)) != null) {
                        this.gradient = parent.createChild(this.gradient);
                    }
                    int[] colors = new int[this.gradient.colors.size()];
                    for (int i = 0; i < colors.length; ++i) {
                        colors[i] = this.gradient.colors.get(i);
                    }
                    float[] positions = new float[this.gradient.positions.size()];
                    for (int i = 0; i < positions.length; ++i) {
                        positions[i] = this.gradient.positions.get(i).floatValue();
                    }
                    if (colors.length == 0) {
                        Log.d((String)"BAD", (String)"BAD");
                    }
                    LinearGradient g = new LinearGradient(this.gradient.x1, this.gradient.y1, this.gradient.x2, this.gradient.y2, colors, positions, Shader.TileMode.CLAMP);
                    if (this.gradient.matrix != null) {
                        g.setLocalMatrix(this.gradient.matrix);
                    }
                    this.gradientMap.put(this.gradient.id, (Shader)g);
                    this.gradientRefMap.put(this.gradient.id, this.gradient);
                }
            } else if (localName.equals("radialGradient")) {
                if (this.gradient.id != null) {
                    Gradient parent;
                    Gradient parent2;
                    if (this.gradient.xlink != null && (parent2 = this.gradientRefMap.get(this.gradient.xlink)) != null) {
                        this.gradient = parent2.createChild(this.gradient);
                    }
                    int[] colors = new int[this.gradient.colors.size()];
                    for (int i = 0; i < colors.length; ++i) {
                        colors[i] = this.gradient.colors.get(i);
                    }
                    float[] positions = new float[this.gradient.positions.size()];
                    for (int i = 0; i < positions.length; ++i) {
                        positions[i] = this.gradient.positions.get(i).floatValue();
                    }
                    if (this.gradient.xlink != null && (parent = this.gradientRefMap.get(this.gradient.xlink)) != null) {
                        this.gradient = parent.createChild(this.gradient);
                    }
                    RadialGradient g = new RadialGradient(this.gradient.x, this.gradient.y, this.gradient.radius, colors, positions, Shader.TileMode.CLAMP);
                    if (this.gradient.matrix != null) {
                        g.setLocalMatrix(this.gradient.matrix);
                    }
                    this.gradientMap.put(this.gradient.id, (Shader)g);
                    this.gradientRefMap.put(this.gradient.id, this.gradient);
                }
            } else if (localName.equals("g")) {
                if (this.boundsMode) {
                    this.boundsMode = false;
                }
                if (this.hidden) {
                    --this.hiddenLevel;
                    if (this.hiddenLevel == 0) {
                        this.hidden = false;
                    }
                }
                this.gradientMap.clear();
            }
        }
    }

    protected static class Properties {
        StyleSet styles = null;
        Attributes atts;

        protected Properties(Attributes atts) {
            this.atts = atts;
            String styleAttr = SVGParser.getStringAttr("style", atts);
            if (styleAttr != null) {
                this.styles = new StyleSet(styleAttr);
            }
        }

        public String getAttr(String name) {
            String v = null;
            if (this.styles != null) {
                v = this.styles.getStyle(name);
            }
            if (v == null) {
                v = SVGParser.getStringAttr(name, this.atts);
            }
            return v;
        }

        public String getString(String name) {
            return this.getAttr(name);
        }

        public Integer getHex(String name) {
            String v = this.getAttr(name);
            if (v == null || !v.startsWith("#")) {
                return null;
            }
            try {
                return Integer.parseInt(v.substring(1), 16);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        public Float getFloat(String name, float defaultValue) {
            Float v = this.getFloat(name);
            if (v == null) {
                return Float.valueOf(defaultValue);
            }
            return v;
        }

        public Float getFloat(String name) {
            String v = this.getAttr(name);
            if (v == null) {
                return null;
            }
            try {
                return Float.valueOf(Float.parseFloat(v));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    private static class StyleSet {
        HashMap<String, String> styleMap = new HashMap();

        private StyleSet(String string) {
            String[] styles;
            for (String s : styles = string.split(";")) {
                String[] style = s.split(":");
                if (style.length != 2) continue;
                this.styleMap.put(style[0], style[1]);
            }
        }

        public String getStyle(String name) {
            return this.styleMap.get(name);
        }
    }

    private static class Gradient {
        String id;
        String xlink;
        boolean isLinear;
        float x1;
        float y1;
        float x2;
        float y2;
        float x;
        float y;
        float radius;
        ArrayList<Float> positions = new ArrayList();
        ArrayList<Integer> colors = new ArrayList();
        Matrix matrix = null;

        private Gradient() {
        }

        public Gradient createChild(Gradient g) {
            Gradient child = new Gradient();
            child.id = g.id;
            child.xlink = this.id;
            child.isLinear = g.isLinear;
            child.x1 = g.x1;
            child.x2 = g.x2;
            child.y1 = g.y1;
            child.y2 = g.y2;
            child.x = g.x;
            child.y = g.y;
            child.radius = g.radius;
            child.positions = this.positions;
            child.colors = this.colors;
            child.matrix = this.matrix;
            if (g.matrix != null) {
                if (this.matrix == null) {
                    child.matrix = g.matrix;
                } else {
                    Matrix m = new Matrix(this.matrix);
                    m.preConcat(g.matrix);
                    child.matrix = m;
                }
            }
            return child;
        }
    }

    protected static class NumberParse {
        private ArrayList<Float> numbers;
        private int nextCmd;

        public NumberParse(ArrayList<Float> numbers, int nextCmd) {
            this.numbers = numbers;
            this.nextCmd = nextCmd;
        }

        public int getNextCmd() {
            return this.nextCmd;
        }

        public float getNumber(int index) {
            return this.numbers.get(index).floatValue();
        }
    }
}

