/*
 * Decompiled with CFR 0.152.
 */
package com.svgandroid;

import android.graphics.Path;
import com.svgandroid.ParserHelper;

public class PathParser {
    public static void parse(String pathString, Path p) {
        int n = pathString.length();
        ParserHelper ph = new ParserHelper(pathString, 0);
        ph.skipWhitespace();
        float lastX = 0.0f;
        float lastY = 0.0f;
        float lastX1 = 0.0f;
        float lastY1 = 0.0f;
        float subPathStartX = 0.0f;
        float subPathStartY = 0.0f;
        int prevCmd = 0;
        while (ph.pos < n) {
            int cmd = pathString.charAt(ph.pos);
            switch (cmd) {
                case 43: 
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (prevCmd == 109 || prevCmd == 77) {
                        cmd = (char)(prevCmd - 1);
                        break;
                    }
                    if (prevCmd == 99 || prevCmd == 67) {
                        cmd = prevCmd;
                        break;
                    }
                    if (prevCmd == 108 || prevCmd == 76) {
                        cmd = prevCmd;
                        break;
                    }
                }
                default: {
                    ph.advance();
                    prevCmd = cmd;
                }
            }
            boolean wasCurve = false;
            switch (cmd) {
                case 77: 
                case 109: {
                    float x = ph.nextFloat();
                    float y = ph.nextFloat();
                    if (cmd == 109) {
                        subPathStartX += x;
                        subPathStartY += y;
                        p.rMoveTo(x, y);
                        lastX += x;
                        lastY += y;
                        break;
                    }
                    subPathStartX = x;
                    subPathStartY = y;
                    p.moveTo(x, y);
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 90: 
                case 122: {
                    p.close();
                    p.moveTo(subPathStartX, subPathStartY);
                    lastX = subPathStartX;
                    lastY = subPathStartY;
                    lastX1 = subPathStartX;
                    lastY1 = subPathStartY;
                    wasCurve = true;
                    break;
                }
                case 76: 
                case 108: {
                    float x = ph.nextFloat();
                    float y = ph.nextFloat();
                    if (cmd == 108) {
                        p.rLineTo(x, y);
                        lastX += x;
                        lastY += y;
                        break;
                    }
                    p.lineTo(x, y);
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 72: 
                case 104: {
                    float x = ph.nextFloat();
                    if (cmd == 104) {
                        p.rLineTo(x, 0.0f);
                        lastX += x;
                        break;
                    }
                    p.lineTo(x, lastY);
                    lastX = x;
                    break;
                }
                case 86: 
                case 118: {
                    float y = ph.nextFloat();
                    if (cmd == 118) {
                        p.rLineTo(0.0f, y);
                        lastY += y;
                        break;
                    }
                    p.lineTo(lastX, y);
                    lastY = y;
                    break;
                }
                case 67: 
                case 99: {
                    wasCurve = true;
                    float x1 = ph.nextFloat();
                    float y1 = ph.nextFloat();
                    float x2 = ph.nextFloat();
                    float y2 = ph.nextFloat();
                    float x = ph.nextFloat();
                    float y = ph.nextFloat();
                    if (cmd == 99) {
                        x1 += lastX;
                        x2 += lastX;
                        x += lastX;
                        y1 += lastY;
                        y2 += lastY;
                        y += lastY;
                    }
                    p.cubicTo(x1, y1, x2, y2, x, y);
                    lastX1 = x2;
                    lastY1 = y2;
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 83: 
                case 115: {
                    wasCurve = true;
                    float x2 = ph.nextFloat();
                    float y2 = ph.nextFloat();
                    float x = ph.nextFloat();
                    float y = ph.nextFloat();
                    if (cmd == 115) {
                        x2 += lastX;
                        x += lastX;
                        y2 += lastY;
                        y += lastY;
                    }
                    float x1 = 2.0f * lastX - lastX1;
                    float y1 = 2.0f * lastY - lastY1;
                    p.cubicTo(x1, y1, x2, y2, x, y);
                    lastX1 = x2;
                    lastY1 = y2;
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 65: 
                case 97: {
                    float rx = ph.nextFloat();
                    float ry = ph.nextFloat();
                    float theta = ph.nextFloat();
                    int largeArc = (int)ph.nextFloat();
                    int sweepArc = (int)ph.nextFloat();
                    float x = ph.nextFloat();
                    float y = ph.nextFloat();
                    PathParser.drawArc(p, lastX, lastY, x, y, rx, ry, theta, largeArc, sweepArc);
                    lastX = x;
                    lastY = y;
                    break;
                }
            }
            if (!wasCurve) {
                lastX1 = lastX;
                lastY1 = lastY;
            }
            ph.skipWhitespace();
        }
    }

    private static void drawArc(Path p, float lastX, float lastY, float x, float y, float rx, float ry, float theta, int largeArc, int sweepArc) {
    }
}

