/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.support.annotation.NonNull;
import com.mopub.common.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

abstract class TaskManager<T> {
    @NonNull
    protected final TaskManagerListener<T> mImageTaskManagerListener;
    protected final int mSize;
    @NonNull
    protected final Map<String, T> mResults;
    @NonNull
    protected final AtomicInteger mCompletedCount;
    @NonNull
    protected final AtomicBoolean mFailed;

    TaskManager(@NonNull List<String> urls, @NonNull TaskManagerListener<T> imageTaskManagerListener) throws IllegalArgumentException {
        Preconditions.checkNotNull(urls, "Urls list cannot be null");
        Preconditions.checkNotNull(imageTaskManagerListener, "ImageTaskManagerListener cannot be null");
        Preconditions.checkState(!urls.contains(null), "Urls list cannot contain null");
        this.mSize = urls.size();
        this.mImageTaskManagerListener = imageTaskManagerListener;
        this.mCompletedCount = new AtomicInteger(0);
        this.mFailed = new AtomicBoolean(false);
        this.mResults = Collections.synchronizedMap(new HashMap(this.mSize));
    }

    abstract void execute();

    static interface TaskManagerListener<T> {
        public void onSuccess(@NonNull Map<String, T> var1);

        public void onFail();
    }
}

