/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.mopub.common.Preconditions;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Views;

class SpinningProgressView
extends ViewGroup {
    @NonNull
    private final ProgressBar mProgressBar;
    private int mProgressIndicatorRadius;

    SpinningProgressView(@NonNull Context context) {
        super(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        params.gravity = 17;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setVisibility(8);
        this.setBackgroundColor(-16777216);
        this.getBackground().setAlpha(180);
        this.mProgressBar = new ProgressBar(context);
        this.mProgressIndicatorRadius = Dips.asIntPixels(25.0f, this.getContext());
        this.mProgressBar.setIndeterminate(true);
        this.addView((View)this.mProgressBar);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (changed) {
            int centerX = (left + right) / 2;
            int centerY = (top + bottom) / 2;
            this.mProgressBar.layout(centerX - this.mProgressIndicatorRadius, centerY - this.mProgressIndicatorRadius, centerX + this.mProgressIndicatorRadius, centerY + this.mProgressIndicatorRadius);
        }
    }

    boolean addToRoot(@NonNull View view) {
        Preconditions.checkNotNull(view);
        View rootView = view.getRootView();
        if (rootView != null && rootView instanceof ViewGroup) {
            ViewGroup rootViewGroup = (ViewGroup)rootView;
            this.setVisibility(0);
            this.setMeasuredDimension(rootView.getWidth(), rootView.getHeight());
            rootViewGroup.addView((View)this);
            this.forceLayout();
            return true;
        }
        return false;
    }

    boolean removeFromRoot() {
        Views.removeFromParent((View)this);
        this.setVisibility(8);
        return true;
    }
}

