/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.nativeads.MoPubNativeAdPositioning;
import com.mopub.nativeads.PositioningRequest;
import com.mopub.nativeads.PositioningSource;
import com.mopub.nativeads.PositioningUrlGenerator;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.MoPubRequestQueue;
import com.mopub.network.Networking;
import com.mopub.volley.Request;
import com.mopub.volley.Response;
import com.mopub.volley.VolleyError;

class ServerPositioningSource
implements PositioningSource {
    private static final double DEFAULT_RETRY_TIME_MILLISECONDS = 1000.0;
    private static final double EXPONENTIAL_BACKOFF_FACTOR = 2.0;
    private static final int MAXIMUM_RETRY_TIME_MILLISECONDS = 300000;
    private int mMaximumRetryTimeMillis = 300000;
    @NonNull
    private final Context mContext;
    @NonNull
    private final Handler mRetryHandler;
    @NonNull
    private final Runnable mRetryRunnable;
    private final Response.Listener<MoPubNativeAdPositioning.MoPubClientPositioning> mPositioningListener;
    private final Response.ErrorListener mErrorListener;
    @Nullable
    private PositioningSource.PositioningListener mListener;
    private int mRetryCount;
    @Nullable
    private String mRetryUrl;
    @Nullable
    private PositioningRequest mRequest;

    ServerPositioningSource(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.mRetryHandler = new Handler();
        this.mRetryRunnable = new Runnable(){

            @Override
            public void run() {
                ServerPositioningSource.this.requestPositioningInternal();
            }
        };
        this.mPositioningListener = new Response.Listener<MoPubNativeAdPositioning.MoPubClientPositioning>(){

            public void onResponse(MoPubNativeAdPositioning.MoPubClientPositioning clientPositioning) {
                ServerPositioningSource.this.handleSuccess(clientPositioning);
            }
        };
        this.mErrorListener = new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (!(error instanceof MoPubNetworkError) || ((MoPubNetworkError)error).getReason().equals((Object)MoPubNetworkError.Reason.WARMING_UP)) {
                    MoPubLog.e("Failed to load positioning data", (Throwable)error);
                    if (error.networkResponse == null && !DeviceUtils.isNetworkAvailable(ServerPositioningSource.this.mContext)) {
                        MoPubLog.c(String.valueOf(MoPubErrorCode.NO_CONNECTION.toString()));
                    }
                }
                ServerPositioningSource.this.handleFailure();
            }
        };
    }

    @Override
    public void loadPositions(@NonNull String adUnitId, @NonNull PositioningSource.PositioningListener listener) {
        if (this.mRequest != null) {
            this.mRequest.cancel();
            this.mRequest = null;
        }
        if (this.mRetryCount > 0) {
            this.mRetryHandler.removeCallbacks(this.mRetryRunnable);
            this.mRetryCount = 0;
        }
        this.mListener = listener;
        this.mRetryUrl = new PositioningUrlGenerator(this.mContext).withAdUnitId(adUnitId).generateUrlString("ads.mopub.com");
        this.requestPositioningInternal();
    }

    private void requestPositioningInternal() {
        MoPubLog.d("Loading positioning from: " + this.mRetryUrl);
        this.mRequest = new PositioningRequest(this.mRetryUrl, this.mPositioningListener, this.mErrorListener);
        MoPubRequestQueue requestQueue = Networking.getRequestQueue(this.mContext);
        requestQueue.add((Request)this.mRequest);
    }

    private void handleSuccess(@NonNull MoPubNativeAdPositioning.MoPubClientPositioning positioning) {
        if (this.mListener != null) {
            this.mListener.onLoad(positioning);
        }
        this.mListener = null;
        this.mRetryCount = 0;
    }

    private void handleFailure() {
        double multiplier = Math.pow(2.0, this.mRetryCount + 1);
        int delay = (int)(1000.0 * multiplier);
        if (delay >= this.mMaximumRetryTimeMillis) {
            MoPubLog.d("Error downloading positioning information");
            if (this.mListener != null) {
                this.mListener.onFailed();
            }
            this.mListener = null;
            return;
        }
        ++this.mRetryCount;
        this.mRetryHandler.postDelayed(this.mRetryRunnable, (long)delay);
    }

    @Deprecated
    @VisibleForTesting
    void setMaximumRetryTimeMilliseconds(int millis) {
        this.mMaximumRetryTimeMillis = millis;
    }
}

