/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.VideoView;
import com.mopub.common.Preconditions;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlHandler;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.BaseVideoViewController;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.nativeads.NativeFullScreenVideoView;
import com.mopub.nativeads.NativeVideoController;

@TargetApi(value=16)
public class NativeVideoViewController
extends BaseVideoViewController
implements TextureView.SurfaceTextureListener,
NativeVideoController.Listener,
AudioManager.OnAudioFocusChangeListener {
    @NonNull
    public static final String NATIVE_VIDEO_ID = "native_video_id";
    @NonNull
    public static final String NATIVE_VAST_VIDEO_CONFIG = "native_vast_video_config";
    @NonNull
    private VideoState mVideoState;
    @NonNull
    private VastVideoConfig mVastVideoConfig;
    @NonNull
    private final NativeFullScreenVideoView mFullScreenVideoView;
    @NonNull
    private final NativeVideoController mNativeVideoController;
    @Nullable
    private Bitmap mCachedVideoFrame;
    private boolean mEnded;
    private boolean mError;
    private int mLatestVideoControllerState;

    public NativeVideoViewController(@NonNull Context context, @NonNull Bundle intentExtras, @NonNull Bundle savedInstanceState, @NonNull BaseVideoViewController.BaseVideoViewControllerListener baseVideoViewControllerListener) {
        this(context, intentExtras, savedInstanceState, baseVideoViewControllerListener, new NativeFullScreenVideoView(context, context.getResources().getConfiguration().orientation, ((VastVideoConfig)intentExtras.get(NATIVE_VAST_VIDEO_CONFIG)).getCustomCtaText()));
    }

    @VisibleForTesting
    NativeVideoViewController(@NonNull Context context, @NonNull Bundle intentExtras, @NonNull Bundle savedInstanceState, @NonNull BaseVideoViewController.BaseVideoViewControllerListener baseVideoViewControllerListener, @NonNull NativeFullScreenVideoView fullScreenVideoView) {
        super(context, null, baseVideoViewControllerListener);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(intentExtras);
        Preconditions.checkNotNull(baseVideoViewControllerListener);
        Preconditions.checkNotNull((Object)fullScreenVideoView);
        this.mVideoState = VideoState.NONE;
        this.mVastVideoConfig = (VastVideoConfig)intentExtras.get(NATIVE_VAST_VIDEO_CONFIG);
        this.mFullScreenVideoView = fullScreenVideoView;
        long videoId = (Long)intentExtras.get(NATIVE_VIDEO_ID);
        this.mNativeVideoController = NativeVideoController.getForId(videoId);
        Preconditions.checkNotNull(this.mVastVideoConfig);
        Preconditions.checkNotNull(this.mNativeVideoController);
    }

    @Override
    protected VideoView getVideoView() {
        return null;
    }

    @Override
    protected void onCreate() {
        this.mFullScreenVideoView.setSurfaceTextureListener(this);
        this.mFullScreenVideoView.setMode(NativeFullScreenVideoView.Mode.LOADING);
        this.mFullScreenVideoView.setPlayControlClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NativeVideoViewController.this.mEnded) {
                    NativeVideoViewController.this.mEnded = false;
                    NativeVideoViewController.this.mFullScreenVideoView.resetProgress();
                    NativeVideoViewController.this.mNativeVideoController.seekTo(0L);
                }
                NativeVideoViewController.this.applyState(VideoState.PLAYING);
            }
        });
        this.mFullScreenVideoView.setCloseControlListener(new View.OnClickListener(){

            public void onClick(View v) {
                NativeVideoViewController.this.applyState(VideoState.PAUSED, true);
                NativeVideoViewController.this.getBaseVideoViewControllerListener().onFinish();
            }
        });
        this.mFullScreenVideoView.setCtaClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NativeVideoViewController.this.mNativeVideoController.setPlayWhenReady(false);
                NativeVideoViewController.this.mCachedVideoFrame = NativeVideoViewController.this.mFullScreenVideoView.getTextureView().getBitmap();
                NativeVideoViewController.this.mNativeVideoController.handleCtaClick((Context)((Activity)NativeVideoViewController.this.getContext()));
            }
        });
        this.mFullScreenVideoView.setPrivacyInformationClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NativeVideoViewController.this.mNativeVideoController.setPlayWhenReady(false);
                NativeVideoViewController.this.mCachedVideoFrame = NativeVideoViewController.this.mFullScreenVideoView.getTextureView().getBitmap();
                new UrlHandler.Builder().withSupportedUrlActions(UrlAction.OPEN_IN_APP_BROWSER, new UrlAction[0]).build().handleUrl(NativeVideoViewController.this.getContext(), "https://www.mopub.com/optout/");
            }
        });
        ViewGroup.LayoutParams adViewLayout = new ViewGroup.LayoutParams(-1, -1);
        this.mFullScreenVideoView.setLayoutParams(adViewLayout);
        this.getBaseVideoViewControllerListener().onSetContentView((View)this.mFullScreenVideoView);
        this.mNativeVideoController.setProgressListener(new NativeVideoController.NativeVideoProgressRunnable.ProgressListener(){

            @Override
            public void updateProgress(int progressTenthPercent) {
                NativeVideoViewController.this.mFullScreenVideoView.updateProgress(progressTenthPercent);
            }
        });
    }

    @Override
    protected void onResume() {
        if (this.mCachedVideoFrame != null) {
            this.mFullScreenVideoView.setCachedVideoFrame(this.mCachedVideoFrame);
        }
        this.mNativeVideoController.prepare(this);
        this.mNativeVideoController.setListener(this);
        this.mNativeVideoController.setOnAudioFocusChangeListener(this);
    }

    @Override
    protected void onPause() {
    }

    @Override
    protected void onDestroy() {
    }

    @Override
    protected void onSaveInstanceState(@NonNull Bundle outState) {
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        this.mFullScreenVideoView.setOrientation(configuration.orientation);
    }

    @Override
    protected void onBackPressed() {
        this.applyState(VideoState.PAUSED, true);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mNativeVideoController.setTextureView(this.mFullScreenVideoView.getTextureView());
        if (!this.mEnded) {
            this.mNativeVideoController.seekTo(this.mNativeVideoController.getCurrentPosition());
        }
        this.mNativeVideoController.setPlayWhenReady(!this.mEnded);
        long currentPosition = this.mNativeVideoController.getCurrentPosition();
        long duration = this.mNativeVideoController.getDuration();
        long remaining = duration - currentPosition;
        if (remaining < 750L) {
            this.mEnded = true;
            this.maybeChangeState();
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.mNativeVideoController.release(this);
        this.applyState(VideoState.PAUSED);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    @Override
    public void onStateChanged(boolean playWhenReady, int playbackState) {
        this.mLatestVideoControllerState = playbackState;
        this.maybeChangeState();
    }

    @Override
    public void onError(Exception e) {
        MoPubLog.w("Error playing back video.", e);
        this.mError = true;
        this.maybeChangeState();
    }

    public void onAudioFocusChange(int focusChange) {
        if (focusChange == -1 || focusChange == -2) {
            this.applyState(VideoState.PAUSED);
        } else if (focusChange == -3) {
            this.mNativeVideoController.setAudioVolume(0.3f);
        } else if (focusChange == 1) {
            this.mNativeVideoController.setAudioVolume(1.0f);
            this.maybeChangeState();
        }
    }

    private void maybeChangeState() {
        VideoState newState = this.mVideoState;
        if (this.mError) {
            newState = VideoState.FAILED_LOAD;
        } else if (this.mEnded) {
            newState = VideoState.ENDED;
        } else if (this.mLatestVideoControllerState == 2 || this.mLatestVideoControllerState == 1) {
            newState = VideoState.LOADING;
        } else if (this.mLatestVideoControllerState == 3) {
            newState = VideoState.BUFFERING;
        } else if (this.mLatestVideoControllerState == 4) {
            newState = VideoState.PLAYING;
        } else if (this.mLatestVideoControllerState == 5 || this.mLatestVideoControllerState == 6) {
            newState = VideoState.ENDED;
        }
        this.applyState(newState);
    }

    @VisibleForTesting
    void applyState(@NonNull VideoState videoState) {
        this.applyState(videoState, false);
    }

    @VisibleForTesting
    void applyState(@NonNull VideoState videoState, boolean transitionToInline) {
        Preconditions.checkNotNull((Object)videoState);
        if (this.mVideoState == videoState) {
            return;
        }
        switch (videoState) {
            case FAILED_LOAD: {
                this.mNativeVideoController.setPlayWhenReady(false);
                this.mNativeVideoController.setAudioEnabled(false);
                this.mNativeVideoController.setAppAudioEnabled(false);
                this.mFullScreenVideoView.setMode(NativeFullScreenVideoView.Mode.LOADING);
                this.mVastVideoConfig.handleError(this.getContext(), null, 0);
                break;
            }
            case LOADING: 
            case BUFFERING: {
                this.mNativeVideoController.setPlayWhenReady(true);
                this.mFullScreenVideoView.setMode(NativeFullScreenVideoView.Mode.LOADING);
                break;
            }
            case PLAYING: {
                this.mNativeVideoController.setPlayWhenReady(true);
                this.mNativeVideoController.setAudioEnabled(true);
                this.mNativeVideoController.setAppAudioEnabled(true);
                this.mFullScreenVideoView.setMode(NativeFullScreenVideoView.Mode.PLAYING);
                break;
            }
            case PAUSED: {
                if (!transitionToInline) {
                    this.mNativeVideoController.setAppAudioEnabled(false);
                }
                this.mNativeVideoController.setPlayWhenReady(false);
                this.mFullScreenVideoView.setMode(NativeFullScreenVideoView.Mode.PAUSED);
                break;
            }
            case ENDED: {
                this.mEnded = true;
                this.mNativeVideoController.setAppAudioEnabled(false);
                this.mFullScreenVideoView.updateProgress(1000);
                this.mFullScreenVideoView.setMode(NativeFullScreenVideoView.Mode.FINISHED);
                this.mVastVideoConfig.handleComplete(this.getContext(), 0);
                break;
            }
        }
        this.mVideoState = videoState;
    }

    @Deprecated
    @VisibleForTesting
    NativeFullScreenVideoView getNativeFullScreenVideoView() {
        return this.mFullScreenVideoView;
    }

    @Deprecated
    @VisibleForTesting
    VideoState getVideoState() {
        return this.mVideoState;
    }

    static enum VideoState {
        NONE,
        LOADING,
        BUFFERING,
        PAUSED,
        PLAYING,
        ENDED,
        FAILED_LOAD;

    }
}

