/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorSampleSource;
import com.google.android.exoplayer.extractor.mp4.Mp4Extractor;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.event.BaseEvent;
import com.mopub.common.event.Event;
import com.mopub.common.event.EventDetails;
import com.mopub.common.event.MoPubEvents;
import com.mopub.mobileads.RepeatingHandlerRunnable;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.nativeads.HttpDiskCompositeDataSource;
import com.mopub.nativeads.VisibilityTracker;
import com.mopub.network.TrackingRequest;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TargetApi(value=16)
public class NativeVideoController
implements ExoPlayer.Listener,
AudioManager.OnAudioFocusChangeListener {
    @NonNull
    private static final Map<Long, NativeVideoController> sManagerMap = new HashMap<Long, NativeVideoController>(4);
    public static final int STATE_READY = 4;
    public static final int STATE_BUFFERING = 3;
    public static final int STATE_IDLE = 1;
    public static final int STATE_PREPARING = 2;
    public static final int STATE_ENDED = 5;
    public static final int STATE_CLEARED = 6;
    public static final long RESUME_FINISHED_THRESHOLD = 750L;
    private static final int BUFFER_SEGMENT_SIZE = 65536;
    private static final int BUFFER_SEGMENT_COUNT = 32;
    @NonNull
    private final Context mContext;
    @NonNull
    private final Handler mHandler;
    @NonNull
    private final ExoPlayerFactory mExoPlayerFactory;
    @NonNull
    private VastVideoConfig mVastVideoConfig;
    @NonNull
    private NativeVideoProgressRunnable mNativeVideoProgressRunnable;
    @NonNull
    private AudioManager mAudioManager;
    @Nullable
    private Listener mListener;
    @Nullable
    private AudioManager.OnAudioFocusChangeListener mOnAudioFocusChangeListener;
    @Nullable
    private Surface mSurface;
    @Nullable
    private TextureView mTextureView;
    @Nullable
    private WeakReference<Object> mOwnerRef;
    @Nullable
    private volatile ExoPlayer mExoPlayer;
    @Nullable
    private BitmapDrawable mFinalFrame;
    @Nullable
    private MediaCodecAudioTrackRenderer mAudioTrackRenderer;
    @Nullable
    private MediaCodecVideoTrackRenderer mVideoTrackRenderer;
    @Nullable
    private EventDetails mEventDetails;
    private boolean mPlayWhenReady;
    private boolean mAudioEnabled;
    private boolean mAppAudioEnabled;
    private int mPreviousExoPlayerState = 1;
    private boolean mExoPlayerStateStartedFromIdle = true;

    @NonNull
    public static NativeVideoController createForId(long id, @NonNull Context context, @NonNull List<VisibilityTrackingEvent> visibilityTrackingEvents, @NonNull VastVideoConfig vastVideoConfig, @Nullable EventDetails eventDetails) {
        NativeVideoController nvc = new NativeVideoController(context, visibilityTrackingEvents, vastVideoConfig, eventDetails);
        sManagerMap.put(id, nvc);
        return nvc;
    }

    @NonNull
    @VisibleForTesting
    public static NativeVideoController createForId(long id, @NonNull Context context, @NonNull VastVideoConfig vastVideoConfig, @NonNull NativeVideoProgressRunnable nativeVideoProgressRunnable, @NonNull ExoPlayerFactory exoPlayerFactory, @Nullable EventDetails eventDetails, @NonNull AudioManager audioManager) {
        NativeVideoController nvc = new NativeVideoController(context, vastVideoConfig, nativeVideoProgressRunnable, exoPlayerFactory, eventDetails, audioManager);
        sManagerMap.put(id, nvc);
        return nvc;
    }

    @VisibleForTesting
    static void setForId(long id, @NonNull NativeVideoController nativeVideoController) {
        sManagerMap.put(id, nativeVideoController);
    }

    @Nullable
    public static NativeVideoController getForId(long id) {
        return sManagerMap.get(id);
    }

    @Nullable
    public static NativeVideoController remove(long id) {
        return sManagerMap.remove(id);
    }

    private NativeVideoController(@NonNull Context context, @NonNull List<VisibilityTrackingEvent> visibilityTrackingEvents, @NonNull VastVideoConfig vastVideoConfig, @Nullable EventDetails eventDetails) {
        this(context, vastVideoConfig, new NativeVideoProgressRunnable(context, new Handler(Looper.getMainLooper()), visibilityTrackingEvents, vastVideoConfig), new ExoPlayerFactory(), eventDetails, (AudioManager)context.getSystemService("audio"));
    }

    private NativeVideoController(@NonNull Context context, @NonNull VastVideoConfig vastVideoConfig, @NonNull NativeVideoProgressRunnable nativeVideoProgressRunnable, @NonNull ExoPlayerFactory exoPlayerFactory, @Nullable EventDetails eventDetails, @NonNull AudioManager audioManager) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(vastVideoConfig);
        Preconditions.checkNotNull(exoPlayerFactory);
        Preconditions.checkNotNull(audioManager);
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mVastVideoConfig = vastVideoConfig;
        this.mNativeVideoProgressRunnable = nativeVideoProgressRunnable;
        this.mExoPlayerFactory = exoPlayerFactory;
        this.mEventDetails = eventDetails;
        this.mAudioManager = audioManager;
    }

    public void setListener(@Nullable Listener listener) {
        this.mListener = listener;
    }

    public void setProgressListener(@Nullable NativeVideoProgressRunnable.ProgressListener progressListener) {
        this.mNativeVideoProgressRunnable.setProgressListener(progressListener);
    }

    public void setOnAudioFocusChangeListener(@Nullable AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener) {
        this.mOnAudioFocusChangeListener = onAudioFocusChangeListener;
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        if (this.mPlayWhenReady == playWhenReady) {
            return;
        }
        this.mPlayWhenReady = playWhenReady;
        this.setExoPlayWhenReady();
    }

    public int getPlaybackState() {
        if (this.mExoPlayer == null) {
            return 6;
        }
        return this.mExoPlayer.getPlaybackState();
    }

    public void setAudioEnabled(boolean audioEnabled) {
        this.mAudioEnabled = audioEnabled;
        this.setExoAudio();
    }

    public void setAppAudioEnabled(boolean audioEnabled) {
        if (this.mAppAudioEnabled == audioEnabled) {
            return;
        }
        this.mAppAudioEnabled = audioEnabled;
        if (this.mAppAudioEnabled) {
            this.mAudioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 1);
        } else {
            this.mAudioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
        }
    }

    public void setAudioVolume(float volume) {
        if (!this.mAudioEnabled) {
            return;
        }
        this.setExoAudio(volume);
    }

    public void onAudioFocusChange(int focusChange) {
        if (this.mOnAudioFocusChangeListener == null) {
            return;
        }
        this.mOnAudioFocusChangeListener.onAudioFocusChange(focusChange);
    }

    public void setTextureView(@NonNull TextureView textureView) {
        Preconditions.checkNotNull(textureView);
        this.mSurface = new Surface(textureView.getSurfaceTexture());
        this.mTextureView = textureView;
        this.mNativeVideoProgressRunnable.setTextureView(this.mTextureView);
        this.setExoSurface(this.mSurface);
    }

    public void prepare(@NonNull Object owner) {
        Preconditions.checkNotNull(owner);
        this.mOwnerRef = new WeakReference<Object>(owner);
        this.clearExistingPlayer();
        this.preparePlayer();
        this.setExoSurface(this.mSurface);
    }

    public void clear() {
        this.setPlayWhenReady(false);
        this.mSurface = null;
        this.clearExistingPlayer();
    }

    public void release(@NonNull Object owner) {
        Object object;
        Preconditions.checkNotNull(owner);
        Object v0 = object = this.mOwnerRef == null ? null : this.mOwnerRef.get();
        if (object == owner) {
            this.clearExistingPlayer();
        }
    }

    public void onPlayerStateChanged(boolean playWhenReady, int newState) {
        if (newState == 5 && this.mFinalFrame == null) {
            this.mFinalFrame = new BitmapDrawable(this.mContext.getResources(), this.mTextureView.getBitmap());
            this.mNativeVideoProgressRunnable.requestStop();
        }
        if (this.mPreviousExoPlayerState == 4 && newState == 3) {
            MoPubEvents.log(Event.createEventFromDetails(BaseEvent.Name.DOWNLOAD_BUFFERING, BaseEvent.Category.NATIVE_VIDEO, BaseEvent.SamplingRate.NATIVE_VIDEO, this.mEventDetails));
        }
        if (this.mExoPlayerStateStartedFromIdle && this.mPreviousExoPlayerState == 3 && newState == 4) {
            MoPubEvents.log(Event.createEventFromDetails(BaseEvent.Name.DOWNLOAD_VIDEO_READY, BaseEvent.Category.NATIVE_VIDEO, BaseEvent.SamplingRate.NATIVE_VIDEO, this.mEventDetails));
        }
        this.mPreviousExoPlayerState = newState;
        if (newState == 4) {
            this.mExoPlayerStateStartedFromIdle = false;
        } else if (newState == 1) {
            this.mExoPlayerStateStartedFromIdle = true;
        }
        if (this.mListener != null) {
            this.mListener.onStateChanged(playWhenReady, newState);
        }
    }

    public void seekTo(long ms) {
        if (this.mExoPlayer == null) {
            return;
        }
        this.mExoPlayer.seekTo(ms);
        this.mNativeVideoProgressRunnable.seekTo(ms);
    }

    public long getCurrentPosition() {
        return this.mNativeVideoProgressRunnable.getCurrentPosition();
    }

    public long getDuration() {
        return this.mNativeVideoProgressRunnable.getDuration();
    }

    public void onPlayWhenReadyCommitted() {
    }

    public void onPlayerError(ExoPlaybackException e) {
        if (this.mListener == null) {
            return;
        }
        MoPubEvents.log(Event.createEventFromDetails(BaseEvent.Name.ERROR_DURING_PLAYBACK, BaseEvent.Category.NATIVE_VIDEO, BaseEvent.SamplingRate.NATIVE_VIDEO, this.mEventDetails));
        this.mListener.onError((Exception)e);
        this.mNativeVideoProgressRunnable.requestStop();
    }

    public void handleCtaClick(@NonNull Context context) {
        this.triggerImpressionTrackers();
        this.mVastVideoConfig.handleClickWithoutResult(context, 0);
    }

    public boolean hasFinalFrame() {
        return this.mFinalFrame != null;
    }

    @Nullable
    public Drawable getFinalFrame() {
        return this.mFinalFrame;
    }

    void triggerImpressionTrackers() {
        this.mNativeVideoProgressRunnable.checkImpressionTrackers(true);
    }

    private void clearExistingPlayer() {
        if (this.mExoPlayer == null) {
            return;
        }
        this.setExoSurface(null);
        this.mExoPlayer.stop();
        this.mExoPlayer.release();
        this.mExoPlayer = null;
        this.mNativeVideoProgressRunnable.stop();
        this.mNativeVideoProgressRunnable.setExoPlayer(null);
    }

    private void preparePlayer() {
        if (this.mExoPlayer == null) {
            this.mExoPlayer = this.mExoPlayerFactory.newInstance(2, 1000, 5000);
            this.mNativeVideoProgressRunnable.setExoPlayer(this.mExoPlayer);
            this.mExoPlayer.addListener((ExoPlayer.Listener)this);
            DefaultAllocator allocator = new DefaultAllocator(65536);
            Mp4Extractor extractor = new Mp4Extractor();
            HttpDiskCompositeDataSource httpSource = new HttpDiskCompositeDataSource(this.mContext, "exo_demo", this.mEventDetails);
            String videoUrl = this.mVastVideoConfig.getNetworkMediaFileUrl();
            ExtractorSampleSource sampleSource = new ExtractorSampleSource(Uri.parse((String)videoUrl), (DataSource)httpSource, (Allocator)allocator, 0x200000, new Extractor[]{extractor});
            this.mVideoTrackRenderer = new MediaCodecVideoTrackRenderer(this.mContext, (SampleSource)sampleSource, MediaCodecSelector.DEFAULT, 2, 0L, this.mHandler, null, 10);
            this.mAudioTrackRenderer = new MediaCodecAudioTrackRenderer((SampleSource)sampleSource, MediaCodecSelector.DEFAULT);
            this.mExoPlayer.prepare(new TrackRenderer[]{this.mAudioTrackRenderer, this.mVideoTrackRenderer});
            this.mNativeVideoProgressRunnable.startRepeating(50L);
        }
        this.setExoAudio();
        this.setExoPlayWhenReady();
    }

    private void setExoPlayWhenReady() {
        if (this.mExoPlayer == null) {
            return;
        }
        this.mExoPlayer.setPlayWhenReady(this.mPlayWhenReady);
    }

    private void setExoAudio() {
        this.setExoAudio(this.mAudioEnabled ? 1.0f : 0.0f);
    }

    private void setExoAudio(float volume) {
        Preconditions.checkArgument(volume >= 0.0f && volume <= 1.0f);
        if (this.mExoPlayer == null) {
            return;
        }
        this.mExoPlayer.sendMessage((ExoPlayer.ExoPlayerComponent)this.mAudioTrackRenderer, 1, (Object)Float.valueOf(volume));
    }

    private void setExoSurface(@Nullable Surface surface) {
        if (this.mExoPlayer == null) {
            return;
        }
        this.mExoPlayer.sendMessage((ExoPlayer.ExoPlayerComponent)this.mVideoTrackRenderer, 1, (Object)surface);
    }

    static class NativeVideoProgressRunnable
    extends RepeatingHandlerRunnable {
        @NonNull
        private final Context mContext;
        @NonNull
        private final VisibilityTracker.VisibilityChecker mVisibilityChecker;
        @NonNull
        private final List<VisibilityTrackingEvent> mVisibilityTrackingEvents;
        @NonNull
        private final VastVideoConfig mVastVideoConfig;
        @Nullable
        private ExoPlayer mExoPlayer;
        @Nullable
        private TextureView mTextureView;
        @Nullable
        private ProgressListener mProgressListener;
        private long mCurrentPosition;
        private long mDuration;
        private boolean mStopRequested;

        NativeVideoProgressRunnable(@NonNull Context context, @NonNull Handler handler, @NonNull List<VisibilityTrackingEvent> visibilityTrackingEvents, @NonNull VastVideoConfig vastVideoConfig) {
            this(context, handler, visibilityTrackingEvents, new VisibilityTracker.VisibilityChecker(), vastVideoConfig);
        }

        @VisibleForTesting
        NativeVideoProgressRunnable(@NonNull Context context, @NonNull Handler handler, @NonNull List<VisibilityTrackingEvent> visibilityTrackingEvents, @NonNull VisibilityTracker.VisibilityChecker visibilityChecker, @NonNull VastVideoConfig vastVideoConfig) {
            super(handler);
            Preconditions.checkNotNull(context);
            Preconditions.checkNotNull(handler);
            Preconditions.checkNotNull(visibilityTrackingEvents);
            Preconditions.checkNotNull(vastVideoConfig);
            this.mContext = context.getApplicationContext();
            this.mVisibilityTrackingEvents = visibilityTrackingEvents;
            this.mVisibilityChecker = visibilityChecker;
            this.mVastVideoConfig = vastVideoConfig;
            this.mDuration = -1L;
            this.mStopRequested = false;
        }

        void setExoPlayer(@Nullable ExoPlayer exoPlayer) {
            this.mExoPlayer = exoPlayer;
        }

        void setTextureView(@Nullable TextureView textureView) {
            this.mTextureView = textureView;
        }

        void setProgressListener(@Nullable ProgressListener progressListener) {
            this.mProgressListener = progressListener;
        }

        void seekTo(long currentPosition) {
            this.mCurrentPosition = currentPosition;
        }

        long getCurrentPosition() {
            return this.mCurrentPosition;
        }

        long getDuration() {
            return this.mDuration;
        }

        void requestStop() {
            this.mStopRequested = true;
        }

        void checkImpressionTrackers(boolean forceTrigger) {
            int trackedCount = 0;
            for (VisibilityTrackingEvent event : this.mVisibilityTrackingEvents) {
                if (event.isTracked) {
                    ++trackedCount;
                    continue;
                }
                if (!forceTrigger && !this.mVisibilityChecker.isVisible((View)this.mTextureView, (View)this.mTextureView, event.minimumPercentageVisible)) continue;
                event.totalQualifiedPlayCounter = (int)((long)event.totalQualifiedPlayCounter + this.mUpdateIntervalMillis);
                if (!forceTrigger && event.totalQualifiedPlayCounter < event.totalRequiredPlayTimeMs) continue;
                event.strategy.execute();
                event.isTracked = true;
                ++trackedCount;
            }
            if (trackedCount == this.mVisibilityTrackingEvents.size() && this.mStopRequested) {
                this.stop();
            }
        }

        @Override
        public void doWork() {
            List<VastTracker> trackers;
            if (this.mExoPlayer == null || !this.mExoPlayer.getPlayWhenReady()) {
                return;
            }
            this.mCurrentPosition = this.mExoPlayer.getCurrentPosition();
            this.mDuration = this.mExoPlayer.getDuration();
            this.checkImpressionTrackers(false);
            if (this.mProgressListener != null) {
                float tenthsOfPercentPlayed = (float)this.mCurrentPosition / (float)this.mDuration * 1000.0f;
                this.mProgressListener.updateProgress((int)tenthsOfPercentPlayed);
            }
            if (!(trackers = this.mVastVideoConfig.getUntriggeredTrackersBefore((int)this.mCurrentPosition, (int)this.mDuration)).isEmpty()) {
                ArrayList<String> trackingUrls = new ArrayList<String>();
                for (VastTracker tracker : trackers) {
                    if (tracker.isTracked()) continue;
                    trackingUrls.add(tracker.getTrackingUrl());
                    tracker.setTracked();
                }
                TrackingRequest.makeTrackingHttpRequest(trackingUrls, this.mContext);
            }
        }

        @Deprecated
        @VisibleForTesting
        void setUpdateIntervalMillis(long updateIntervalMillis) {
            this.mUpdateIntervalMillis = updateIntervalMillis;
        }

        public static interface ProgressListener {
            public void updateProgress(int var1);
        }
    }

    static class VisibilityTrackingEvent {
        OnTrackedStrategy strategy;
        int minimumPercentageVisible;
        int totalRequiredPlayTimeMs;
        int totalQualifiedPlayCounter;
        boolean isTracked;

        VisibilityTrackingEvent() {
        }

        static interface OnTrackedStrategy {
            public void execute();
        }
    }

    @VisibleForTesting
    static class ExoPlayerFactory {
        ExoPlayerFactory() {
        }

        public ExoPlayer newInstance(int rendererCount, int minBufferMs, int minRebufferMs) {
            return ExoPlayer.Factory.newInstance((int)rendererCount, (int)minBufferMs, (int)minRebufferMs);
        }
    }

    public static interface Listener {
        public void onStateChanged(boolean var1, int var2);

        public void onError(Exception var1);
    }
}

