/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Drawables;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.VastVideoProgressBarWidget;
import com.mopub.mobileads.resource.CloseButtonDrawable;
import com.mopub.mobileads.resource.CtaButtonDrawable;
import com.mopub.mobileads.resource.DrawableConstants;

@TargetApi(value=16)
public class NativeFullScreenVideoView
extends RelativeLayout {
    @VisibleForTesting
    @NonNull
    Mode mMode;
    private int mOrientation;
    @NonNull
    private final ImageView mCachedVideoFrameView;
    @NonNull
    private final TextureView mVideoTexture;
    @NonNull
    private final ProgressBar mLoadingSpinner;
    @NonNull
    private final ImageView mBottomGradient;
    @NonNull
    private final ImageView mTopGradient;
    @NonNull
    private final VastVideoProgressBarWidget mVideoProgress;
    @NonNull
    private final View mOverlay;
    @NonNull
    private final ImageView mPlayButton;
    @NonNull
    private final ImageView mPrivacyInformationIcon;
    @NonNull
    private final ImageView mCtaButton;
    @NonNull
    private final ImageView mCloseControl;
    @VisibleForTesting
    final int mCtaWidthPx;
    @VisibleForTesting
    final int mCtaHeightPx;
    @VisibleForTesting
    final int mCtaMarginPx;
    @VisibleForTesting
    final int mCloseControlSizePx;
    @VisibleForTesting
    final int mClosePaddingPx;
    @VisibleForTesting
    final int mPrivacyInformationIconSizePx;
    @VisibleForTesting
    final int mPlayControlSizePx;
    @VisibleForTesting
    final int mGradientStripHeightPx;

    public NativeFullScreenVideoView(@NonNull Context context, int orientation, @Nullable String ctaText) {
        this(context, orientation, ctaText, new ImageView(context), new TextureView(context), new ProgressBar(context), new ImageView(context), new ImageView(context), new VastVideoProgressBarWidget(context), new View(context), new ImageView(context), new ImageView(context), new ImageView(context), new ImageView(context));
    }

    @VisibleForTesting
    NativeFullScreenVideoView(@NonNull Context context, int orientation, @Nullable String ctaText, @NonNull ImageView cachedImageView, @NonNull TextureView videoTexture, @NonNull ProgressBar loadingSpinner, @NonNull ImageView bottomGradient, @NonNull ImageView topGradient, @NonNull VastVideoProgressBarWidget videoProgress, @NonNull View overlay, @NonNull ImageView playButton, @NonNull ImageView privacyInformationIcon, @NonNull ImageView ctaButton, @NonNull ImageView closeControl) {
        super(context);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(cachedImageView);
        Preconditions.checkNotNull(videoTexture);
        Preconditions.checkNotNull(loadingSpinner);
        Preconditions.checkNotNull(bottomGradient);
        Preconditions.checkNotNull(topGradient);
        Preconditions.checkNotNull((Object)videoProgress);
        Preconditions.checkNotNull(overlay);
        Preconditions.checkNotNull(playButton);
        Preconditions.checkNotNull(privacyInformationIcon);
        Preconditions.checkNotNull(ctaButton);
        Preconditions.checkNotNull(closeControl);
        this.mOrientation = orientation;
        this.mMode = Mode.LOADING;
        this.mCtaWidthPx = Dips.asIntPixels(200.0f, context);
        this.mCtaHeightPx = Dips.asIntPixels(42.0f, context);
        this.mCtaMarginPx = Dips.asIntPixels(10.0f, context);
        this.mCloseControlSizePx = Dips.asIntPixels(50.0f, context);
        this.mClosePaddingPx = Dips.asIntPixels(8.0f, context);
        this.mPrivacyInformationIconSizePx = Dips.asIntPixels(44.0f, context);
        this.mPlayControlSizePx = Dips.asIntPixels(50.0f, context);
        this.mGradientStripHeightPx = Dips.asIntPixels(45.0f, context);
        RelativeLayout.LayoutParams videoTextureLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        videoTextureLayoutParams.addRule(13);
        this.mVideoTexture = videoTexture;
        this.mVideoTexture.setId((int)Utils.generateUniqueId());
        this.mVideoTexture.setLayoutParams((ViewGroup.LayoutParams)videoTextureLayoutParams);
        this.addView((View)this.mVideoTexture);
        this.mCachedVideoFrameView = cachedImageView;
        this.mCachedVideoFrameView.setId((int)Utils.generateUniqueId());
        this.mCachedVideoFrameView.setLayoutParams((ViewGroup.LayoutParams)videoTextureLayoutParams);
        this.mCachedVideoFrameView.setBackgroundColor(0);
        this.addView((View)this.mCachedVideoFrameView);
        RelativeLayout.LayoutParams spinnerParams = new RelativeLayout.LayoutParams(this.mPlayControlSizePx, this.mPlayControlSizePx);
        spinnerParams.addRule(13);
        this.mLoadingSpinner = loadingSpinner;
        this.mLoadingSpinner.setId((int)Utils.generateUniqueId());
        this.mLoadingSpinner.setBackground((Drawable)new LoadingBackground(context));
        this.mLoadingSpinner.setLayoutParams((ViewGroup.LayoutParams)spinnerParams);
        this.mLoadingSpinner.setIndeterminate(true);
        this.addView((View)this.mLoadingSpinner);
        RelativeLayout.LayoutParams bottomGradientParams = new RelativeLayout.LayoutParams(-1, this.mGradientStripHeightPx);
        bottomGradientParams.addRule(8, this.mVideoTexture.getId());
        this.mBottomGradient = bottomGradient;
        this.mBottomGradient.setId((int)Utils.generateUniqueId());
        this.mBottomGradient.setLayoutParams((ViewGroup.LayoutParams)bottomGradientParams);
        GradientDrawable bottomGradientDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{DrawableConstants.GradientStrip.START_COLOR, DrawableConstants.GradientStrip.END_COLOR});
        this.mBottomGradient.setImageDrawable((Drawable)bottomGradientDrawable);
        this.addView((View)this.mBottomGradient);
        RelativeLayout.LayoutParams topGradientParams = new RelativeLayout.LayoutParams(-1, this.mGradientStripHeightPx);
        topGradientParams.addRule(10);
        this.mTopGradient = topGradient;
        this.mTopGradient.setId((int)Utils.generateUniqueId());
        this.mTopGradient.setLayoutParams((ViewGroup.LayoutParams)topGradientParams);
        GradientDrawable topGradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{DrawableConstants.GradientStrip.START_COLOR, DrawableConstants.GradientStrip.END_COLOR});
        this.mTopGradient.setImageDrawable((Drawable)topGradientDrawable);
        this.addView((View)this.mTopGradient);
        this.mVideoProgress = videoProgress;
        this.mVideoProgress.setId((int)Utils.generateUniqueId());
        this.mVideoProgress.setAnchorId(this.mVideoTexture.getId());
        this.mVideoProgress.calibrateAndMakeVisible(1000, 0);
        this.addView((View)this.mVideoProgress);
        RelativeLayout.LayoutParams overlayParams = new RelativeLayout.LayoutParams(-1, -1);
        overlayParams.addRule(13);
        this.mOverlay = overlay;
        this.mOverlay.setId((int)Utils.generateUniqueId());
        this.mOverlay.setLayoutParams((ViewGroup.LayoutParams)overlayParams);
        this.mOverlay.setBackgroundColor(-2013265920);
        this.addView(this.mOverlay);
        RelativeLayout.LayoutParams playButtonParams = new RelativeLayout.LayoutParams(this.mPlayControlSizePx, this.mPlayControlSizePx);
        playButtonParams.addRule(13);
        this.mPlayButton = playButton;
        this.mPlayButton.setId((int)Utils.generateUniqueId());
        this.mPlayButton.setLayoutParams((ViewGroup.LayoutParams)playButtonParams);
        this.mPlayButton.setImageDrawable(Drawables.NATIVE_PLAY.createDrawable(context));
        this.addView((View)this.mPlayButton);
        this.mPrivacyInformationIcon = privacyInformationIcon;
        this.mPrivacyInformationIcon.setId((int)Utils.generateUniqueId());
        this.mPrivacyInformationIcon.setImageDrawable(Drawables.NATIVE_PRIVACY_INFORMATION_ICON.createDrawable(context));
        this.mPrivacyInformationIcon.setPadding(this.mClosePaddingPx, this.mClosePaddingPx, this.mClosePaddingPx * 2, this.mClosePaddingPx * 2);
        this.addView((View)this.mPrivacyInformationIcon);
        CtaButtonDrawable ctaDrawable = new CtaButtonDrawable(context);
        if (!TextUtils.isEmpty((CharSequence)ctaText)) {
            ctaDrawable.setCtaText(ctaText);
        }
        this.mCtaButton = ctaButton;
        this.mCtaButton.setId((int)Utils.generateUniqueId());
        this.mCtaButton.setImageDrawable((Drawable)ctaDrawable);
        this.addView((View)this.mCtaButton);
        this.mCloseControl = closeControl;
        this.mCloseControl.setId((int)Utils.generateUniqueId());
        this.mCloseControl.setImageDrawable((Drawable)new CloseButtonDrawable());
        this.mCloseControl.setPadding(this.mClosePaddingPx * 3, this.mClosePaddingPx, this.mClosePaddingPx, this.mClosePaddingPx * 3);
        this.addView((View)this.mCloseControl);
        this.updateViewState();
    }

    public void resetProgress() {
        this.mVideoProgress.reset();
    }

    public void setMode(@NonNull Mode mode) {
        Preconditions.checkNotNull((Object)mode);
        if (this.mMode == mode) {
            return;
        }
        this.mMode = mode;
        this.updateViewState();
    }

    @NonNull
    public TextureView getTextureView() {
        return this.mVideoTexture;
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
        this.updateViewState();
    }

    public void setSurfaceTextureListener(@Nullable TextureView.SurfaceTextureListener surfaceTextureListener) {
        this.mVideoTexture.setSurfaceTextureListener(surfaceTextureListener);
        SurfaceTexture surfaceTexture = this.mVideoTexture.getSurfaceTexture();
        if (surfaceTexture != null && surfaceTextureListener != null) {
            surfaceTextureListener.onSurfaceTextureAvailable(surfaceTexture, this.mVideoTexture.getWidth(), this.mVideoTexture.getHeight());
        }
    }

    public void setCloseControlListener(@Nullable View.OnClickListener closeControlListener) {
        this.mCloseControl.setOnClickListener(closeControlListener);
    }

    public void setPrivacyInformationClickListener(@Nullable View.OnClickListener privacyInformationListener) {
        this.mPrivacyInformationIcon.setOnClickListener(privacyInformationListener);
    }

    public void setCtaClickListener(@Nullable View.OnClickListener ctaListener) {
        this.mCtaButton.setOnClickListener(ctaListener);
    }

    public void setPlayControlClickListener(@Nullable View.OnClickListener playControlListener) {
        this.mPlayButton.setOnClickListener(playControlListener);
        this.mOverlay.setOnClickListener(playControlListener);
    }

    public void updateProgress(int progressPercentage) {
        this.mVideoProgress.updateProgress(progressPercentage);
    }

    public void setCachedVideoFrame(@Nullable Bitmap cachedVideoFrame) {
        this.mCachedVideoFrameView.setImageBitmap(cachedVideoFrame);
    }

    private void updateViewState() {
        switch (this.mMode) {
            case LOADING: {
                this.setCachedImageVisibility(0);
                this.setLoadingSpinnerVisibility(0);
                this.setVideoProgressVisibility(4);
                this.setPlayButtonVisibility(4);
                break;
            }
            case PLAYING: {
                this.setCachedImageVisibility(4);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoProgressVisibility(0);
                this.setPlayButtonVisibility(4);
                break;
            }
            case PAUSED: {
                this.setCachedImageVisibility(4);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoProgressVisibility(0);
                this.setPlayButtonVisibility(0);
                break;
            }
            case FINISHED: {
                this.setCachedImageVisibility(0);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoProgressVisibility(4);
                this.setPlayButtonVisibility(0);
                break;
            }
        }
        this.updateVideoTextureLayout();
        this.updateControlLayouts();
    }

    private void setCachedImageVisibility(int visibility) {
        this.mCachedVideoFrameView.setVisibility(visibility);
    }

    private void setLoadingSpinnerVisibility(int visibility) {
        this.mLoadingSpinner.setVisibility(visibility);
    }

    private void setVideoProgressVisibility(int visibility) {
        this.mVideoProgress.setVisibility(visibility);
    }

    private void setPlayButtonVisibility(int visibility) {
        this.mPlayButton.setVisibility(visibility);
        this.mOverlay.setVisibility(visibility);
    }

    private void updateVideoTextureLayout() {
        int newHeight;
        Configuration configuration = this.getContext().getResources().getConfiguration();
        ViewGroup.LayoutParams layoutParams = this.mVideoTexture.getLayoutParams();
        int newWidth = Dips.dipsToIntPixels(configuration.screenWidthDp, this.getContext());
        if (newWidth != layoutParams.width) {
            layoutParams.width = newWidth;
        }
        if ((newHeight = Dips.dipsToIntPixels((float)configuration.screenWidthDp * 9.0f / 16.0f, this.getContext())) != layoutParams.height) {
            layoutParams.height = newHeight;
        }
    }

    private void updateControlLayouts() {
        RelativeLayout.LayoutParams ctaParams = new RelativeLayout.LayoutParams(this.mCtaWidthPx, this.mCtaHeightPx);
        ctaParams.setMargins(this.mCtaMarginPx, this.mCtaMarginPx, this.mCtaMarginPx, this.mCtaMarginPx);
        RelativeLayout.LayoutParams privacyInformationIconParams = new RelativeLayout.LayoutParams(this.mPrivacyInformationIconSizePx, this.mPrivacyInformationIconSizePx);
        RelativeLayout.LayoutParams closeParams = new RelativeLayout.LayoutParams(this.mCloseControlSizePx, this.mCloseControlSizePx);
        switch (this.mOrientation) {
            case 1: {
                ctaParams.addRule(3, this.mVideoTexture.getId());
                ctaParams.addRule(14);
                privacyInformationIconParams.addRule(10);
                privacyInformationIconParams.addRule(9);
                closeParams.addRule(10);
                closeParams.addRule(11);
                break;
            }
            case 2: {
                ctaParams.addRule(2, this.mVideoProgress.getId());
                ctaParams.addRule(11);
                privacyInformationIconParams.addRule(6, this.mVideoTexture.getId());
                privacyInformationIconParams.addRule(5, this.mVideoTexture.getId());
                closeParams.addRule(6, this.mVideoTexture.getId());
                closeParams.addRule(7, this.mVideoTexture.getId());
                break;
            }
        }
        this.mCtaButton.setLayoutParams((ViewGroup.LayoutParams)ctaParams);
        this.mPrivacyInformationIcon.setLayoutParams((ViewGroup.LayoutParams)privacyInformationIconParams);
        this.mCloseControl.setLayoutParams((ViewGroup.LayoutParams)closeParams);
    }

    @Deprecated
    @VisibleForTesting
    ImageView getCtaButton() {
        return this.mCtaButton;
    }

    @VisibleForTesting
    static class LoadingBackground
    extends Drawable {
        @NonNull
        private final RectF mButtonRect;
        @NonNull
        private final Paint mPaint;
        @VisibleForTesting
        final int mCornerRadiusPx;

        LoadingBackground(@NonNull Context context) {
            this(context, new RectF(), new Paint());
        }

        LoadingBackground(@NonNull Context context, @NonNull RectF rectF, @NonNull Paint paint) {
            Preconditions.checkNotNull(context);
            Preconditions.checkNotNull(rectF);
            Preconditions.checkNotNull(paint);
            this.mButtonRect = rectF;
            this.mPaint = paint;
            this.mPaint.setColor(-16777216);
            this.mPaint.setAlpha(128);
            this.mPaint.setAntiAlias(true);
            this.mCornerRadiusPx = Dips.asIntPixels(5.0f, context);
        }

        public void draw(Canvas canvas) {
            this.mButtonRect.set(this.getBounds());
            canvas.drawRoundRect(this.mButtonRect, (float)this.mCornerRadiusPx, (float)this.mCornerRadiusPx, this.mPaint);
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return 0;
        }
    }

    public static enum Mode {
        LOADING,
        PLAYING,
        PAUSED,
        FINISHED;

    }
}

