/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.mopub.common.Preconditions;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlHandler;
import com.mopub.common.VisibleForTesting;
import com.mopub.nativeads.ClickInterface;
import com.mopub.nativeads.SpinningProgressView;

public class NativeClickHandler {
    @NonNull
    private final Context mContext;
    @Nullable
    private final String mDspCreativeId;
    private boolean mClickInProgress;

    public NativeClickHandler(@NonNull Context context) {
        this(context, null);
    }

    public NativeClickHandler(@NonNull Context context, @Nullable String dspCreativeId) {
        Preconditions.checkNotNull(context);
        this.mContext = context.getApplicationContext();
        this.mDspCreativeId = dspCreativeId;
    }

    public void setOnClickListener(@NonNull View view, final @NonNull ClickInterface clickInterface) {
        if (!Preconditions.NoThrow.checkNotNull(view, "Cannot set click listener on a null view")) {
            return;
        }
        if (!Preconditions.NoThrow.checkNotNull(clickInterface, "Cannot set click listener with a null ClickInterface")) {
            return;
        }
        this.setOnClickListener(view, new View.OnClickListener(){

            public void onClick(View v) {
                clickInterface.handleClick(v);
            }
        });
    }

    private void setOnClickListener(@NonNull View view, @Nullable View.OnClickListener onClickListener) {
        view.setOnClickListener(onClickListener);
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                this.setOnClickListener(viewGroup.getChildAt(i), onClickListener);
            }
        }
    }

    public void clearOnClickListener(@NonNull View view) {
        if (!Preconditions.NoThrow.checkNotNull(view, "Cannot clear click listener from a null view")) {
            return;
        }
        this.setOnClickListener(view, (View.OnClickListener)null);
    }

    public void openClickDestinationUrl(@NonNull String clickDestinationUrl, @Nullable View view) {
        this.openClickDestinationUrl(clickDestinationUrl, view, new SpinningProgressView(this.mContext));
    }

    @VisibleForTesting
    void openClickDestinationUrl(@NonNull String clickDestinationUrl, final @Nullable View view, final @NonNull SpinningProgressView spinningProgressView) {
        if (!Preconditions.NoThrow.checkNotNull(clickDestinationUrl, "Cannot open a null click destination url")) {
            return;
        }
        Preconditions.checkNotNull((Object)spinningProgressView);
        if (this.mClickInProgress) {
            return;
        }
        this.mClickInProgress = true;
        if (view != null) {
            spinningProgressView.addToRoot(view);
        }
        UrlHandler.Builder builder = new UrlHandler.Builder();
        if (!TextUtils.isEmpty((CharSequence)this.mDspCreativeId)) {
            builder.withDspCreativeId(this.mDspCreativeId);
        }
        builder.withSupportedUrlActions(UrlAction.IGNORE_ABOUT_SCHEME, UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_APP_MARKET, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK).withResultActions(new UrlHandler.ResultActions(){

            @Override
            public void urlHandlingSucceeded(@NonNull String url, @NonNull UrlAction urlAction) {
                this.removeSpinningProgressView();
                NativeClickHandler.this.mClickInProgress = false;
            }

            @Override
            public void urlHandlingFailed(@NonNull String url, @NonNull UrlAction lastFailedUrlAction) {
                this.removeSpinningProgressView();
                NativeClickHandler.this.mClickInProgress = false;
            }

            private void removeSpinningProgressView() {
                if (view != null) {
                    spinningProgressView.removeFromRoot();
                }
            }
        }).build().handleUrl(this.mContext, clickDestinationUrl);
    }
}

