/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.MediaLayout;
import com.mopub.nativeads.MediaViewBinder;
import com.mopub.nativeads.MediaViewHolder;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.NativeImageHelper;
import com.mopub.nativeads.NativeRendererHelper;
import com.mopub.nativeads.VideoNativeAd;
import java.util.WeakHashMap;

public class MoPubVideoNativeAdRenderer
implements MoPubAdRenderer<VideoNativeAd> {
    @NonNull
    private final MediaViewBinder mMediaViewBinder;
    @VisibleForTesting
    @NonNull
    final WeakHashMap<View, MediaViewHolder> mMediaViewHolderMap;

    public MoPubVideoNativeAdRenderer(@NonNull MediaViewBinder mediaViewBinder) {
        this.mMediaViewBinder = mediaViewBinder;
        this.mMediaViewHolderMap = new WeakHashMap();
    }

    @Override
    @NonNull
    public View createAdView(@NonNull Activity activity, @Nullable ViewGroup parent) {
        return LayoutInflater.from((Context)activity).inflate(this.mMediaViewBinder.layoutId, parent, false);
    }

    @Override
    public void renderAdView(@NonNull View view, @NonNull VideoNativeAd videoNativeAd) {
        MediaViewHolder mediaViewHolder = this.mMediaViewHolderMap.get(view);
        if (mediaViewHolder == null) {
            mediaViewHolder = MediaViewHolder.fromViewBinder(view, this.mMediaViewBinder);
            this.mMediaViewHolderMap.put(view, mediaViewHolder);
        }
        this.update(mediaViewHolder, videoNativeAd);
        NativeRendererHelper.updateExtras(mediaViewHolder.mainView, this.mMediaViewBinder.extras, videoNativeAd.getExtras());
        this.setViewVisibility(mediaViewHolder, 0);
        MediaLayout mediaLayout = (MediaLayout)view.findViewById(this.mMediaViewBinder.mediaLayoutId);
        videoNativeAd.render(mediaLayout);
    }

    @Override
    public boolean supports(@NonNull BaseNativeAd nativeAd) {
        Preconditions.checkNotNull(nativeAd);
        return nativeAd instanceof VideoNativeAd;
    }

    private void update(@NonNull MediaViewHolder mediaViewHolder, @NonNull VideoNativeAd videoNativeAd) {
        NativeRendererHelper.addTextView(mediaViewHolder.titleView, videoNativeAd.getTitle());
        NativeRendererHelper.addTextView(mediaViewHolder.textView, videoNativeAd.getText());
        NativeRendererHelper.addCtaButton(mediaViewHolder.callToActionView, mediaViewHolder.mainView, videoNativeAd.getCallToAction());
        if (mediaViewHolder.mediaLayout != null) {
            NativeImageHelper.loadImageView(videoNativeAd.getMainImageUrl(), mediaViewHolder.mediaLayout.getMainImageView());
        }
        NativeImageHelper.loadImageView(videoNativeAd.getIconImageUrl(), mediaViewHolder.iconImageView);
        NativeRendererHelper.addPrivacyInformationIcon(mediaViewHolder.privacyInformationIconImageView, videoNativeAd.getPrivacyInformationIconImageUrl(), videoNativeAd.getPrivacyInformationIconClickThroughUrl());
    }

    private void setViewVisibility(@NonNull MediaViewHolder mediaViewHolder, int visibility) {
        if (mediaViewHolder.mainView != null) {
            mediaViewHolder.mainView.setVisibility(visibility);
        }
    }
}

