/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.TextureView;
import android.view.View;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.event.BaseEvent;
import com.mopub.common.event.Event;
import com.mopub.common.event.EventDetails;
import com.mopub.common.event.MoPubEvents;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.MraidVideoPlayerActivity;
import com.mopub.mobileads.VastManager;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.mobileads.VideoViewabilityTracker;
import com.mopub.mobileads.factories.VastManagerFactory;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.MediaLayout;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.NativeImageHelper;
import com.mopub.nativeads.NativeVideoController;
import com.mopub.nativeads.VideoNativeAd;
import com.mopub.nativeads.VisibilityTracker;
import com.mopub.network.TrackingRequest;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

@TargetApi(value=16)
public class MoPubCustomEventVideoNative
extends CustomEventNative {
    @Override
    protected void loadNativeAd(@NonNull Activity activity, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener, @NonNull Map<String, Object> localExtras, @NonNull Map<String, String> serverExtras) {
        Object json = localExtras.get("com_mopub_native_json");
        if (!(json instanceof JSONObject)) {
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.INVALID_RESPONSE);
            return;
        }
        Object eventDetailsObject = localExtras.get("Event-Details");
        EventDetails eventDetails = eventDetailsObject instanceof EventDetails ? (EventDetails)eventDetailsObject : null;
        VideoResponseHeaders videoResponseHeaders = new VideoResponseHeaders(serverExtras);
        if (!videoResponseHeaders.hasValidHeaders()) {
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.INVALID_RESPONSE);
            return;
        }
        Object clickTrackingUrlFromHeaderObject = localExtras.get("Click-Tracking-Url");
        if (!(clickTrackingUrlFromHeaderObject instanceof String) || TextUtils.isEmpty((CharSequence)((String)clickTrackingUrlFromHeaderObject))) {
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.UNSPECIFIED);
            return;
        }
        String clickTrackingUrlFromHeader = (String)clickTrackingUrlFromHeaderObject;
        MoPubVideoNativeAd videoNativeAd = new MoPubVideoNativeAd(activity, (JSONObject)json, customEventNativeListener, videoResponseHeaders, eventDetails, clickTrackingUrlFromHeader);
        try {
            videoNativeAd.loadAd();
        }
        catch (IllegalArgumentException e) {
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.UNSPECIFIED);
        }
    }

    @VisibleForTesting
    @TargetApi(value=16)
    static class VideoResponseHeaders {
        private boolean mHeadersAreValid;
        private int mPlayVisiblePercent;
        private int mPauseVisiblePercent;
        private int mImpressionMinVisiblePercent;
        private int mImpressionVisibleMs;
        private int mMaxBufferMs;

        VideoResponseHeaders(@NonNull Map<String, String> serverExtras) {
            try {
                this.mPlayVisiblePercent = Integer.parseInt(serverExtras.get("Play-Visible-Percent"));
                this.mPauseVisiblePercent = Integer.parseInt(serverExtras.get("Pause-Visible-Percent"));
                this.mImpressionMinVisiblePercent = Integer.parseInt(serverExtras.get("Impression-Min-Visible-Percent"));
                this.mImpressionVisibleMs = Integer.parseInt(serverExtras.get("Impression-Visible-Ms"));
                this.mMaxBufferMs = Integer.parseInt(serverExtras.get("Max-Buffer-Ms"));
                this.mHeadersAreValid = true;
            }
            catch (NumberFormatException e) {
                this.mHeadersAreValid = false;
            }
        }

        boolean hasValidHeaders() {
            return this.mHeadersAreValid;
        }

        int getPlayVisiblePercent() {
            return this.mPlayVisiblePercent;
        }

        int getPauseVisiblePercent() {
            return this.mPauseVisiblePercent;
        }

        int getImpressionMinVisiblePercent() {
            return this.mImpressionMinVisiblePercent;
        }

        int getImpressionVisibleMs() {
            return this.mImpressionVisibleMs;
        }

        int getMaxBufferMs() {
            return this.mMaxBufferMs;
        }
    }

    @VisibleForTesting
    @TargetApi(value=16)
    static class NativeVideoControllerFactory {
        NativeVideoControllerFactory() {
        }

        public NativeVideoController createForId(long id, @NonNull Context context, @NonNull List<NativeVideoController.VisibilityTrackingEvent> visibilityTrackingEvents, @NonNull VastVideoConfig vastVideoConfig, @Nullable EventDetails eventDetails) {
            return NativeVideoController.createForId(id, context, visibilityTrackingEvents, vastVideoConfig, eventDetails);
        }
    }

    @VisibleForTesting
    @TargetApi(value=16)
    static class PayloadVisibilityStrategy
    implements NativeVideoController.VisibilityTrackingEvent.OnTrackedStrategy {
        @NonNull
        private final Context mContext;
        @NonNull
        private final String mUrl;

        PayloadVisibilityStrategy(@NonNull Context context, @NonNull String url) {
            this.mContext = context.getApplicationContext();
            this.mUrl = url;
        }

        @Override
        public void execute() {
            TrackingRequest.makeTrackingHttpRequest(this.mUrl, this.mContext);
        }
    }

    @VisibleForTesting
    @TargetApi(value=16)
    static class HeaderVisibilityStrategy
    implements NativeVideoController.VisibilityTrackingEvent.OnTrackedStrategy {
        @NonNull
        private final WeakReference<MoPubVideoNativeAd> mMoPubVideoNativeAd;

        HeaderVisibilityStrategy(@NonNull MoPubVideoNativeAd moPubVideoNativeAd) {
            this.mMoPubVideoNativeAd = new WeakReference<MoPubVideoNativeAd>(moPubVideoNativeAd);
        }

        @Override
        public void execute() {
            MoPubVideoNativeAd moPubVideoNativeAd = (MoPubVideoNativeAd)this.mMoPubVideoNativeAd.get();
            if (moPubVideoNativeAd != null) {
                moPubVideoNativeAd.notifyAdImpressed();
            }
        }
    }

    @TargetApi(value=16)
    public static class MoPubVideoNativeAd
    extends VideoNativeAd
    implements VastManager.VastManagerListener,
    NativeVideoController.NativeVideoProgressRunnable.ProgressListener,
    AudioManager.OnAudioFocusChangeListener {
        static final String PRIVACY_INFORMATION_CLICKTHROUGH_URL = "https://www.mopub.com/optout/";
        @NonNull
        private final Context mContext;
        @NonNull
        private final JSONObject mJsonObject;
        @NonNull
        private VideoState mVideoState;
        @NonNull
        private final VisibilityTracker mVideoVisibleTracking;
        @NonNull
        private final String mMoPubClickTrackingUrl;
        @NonNull
        private final CustomEventNative.CustomEventNativeListener mCustomEventNativeListener;
        @NonNull
        private final VideoResponseHeaders mVideoResponseHeaders;
        @NonNull
        private final NativeVideoControllerFactory mNativeVideoControllerFactory;
        @Nullable
        private NativeVideoController mNativeVideoController;
        @NonNull
        private final VastManager mVastManager;
        @Nullable
        VastVideoConfig mVastVideoConfig;
        @Nullable
        private MediaLayout mMediaLayout;
        @Nullable
        private View mRootView;
        @Nullable
        private final EventDetails mEventDetails;
        private final long mId;
        private boolean mNeedsSeek;
        private boolean mNeedsPrepare;
        private boolean mPauseCanBeTracked = false;
        private boolean mResumeCanBeTracked = false;
        private int mLatestVideoControllerState;
        private boolean mError;
        private boolean mLatestVisibility;
        private boolean mMuted;
        private boolean mEnded;

        public MoPubVideoNativeAd(@NonNull Activity activity, @NonNull JSONObject jsonObject, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener, @NonNull VideoResponseHeaders videoResponseHeaders, @Nullable EventDetails eventDetails, @NonNull String clickTrackingUrl) {
            this(activity, jsonObject, customEventNativeListener, videoResponseHeaders, new VisibilityTracker(activity), new NativeVideoControllerFactory(), eventDetails, clickTrackingUrl, VastManagerFactory.create(activity.getApplicationContext(), false));
        }

        @VisibleForTesting
        MoPubVideoNativeAd(@NonNull Activity activity, @NonNull JSONObject jsonObject, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener, @NonNull VideoResponseHeaders videoResponseHeaders, @NonNull VisibilityTracker visibilityTracker, @NonNull NativeVideoControllerFactory nativeVideoControllerFactory, @Nullable EventDetails eventDetails, @NonNull String clickTrackingUrl, @NonNull VastManager vastManager) {
            Preconditions.checkNotNull(activity);
            Preconditions.checkNotNull(jsonObject);
            Preconditions.checkNotNull(customEventNativeListener);
            Preconditions.checkNotNull(videoResponseHeaders);
            Preconditions.checkNotNull(visibilityTracker);
            Preconditions.checkNotNull(nativeVideoControllerFactory);
            Preconditions.checkNotNull(clickTrackingUrl);
            Preconditions.checkNotNull(vastManager);
            this.mContext = activity.getApplicationContext();
            this.mJsonObject = jsonObject;
            this.mCustomEventNativeListener = customEventNativeListener;
            this.mVideoResponseHeaders = videoResponseHeaders;
            this.mNativeVideoControllerFactory = nativeVideoControllerFactory;
            this.mMoPubClickTrackingUrl = clickTrackingUrl;
            this.mEventDetails = eventDetails;
            this.mId = Utils.generateUniqueId();
            this.mNeedsSeek = true;
            this.mVideoState = VideoState.CREATED;
            this.mNeedsPrepare = true;
            this.mLatestVideoControllerState = 1;
            this.mMuted = true;
            this.mVideoVisibleTracking = visibilityTracker;
            this.mVideoVisibleTracking.setVisibilityTrackerListener(new VisibilityTracker.VisibilityTrackerListener(){

                @Override
                public void onVisibilityChanged(List<View> visibleViews, List<View> invisibleViews) {
                    if (!visibleViews.isEmpty() && !MoPubVideoNativeAd.this.mLatestVisibility) {
                        MoPubVideoNativeAd.this.mLatestVisibility = true;
                        MoPubVideoNativeAd.this.maybeChangeState();
                    } else if (!invisibleViews.isEmpty() && MoPubVideoNativeAd.this.mLatestVisibility) {
                        MoPubVideoNativeAd.this.mLatestVisibility = false;
                        MoPubVideoNativeAd.this.maybeChangeState();
                    }
                }
            });
            this.mVastManager = vastManager;
        }

        void loadAd() throws IllegalArgumentException {
            if (!this.containsRequiredKeys(this.mJsonObject)) {
                throw new IllegalArgumentException("JSONObject did not contain required keys.");
            }
            Iterator keys = this.mJsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Parameter parameter = Parameter.from(key);
                if (parameter != null) {
                    try {
                        this.addInstanceVariable(parameter, this.mJsonObject.opt(key));
                        continue;
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("JSONObject key (" + key + ") contained unexpected value.");
                    }
                }
                this.addExtra(key, this.mJsonObject.opt(key));
            }
            this.setPrivacyInformationIconClickThroughUrl(PRIVACY_INFORMATION_CLICKTHROUGH_URL);
            NativeImageHelper.preCacheImages(this.mContext, this.getAllImageUrls(), new NativeImageHelper.ImageListener(){

                @Override
                public void onImagesCached() {
                    MoPubVideoNativeAd.this.mVastManager.prepareVastVideoConfiguration(MoPubVideoNativeAd.this.getVastVideo(), MoPubVideoNativeAd.this, MoPubVideoNativeAd.this.mEventDetails == null ? null : MoPubVideoNativeAd.this.mEventDetails.getDspCreativeId(), MoPubVideoNativeAd.this.mContext);
                }

                @Override
                public void onImagesFailedToCache(NativeErrorCode errorCode) {
                    MoPubVideoNativeAd.this.mCustomEventNativeListener.onNativeAdFailed(errorCode);
                }
            });
        }

        @Override
        public void onVastVideoConfigurationPrepared(@Nullable VastVideoConfig vastVideoConfig) {
            if (vastVideoConfig == null) {
                this.mCustomEventNativeListener.onNativeAdFailed(NativeErrorCode.INVALID_RESPONSE);
                return;
            }
            ArrayList<NativeVideoController.VisibilityTrackingEvent> visibilityTrackingEvents = new ArrayList<NativeVideoController.VisibilityTrackingEvent>();
            NativeVideoController.VisibilityTrackingEvent visibilityTrackingEvent = new NativeVideoController.VisibilityTrackingEvent();
            visibilityTrackingEvent.strategy = new HeaderVisibilityStrategy(this);
            visibilityTrackingEvent.minimumPercentageVisible = this.mVideoResponseHeaders.getImpressionMinVisiblePercent();
            visibilityTrackingEvent.totalRequiredPlayTimeMs = this.mVideoResponseHeaders.getImpressionVisibleMs();
            visibilityTrackingEvents.add(visibilityTrackingEvent);
            this.mVastVideoConfig = vastVideoConfig;
            VideoViewabilityTracker vastVideoViewabilityTracker = this.mVastVideoConfig.getVideoViewabilityTracker();
            if (vastVideoViewabilityTracker != null) {
                NativeVideoController.VisibilityTrackingEvent vastVisibilityTrackingEvent = new NativeVideoController.VisibilityTrackingEvent();
                vastVisibilityTrackingEvent.strategy = new PayloadVisibilityStrategy(this.mContext, vastVideoViewabilityTracker.getTrackingUrl());
                vastVisibilityTrackingEvent.minimumPercentageVisible = vastVideoViewabilityTracker.getPercentViewable();
                vastVisibilityTrackingEvent.totalRequiredPlayTimeMs = vastVideoViewabilityTracker.getViewablePlaytimeMS();
                visibilityTrackingEvents.add(vastVisibilityTrackingEvent);
            }
            HashSet<String> clickTrackers = new HashSet<String>();
            clickTrackers.add(this.mMoPubClickTrackingUrl);
            clickTrackers.addAll(this.getClickTrackers());
            ArrayList<VastTracker> vastClickTrackers = new ArrayList<VastTracker>();
            for (String clickTrackingUrl : clickTrackers) {
                vastClickTrackers.add(new VastTracker(clickTrackingUrl, false));
            }
            this.mVastVideoConfig.addClickTrackers(vastClickTrackers);
            this.mVastVideoConfig.setClickThroughUrl(this.getClickDestinationUrl());
            this.mNativeVideoController = this.mNativeVideoControllerFactory.createForId(this.mId, this.mContext, visibilityTrackingEvents, this.mVastVideoConfig, this.mEventDetails);
            this.mCustomEventNativeListener.onNativeAdLoaded(this);
        }

        private boolean containsRequiredKeys(@NonNull JSONObject jsonObject) {
            Preconditions.checkNotNull(jsonObject);
            HashSet keys = new HashSet();
            Iterator jsonKeys = jsonObject.keys();
            while (jsonKeys.hasNext()) {
                keys.add(jsonKeys.next());
            }
            return keys.containsAll(Parameter.requiredKeys);
        }

        private void addInstanceVariable(@NonNull Parameter key, @Nullable Object value) throws ClassCastException {
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkNotNull(value);
            try {
                switch (key) {
                    case IMPRESSION_TRACKER: {
                        this.addImpressionTrackers(value);
                        break;
                    }
                    case TITLE: {
                        this.setTitle((String)value);
                        break;
                    }
                    case TEXT: {
                        this.setText((String)value);
                        break;
                    }
                    case IMAGE_URL: {
                        this.setMainImageUrl((String)value);
                        break;
                    }
                    case ICON_URL: {
                        this.setIconImageUrl((String)value);
                        break;
                    }
                    case CLICK_DESTINATION: {
                        this.setClickDestinationUrl((String)value);
                        break;
                    }
                    case CLICK_TRACKER: {
                        this.parseClickTrackers(value);
                        break;
                    }
                    case CALL_TO_ACTION: {
                        this.setCallToAction((String)value);
                        break;
                    }
                    case VAST_VIDEO: {
                        this.setVastVideo((String)value);
                        break;
                    }
                    default: {
                        MoPubLog.d("Unable to add JSON key to internal mapping: " + key.mName);
                        break;
                    }
                }
            }
            catch (ClassCastException e) {
                if (!key.mRequired) {
                    MoPubLog.d("Ignoring class cast exception for optional key: " + key.mName);
                }
                throw e;
            }
        }

        private void parseClickTrackers(@NonNull Object clickTrackers) {
            if (clickTrackers instanceof JSONArray) {
                this.addClickTrackers(clickTrackers);
            } else {
                this.addClickTracker((String)clickTrackers);
            }
        }

        @Override
        public void render(@NonNull MediaLayout mediaLayout) {
            Preconditions.checkNotNull((Object)mediaLayout);
            this.mVideoVisibleTracking.addView(this.mRootView, (View)mediaLayout, this.mVideoResponseHeaders.getPlayVisiblePercent(), this.mVideoResponseHeaders.getPauseVisiblePercent());
            this.mMediaLayout = mediaLayout;
            this.mMediaLayout.initForVideo();
            this.mMediaLayout.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

                public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                    MoPubVideoNativeAd.this.mNativeVideoController.setListener(MoPubVideoNativeAd.this);
                    MoPubVideoNativeAd.this.mNativeVideoController.setOnAudioFocusChangeListener(MoPubVideoNativeAd.this);
                    MoPubVideoNativeAd.this.mNativeVideoController.setProgressListener(MoPubVideoNativeAd.this);
                    MoPubVideoNativeAd.this.mNativeVideoController.setTextureView(MoPubVideoNativeAd.this.mMediaLayout.getTextureView());
                    MoPubVideoNativeAd.this.mMediaLayout.resetProgress();
                    long duration = MoPubVideoNativeAd.this.mNativeVideoController.getDuration();
                    long currentPosition = MoPubVideoNativeAd.this.mNativeVideoController.getCurrentPosition();
                    if (MoPubVideoNativeAd.this.mLatestVideoControllerState == 5 || duration > 0L && duration - currentPosition < 750L) {
                        MoPubVideoNativeAd.this.mEnded = true;
                    }
                    if (MoPubVideoNativeAd.this.mNeedsPrepare) {
                        MoPubVideoNativeAd.this.mNeedsPrepare = false;
                        MoPubVideoNativeAd.this.mNativeVideoController.prepare(MoPubVideoNativeAd.this);
                    }
                    MoPubVideoNativeAd.this.mNeedsSeek = true;
                    MoPubVideoNativeAd.this.maybeChangeState();
                }

                public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                }

                public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                    MoPubVideoNativeAd.this.mNeedsPrepare = true;
                    MoPubVideoNativeAd.this.mNativeVideoController.release(MoPubVideoNativeAd.this);
                    MoPubVideoNativeAd.this.applyState(VideoState.PAUSED);
                    return true;
                }

                public void onSurfaceTextureUpdated(SurfaceTexture surface) {
                }
            });
            this.mMediaLayout.setPlayButtonClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MoPubVideoNativeAd.this.mMediaLayout.resetProgress();
                    MoPubVideoNativeAd.this.mNativeVideoController.seekTo(0L);
                    MoPubVideoNativeAd.this.mEnded = false;
                    MoPubVideoNativeAd.this.mNeedsSeek = false;
                }
            });
            this.mMediaLayout.setMuteControlClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MoPubVideoNativeAd.this.mMuted = !MoPubVideoNativeAd.this.mMuted;
                    MoPubVideoNativeAd.this.maybeChangeState();
                }
            });
            this.mMediaLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MoPubVideoNativeAd.this.prepareToLeaveView();
                    MoPubVideoNativeAd.this.mNativeVideoController.triggerImpressionTrackers();
                    MraidVideoPlayerActivity.startNativeVideo(MoPubVideoNativeAd.this.mContext, MoPubVideoNativeAd.this.mId, MoPubVideoNativeAd.this.mVastVideoConfig);
                }
            });
            if (this.mNativeVideoController.getPlaybackState() == 6) {
                this.mNativeVideoController.prepare(this);
            }
            this.applyState(VideoState.PAUSED);
        }

        @Override
        public void prepare(@NonNull View view) {
            Preconditions.checkNotNull(view);
            this.mRootView = view;
            this.mRootView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MoPubVideoNativeAd.this.prepareToLeaveView();
                    MoPubVideoNativeAd.this.mNativeVideoController.triggerImpressionTrackers();
                    MoPubVideoNativeAd.this.mNativeVideoController.handleCtaClick(MoPubVideoNativeAd.this.mContext);
                }
            });
        }

        @Override
        public void clear(@NonNull View view) {
            Preconditions.checkNotNull(view);
            this.mNativeVideoController.clear();
            this.cleanUpMediaLayout();
        }

        @Override
        public void destroy() {
            this.cleanUpMediaLayout();
            this.mNativeVideoController.setPlayWhenReady(false);
            this.mNativeVideoController.release(this);
            NativeVideoController.remove(this.mId);
            this.mVideoVisibleTracking.destroy();
        }

        @Override
        public void onStateChanged(boolean playWhenReady, int playbackState) {
            this.mLatestVideoControllerState = playbackState;
            this.maybeChangeState();
        }

        @Override
        public void onError(Exception e) {
            MoPubLog.w("Error playing back video.", e);
            this.mError = true;
            this.maybeChangeState();
        }

        @Override
        public void updateProgress(int progressTenthPercent) {
            this.mMediaLayout.updateProgress(progressTenthPercent);
        }

        public void onAudioFocusChange(int focusChange) {
            if (focusChange == -1 || focusChange == -2) {
                this.mMuted = true;
                this.maybeChangeState();
            } else if (focusChange == -3) {
                this.mNativeVideoController.setAudioVolume(0.3f);
            } else if (focusChange == 1) {
                this.mNativeVideoController.setAudioVolume(1.0f);
                this.maybeChangeState();
            }
        }

        private void cleanUpMediaLayout() {
            if (this.mMediaLayout != null) {
                this.mMediaLayout.setMode(MediaLayout.Mode.IMAGE);
                this.mMediaLayout.setSurfaceTextureListener(null);
                this.mMediaLayout.setPlayButtonClickListener(null);
                this.mMediaLayout.setMuteControlClickListener(null);
                this.mMediaLayout.setOnClickListener(null);
                this.mVideoVisibleTracking.removeView((View)this.mMediaLayout);
                this.mMediaLayout = null;
            }
        }

        private void prepareToLeaveView() {
            this.mNeedsSeek = true;
            this.mNeedsPrepare = true;
            this.mNativeVideoController.setListener(null);
            this.mNativeVideoController.setOnAudioFocusChangeListener(null);
            this.mNativeVideoController.setProgressListener(null);
            this.mNativeVideoController.clear();
            this.applyState(VideoState.PAUSED, true);
        }

        private void maybeChangeState() {
            VideoState newState = this.mVideoState;
            if (this.mError) {
                newState = VideoState.FAILED_LOAD;
            } else if (this.mEnded) {
                newState = VideoState.ENDED;
            } else if (this.mLatestVideoControllerState == 2 || this.mLatestVideoControllerState == 1) {
                newState = VideoState.LOADING;
            } else if (this.mLatestVideoControllerState == 3) {
                newState = VideoState.BUFFERING;
            } else if (this.mLatestVideoControllerState == 5) {
                this.mEnded = true;
                newState = VideoState.ENDED;
            } else if (this.mLatestVideoControllerState == 4) {
                newState = this.mLatestVisibility ? (this.mMuted ? VideoState.PLAYING_MUTED : VideoState.PLAYING) : VideoState.PAUSED;
            }
            this.applyState(newState);
        }

        @VisibleForTesting
        void applyState(@NonNull VideoState videoState) {
            this.applyState(videoState, false);
        }

        @VisibleForTesting
        void applyState(@NonNull VideoState videoState, boolean transitionToFullScreen) {
            Preconditions.checkNotNull((Object)videoState);
            if (this.mVastVideoConfig == null || this.mNativeVideoController == null || this.mMediaLayout == null) {
                return;
            }
            if (this.mVideoState == videoState) {
                return;
            }
            VideoState previousState = this.mVideoState;
            this.mVideoState = videoState;
            switch (videoState) {
                case FAILED_LOAD: {
                    this.mVastVideoConfig.handleError(this.mContext, null, 0);
                    this.mNativeVideoController.setAppAudioEnabled(false);
                    this.mMediaLayout.setMode(MediaLayout.Mode.IMAGE);
                    if (previousState == VideoState.PLAYING || previousState == VideoState.PLAYING_MUTED) break;
                    MoPubEvents.log(Event.createEventFromDetails(BaseEvent.Name.ERROR_FAILED_TO_PLAY, BaseEvent.Category.NATIVE_VIDEO, BaseEvent.SamplingRate.NATIVE_VIDEO, this.mEventDetails));
                    break;
                }
                case CREATED: 
                case LOADING: {
                    this.mNativeVideoController.setPlayWhenReady(true);
                    this.mMediaLayout.setMode(MediaLayout.Mode.LOADING);
                    break;
                }
                case BUFFERING: {
                    this.mNativeVideoController.setPlayWhenReady(true);
                    this.mMediaLayout.setMode(MediaLayout.Mode.BUFFERING);
                    break;
                }
                case PAUSED: {
                    if (transitionToFullScreen) {
                        this.mResumeCanBeTracked = false;
                    }
                    if (!transitionToFullScreen) {
                        this.mNativeVideoController.setAppAudioEnabled(false);
                        if (this.mPauseCanBeTracked) {
                            TrackingRequest.makeVastTrackingHttpRequest(this.mVastVideoConfig.getPauseTrackers(), null, (int)this.mNativeVideoController.getCurrentPosition(), null, this.mContext);
                            this.mPauseCanBeTracked = false;
                            this.mResumeCanBeTracked = true;
                        }
                    }
                    this.mNativeVideoController.setPlayWhenReady(false);
                    this.mMediaLayout.setMode(MediaLayout.Mode.PAUSED);
                    break;
                }
                case PLAYING: {
                    this.handleResumeTrackersAndSeek(previousState);
                    this.mNativeVideoController.setPlayWhenReady(true);
                    this.mNativeVideoController.setAudioEnabled(true);
                    this.mNativeVideoController.setAppAudioEnabled(true);
                    this.mMediaLayout.setMode(MediaLayout.Mode.PLAYING);
                    this.mMediaLayout.setMuteState(MediaLayout.MuteState.UNMUTED);
                    break;
                }
                case PLAYING_MUTED: {
                    this.handleResumeTrackersAndSeek(previousState);
                    this.mNativeVideoController.setPlayWhenReady(true);
                    this.mNativeVideoController.setAudioEnabled(false);
                    this.mNativeVideoController.setAppAudioEnabled(false);
                    this.mMediaLayout.setMode(MediaLayout.Mode.PLAYING);
                    this.mMediaLayout.setMuteState(MediaLayout.MuteState.MUTED);
                    break;
                }
                case ENDED: {
                    if (this.mNativeVideoController.hasFinalFrame()) {
                        this.mMediaLayout.setMainImageDrawable(this.mNativeVideoController.getFinalFrame());
                    }
                    this.mPauseCanBeTracked = false;
                    this.mResumeCanBeTracked = false;
                    this.mVastVideoConfig.handleComplete(this.mContext, 0);
                    this.mNativeVideoController.setAppAudioEnabled(false);
                    this.mMediaLayout.setMode(MediaLayout.Mode.FINISHED);
                    this.mMediaLayout.updateProgress(1000);
                }
            }
        }

        private void handleResumeTrackersAndSeek(VideoState previousState) {
            if (this.mResumeCanBeTracked && previousState != VideoState.PLAYING && previousState != VideoState.PLAYING_MUTED) {
                TrackingRequest.makeVastTrackingHttpRequest(this.mVastVideoConfig.getResumeTrackers(), null, (int)this.mNativeVideoController.getCurrentPosition(), null, this.mContext);
                this.mResumeCanBeTracked = false;
            }
            this.mPauseCanBeTracked = true;
            if (this.mNeedsSeek) {
                this.mNeedsSeek = false;
                this.mNativeVideoController.seekTo(this.mNativeVideoController.getCurrentPosition());
            }
        }

        private boolean isImageKey(@Nullable String name) {
            return name != null && name.toLowerCase(Locale.US).endsWith("image");
        }

        @NonNull
        private List<String> getExtrasImageUrls() {
            ArrayList<String> extrasBitmapUrls = new ArrayList<String>(this.getExtras().size());
            for (Map.Entry<String, Object> entry : this.getExtras().entrySet()) {
                if (!this.isImageKey(entry.getKey()) || !(entry.getValue() instanceof String)) continue;
                extrasBitmapUrls.add((String)entry.getValue());
            }
            return extrasBitmapUrls;
        }

        @NonNull
        private List<String> getAllImageUrls() {
            ArrayList<String> imageUrls = new ArrayList<String>();
            if (this.getMainImageUrl() != null) {
                imageUrls.add(this.getMainImageUrl());
            }
            if (this.getIconImageUrl() != null) {
                imageUrls.add(this.getIconImageUrl());
            }
            imageUrls.addAll(this.getExtrasImageUrls());
            return imageUrls;
        }

        @Deprecated
        @VisibleForTesting
        boolean needsPrepare() {
            return this.mNeedsPrepare;
        }

        @Deprecated
        @VisibleForTesting
        boolean hasEnded() {
            return this.mEnded;
        }

        @Deprecated
        @VisibleForTesting
        boolean needsSeek() {
            return this.mNeedsSeek;
        }

        @Deprecated
        @VisibleForTesting
        boolean isMuted() {
            return this.mMuted;
        }

        @Deprecated
        @VisibleForTesting
        long getId() {
            return this.mId;
        }

        @Deprecated
        @VisibleForTesting
        VideoState getVideoState() {
            return this.mVideoState;
        }

        @Deprecated
        @VisibleForTesting
        void setLatestVisibility(boolean latestVisibility) {
            this.mLatestVisibility = latestVisibility;
        }

        @Deprecated
        @VisibleForTesting
        void setMuted(boolean muted) {
            this.mMuted = muted;
        }

        @Deprecated
        @VisibleForTesting
        MediaLayout getMediaLayout() {
            return this.mMediaLayout;
        }

        public static enum VideoState {
            CREATED,
            LOADING,
            BUFFERING,
            PAUSED,
            PLAYING,
            PLAYING_MUTED,
            ENDED,
            FAILED_LOAD;

        }

        static enum Parameter {
            IMPRESSION_TRACKER("imptracker", true),
            CLICK_TRACKER("clktracker", true),
            TITLE("title", false),
            TEXT("text", false),
            IMAGE_URL("mainimage", false),
            ICON_URL("iconimage", false),
            CLICK_DESTINATION("clk", false),
            FALLBACK("fallback", false),
            CALL_TO_ACTION("ctatext", false),
            VAST_VIDEO("video", false);

            @NonNull
            final String mName;
            final boolean mRequired;
            @NonNull
            @VisibleForTesting
            static final Set<String> requiredKeys;

            private Parameter(String name, boolean required) {
                Preconditions.checkNotNull(name);
                this.mName = name;
                this.mRequired = required;
            }

            @Nullable
            static Parameter from(@NonNull String name) {
                Preconditions.checkNotNull(name);
                for (Parameter parameter : Parameter.values()) {
                    if (!parameter.mName.equals(name)) continue;
                    return parameter;
                }
                return null;
            }

            static {
                requiredKeys = new HashSet<String>();
                for (Parameter parameter : Parameter.values()) {
                    if (!parameter.mRequired) continue;
                    requiredKeys.add(parameter.mName);
                }
            }
        }
    }
}

