/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer.upstream.HttpDataSource;
import com.mopub.common.CacheService;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.event.BaseEvent;
import com.mopub.common.event.Event;
import com.mopub.common.event.EventDetails;
import com.mopub.common.event.MoPubEvents;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.IntInterval;
import java.io.IOException;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpDiskCompositeDataSource
implements DataSource {
    @VisibleForTesting
    static final String INTERVALS_KEY_PREFIX = "intervals-sorted-";
    @VisibleForTesting
    static final String EXPECTED_FILE_SIZE_KEY_PREFIX = "expectedsize-";
    private static final String START = "start";
    private static final String LENGTH = "length";
    @VisibleForTesting
    static final int LENGTH_UNBOUNDED = -1;
    private static final int HTTP_RESPONSE_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    @VisibleForTesting
    static final int BLOCK_SIZE = 512000;
    @NonNull
    private final HttpDataSource mHttpDataSource;
    @Nullable
    private byte[] mCachedBytes;
    @Nullable
    private String mKey;
    @NonNull
    private final TreeSet<IntInterval> mIntervals;
    private int mStartInFile;
    private int mDataBlockOffset;
    private int mSegment;
    private int mStartInDataBlock;
    private boolean mIsHttpSourceOpen;
    @Nullable
    private Integer mExpectedFileLength = null;
    @Nullable
    private DataSpec mDataSpec;
    private boolean mIsDirty;
    @Nullable
    private final EventDetails mEventDetails;
    private boolean mHasLoggedDownloadStart;

    public HttpDiskCompositeDataSource(@NonNull Context context, @NonNull String userAgent, @Nullable EventDetails eventDetails) {
        this(context, userAgent, eventDetails, (HttpDataSource)new DefaultHttpDataSource(userAgent, null, null, 8000, 8000, false));
    }

    @VisibleForTesting
    HttpDiskCompositeDataSource(@NonNull Context context, @NonNull String userAgent, @Nullable EventDetails eventDetails, @NonNull HttpDataSource httpDataSource) {
        this.mHttpDataSource = httpDataSource;
        CacheService.initialize(context);
        this.mIntervals = new TreeSet();
        this.mEventDetails = eventDetails;
    }

    public long open(@NonNull DataSpec dataSpec) throws IOException {
        long size;
        Preconditions.checkNotNull(dataSpec);
        if (dataSpec.uri == null) {
            return -1L;
        }
        this.mIsDirty = false;
        this.mDataSpec = dataSpec;
        this.mKey = dataSpec.uri.toString();
        if (this.mKey == null) {
            return -1L;
        }
        this.mStartInFile = (int)dataSpec.absoluteStreamPosition;
        this.mSegment = this.mStartInFile / 512000;
        this.mCachedBytes = CacheService.getFromDiskCache(this.mSegment + this.mKey);
        this.mStartInDataBlock = this.mStartInFile % 512000;
        this.mDataBlockOffset = 0;
        this.mExpectedFileLength = HttpDiskCompositeDataSource.getExpectedFileLengthFromDisk(this.mKey);
        HttpDiskCompositeDataSource.populateIntervalsFromDisk(this.mKey, this.mIntervals);
        int mDataRequestStartPoint = HttpDiskCompositeDataSource.getFirstContiguousPointAfter(this.mStartInFile, this.mIntervals);
        if (this.mCachedBytes == null) {
            this.mCachedBytes = new byte[512000];
            if (mDataRequestStartPoint > this.mStartInFile) {
                MoPubLog.d("Cache segment " + this.mSegment + " was evicted. Invalidating cache");
                this.mIntervals.clear();
                mDataRequestStartPoint = (int)dataSpec.absoluteStreamPosition;
            }
        }
        if (this.mExpectedFileLength == null || mDataRequestStartPoint != this.mExpectedFileLength) {
            long lengthToUse = this.mDataSpec.length == -1L ? -1L : this.mDataSpec.length - (long)(mDataRequestStartPoint - this.mStartInFile);
            DataSpec modifiedDataSpec = new DataSpec(dataSpec.uri, (long)mDataRequestStartPoint, lengthToUse, dataSpec.key, dataSpec.flags);
            try {
                size = this.mHttpDataSource.open(modifiedDataSpec);
                if (this.mExpectedFileLength == null && lengthToUse == -1L) {
                    this.mExpectedFileLength = (int)((long)this.mStartInFile + size);
                    CacheService.putToDiskCache(EXPECTED_FILE_SIZE_KEY_PREFIX + this.mKey, String.valueOf(this.mExpectedFileLength).getBytes());
                }
                this.mIsHttpSourceOpen = true;
                if (!this.mHasLoggedDownloadStart) {
                    MoPubEvents.log(Event.createEventFromDetails(BaseEvent.Name.DOWNLOAD_START, BaseEvent.Category.NATIVE_VIDEO, BaseEvent.SamplingRate.NATIVE_VIDEO, this.mEventDetails));
                    this.mHasLoggedDownloadStart = true;
                }
            }
            catch (HttpDataSource.InvalidResponseCodeException e) {
                if (e.responseCode != 416) {
                    throw e;
                }
                size = this.mExpectedFileLength == null ? (long)(mDataRequestStartPoint - this.mStartInFile) : (long)(this.mExpectedFileLength - this.mStartInFile);
                this.mIsHttpSourceOpen = false;
            }
        } else {
            size = dataSpec.length == -1L ? (long)(this.mExpectedFileLength - this.mStartInFile) : dataSpec.length;
        }
        return size;
    }

    private static void populateIntervalsFromDisk(@NonNull String key, @NonNull TreeSet<IntInterval> intervals) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(intervals);
        intervals.clear();
        byte[] intervalsFromDisk = CacheService.getFromDiskCache(INTERVALS_KEY_PREFIX + key);
        if (intervalsFromDisk != null) {
            String intervalsStringData = new String(intervalsFromDisk);
            try {
                JSONArray jsonIntervalArray = new JSONArray(intervalsStringData);
                for (int i = 0; i < jsonIntervalArray.length(); ++i) {
                    JSONObject jsonInterval = new JSONObject((String)jsonIntervalArray.get(i));
                    intervals.add(new IntInterval(jsonInterval.getInt(START), jsonInterval.getInt(LENGTH)));
                }
            }
            catch (JSONException e) {
                MoPubLog.d("clearing cache since invalid json intervals found", e);
                intervals.clear();
            }
            catch (ClassCastException e) {
                MoPubLog.d("clearing cache since unable to read json data");
                intervals.clear();
            }
        }
    }

    private static Integer getExpectedFileLengthFromDisk(@NonNull String key) {
        Preconditions.checkNotNull(key);
        byte[] maxSizeByteArray = CacheService.getFromDiskCache(EXPECTED_FILE_SIZE_KEY_PREFIX + key);
        if (maxSizeByteArray != null) {
            try {
                return Integer.parseInt(new String(maxSizeByteArray));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public void close() throws IOException {
        if (!TextUtils.isEmpty((CharSequence)this.mKey) && this.mCachedBytes != null) {
            CacheService.putToDiskCache(this.mSegment + this.mKey, this.mCachedBytes);
            HttpDiskCompositeDataSource.addNewInterval(this.mIntervals, this.mStartInFile, this.mDataBlockOffset);
            HttpDiskCompositeDataSource.writeIntervalsToDisk(this.mIntervals, this.mKey);
            if (this.mIsDirty && this.mExpectedFileLength != null && HttpDiskCompositeDataSource.getFirstContiguousPointAfter(0, this.mIntervals) == this.mExpectedFileLength) {
                MoPubEvents.log(Event.createEventFromDetails(BaseEvent.Name.DOWNLOAD_FINISHED, BaseEvent.Category.NATIVE_VIDEO, BaseEvent.SamplingRate.NATIVE_VIDEO, this.mEventDetails));
            }
        }
        this.mCachedBytes = null;
        this.mHttpDataSource.close();
        this.mIsHttpSourceOpen = false;
        this.mStartInFile = 0;
        this.mDataBlockOffset = 0;
        this.mStartInDataBlock = 0;
        this.mExpectedFileLength = null;
        this.mIsDirty = false;
    }

    private static void writeIntervalsToDisk(@NonNull TreeSet<IntInterval> intervals, @NonNull String key) {
        Preconditions.checkNotNull(intervals);
        Preconditions.checkNotNull(key);
        JSONArray jsonIntervals = new JSONArray();
        for (IntInterval interval : intervals) {
            jsonIntervals.put((Object)interval);
        }
        CacheService.putToDiskCache(INTERVALS_KEY_PREFIX + key, jsonIntervals.toString().getBytes());
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesToReadFromNetwork;
        if (length > 512000) {
            MoPubLog.d("Reading more than the block size (512000 bytes) at once is not possible. length = " + length);
            return -1;
        }
        if (this.mDataSpec == null) {
            MoPubLog.d("Unable to read from data source when no spec provided");
            return -1;
        }
        if (this.mCachedBytes == null) {
            MoPubLog.d("No cache set up. Call open before read.");
            return -1;
        }
        int bytesAvailableInCurrentBlock = 512000 - this.mStartInDataBlock - this.mDataBlockOffset;
        int farthestContiguousPoint = HttpDiskCompositeDataSource.getFirstContiguousPointAfter(this.mStartInFile + this.mDataBlockOffset, this.mIntervals);
        int validBytesLeftInCache = farthestContiguousPoint - this.mStartInFile - this.mDataBlockOffset;
        int bytesToRead = Math.min(validBytesLeftInCache, length);
        int bytesReadFromDisk = 0;
        if (HttpDiskCompositeDataSource.areBytesAvailableInCache(farthestContiguousPoint, this.mStartInFile, this.mDataBlockOffset)) {
            if (bytesToRead <= bytesAvailableInCurrentBlock) {
                System.arraycopy(this.mCachedBytes, this.mStartInDataBlock + this.mDataBlockOffset, buffer, offset, bytesToRead);
                this.mDataBlockOffset += bytesToRead;
                bytesReadFromDisk += bytesToRead;
            } else {
                System.arraycopy(this.mCachedBytes, this.mStartInDataBlock + this.mDataBlockOffset, buffer, offset, bytesAvailableInCurrentBlock);
                this.mDataBlockOffset += bytesAvailableInCurrentBlock;
                bytesReadFromDisk += bytesAvailableInCurrentBlock;
                this.writeCacheToDiskAndClearVariables();
                this.mCachedBytes = CacheService.getFromDiskCache(this.mSegment + this.mKey);
                if (this.mCachedBytes == null) {
                    MoPubLog.d("Unexpected cache miss. Invalidating cache");
                    this.mIntervals.clear();
                    this.mCachedBytes = new byte[512000];
                    this.mHttpDataSource.close();
                    this.mHttpDataSource.open(new DataSpec(this.mDataSpec.uri, (long)(this.mStartInFile + this.mDataBlockOffset), -1L, this.mDataSpec.key, this.mDataSpec.flags));
                    this.mIsHttpSourceOpen = true;
                } else {
                    System.arraycopy(this.mCachedBytes, this.mStartInDataBlock + this.mDataBlockOffset, buffer, offset + bytesReadFromDisk, bytesToRead - bytesReadFromDisk);
                    this.mDataBlockOffset += bytesToRead - bytesReadFromDisk;
                    bytesReadFromDisk = bytesToRead;
                }
            }
        }
        if ((bytesToReadFromNetwork = length - bytesReadFromDisk) <= 0) {
            return bytesReadFromDisk;
        }
        this.mIsDirty = true;
        if (!this.mIsHttpSourceOpen) {
            MoPubLog.d("end of cache reached. No http source open");
            return -1;
        }
        int bytesAvailableInCurrentBlockForNetwork = 512000 - this.mStartInDataBlock - this.mDataBlockOffset;
        int bytesReadFromNetwork = this.mHttpDataSource.read(buffer, offset + bytesReadFromDisk, bytesToReadFromNetwork);
        if (bytesAvailableInCurrentBlockForNetwork < bytesReadFromNetwork) {
            System.arraycopy(buffer, offset + bytesReadFromDisk, this.mCachedBytes, this.mStartInDataBlock + this.mDataBlockOffset, bytesAvailableInCurrentBlockForNetwork);
            this.mDataBlockOffset += bytesAvailableInCurrentBlockForNetwork;
            this.writeCacheToDiskAndClearVariables();
            this.mCachedBytes = CacheService.getFromDiskCache(this.mSegment + this.mKey);
            if (this.mCachedBytes == null) {
                this.mCachedBytes = new byte[512000];
            }
            System.arraycopy(buffer, offset + bytesAvailableInCurrentBlockForNetwork + bytesReadFromDisk, this.mCachedBytes, this.mStartInDataBlock + this.mDataBlockOffset, bytesReadFromNetwork - bytesAvailableInCurrentBlockForNetwork);
            this.mDataBlockOffset += bytesReadFromNetwork - bytesAvailableInCurrentBlockForNetwork;
        } else {
            System.arraycopy(buffer, offset + bytesReadFromDisk, this.mCachedBytes, this.mStartInDataBlock + this.mDataBlockOffset, bytesReadFromNetwork);
            this.mDataBlockOffset += bytesReadFromNetwork;
        }
        return bytesReadFromNetwork + bytesReadFromDisk;
    }

    private static boolean areBytesAvailableInCache(int farthestContiguousPoint, int startInFile, int dataBlockOffset) {
        return farthestContiguousPoint > startInFile + dataBlockOffset;
    }

    private void writeCacheToDiskAndClearVariables() {
        CacheService.putToDiskCache(this.mSegment + this.mKey, this.mCachedBytes);
        HttpDiskCompositeDataSource.addNewInterval(this.mIntervals, this.mStartInFile, this.mDataBlockOffset);
        this.mStartInDataBlock = 0;
        this.mStartInFile += this.mDataBlockOffset;
        this.mDataBlockOffset = 0;
        this.mSegment = this.mStartInFile / 512000;
    }

    @VisibleForTesting
    static int getFirstContiguousPointAfter(int point, @NonNull TreeSet<IntInterval> intervals) {
        Preconditions.checkNotNull(intervals);
        int lastContiguousPoint = point;
        for (IntInterval interval : intervals) {
            if (interval.getStart() > lastContiguousPoint) continue;
            lastContiguousPoint = Math.max(lastContiguousPoint, interval.getStart() + interval.getLength());
        }
        return lastContiguousPoint;
    }

    @VisibleForTesting
    static void addNewInterval(@NonNull TreeSet<IntInterval> intervals, int start, int length) {
        Preconditions.checkNotNull(intervals);
        if (HttpDiskCompositeDataSource.getFirstContiguousPointAfter(start, intervals) >= start + length) {
            return;
        }
        intervals.add(new IntInterval(start, length));
    }
}

