/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.NativeAd;
import java.util.ArrayList;

public class AdRendererRegistry {
    @NonNull
    private final ArrayList<MoPubAdRenderer> mMoPubAdRenderers = new ArrayList();

    public void registerAdRenderer(@NonNull MoPubAdRenderer moPubAdRenderer) {
        this.mMoPubAdRenderers.add(moPubAdRenderer);
    }

    public int getAdRendererCount() {
        return this.mMoPubAdRenderers.size();
    }

    @NonNull
    public Iterable<MoPubAdRenderer> getRendererIterable() {
        return this.mMoPubAdRenderers;
    }

    public int getViewTypeForAd(@NonNull NativeAd nativeAd) {
        Preconditions.checkNotNull(nativeAd);
        for (int i = 0; i < this.mMoPubAdRenderers.size(); ++i) {
            if (nativeAd.getMoPubAdRenderer() != this.mMoPubAdRenderers.get(i)) continue;
            return i + 1;
        }
        return 0;
    }

    @Nullable
    public MoPubAdRenderer getRendererForAd(@NonNull BaseNativeAd nativeAd) {
        Preconditions.checkNotNull(nativeAd);
        for (MoPubAdRenderer moPubAdRenderer : this.mMoPubAdRenderers) {
            if (!moPubAdRenderer.supports(nativeAd)) continue;
            return moPubAdRenderer;
        }
        return null;
    }

    @Nullable
    public MoPubAdRenderer getRendererForViewType(int viewType) {
        try {
            return this.mMoPubAdRenderers.get(viewType - 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}

