/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.JsResult;
import android.widget.FrameLayout;
import com.mopub.common.AdReport;
import com.mopub.common.CloseableLayout;
import com.mopub.common.Preconditions;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlHandler;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Utils;
import com.mopub.common.util.Views;
import com.mopub.mobileads.MraidVideoPlayerActivity;
import com.mopub.mobileads.util.WebViews;
import com.mopub.mraid.MraidBridge;
import com.mopub.mraid.MraidCommandException;
import com.mopub.mraid.MraidNativeCommandHandler;
import com.mopub.mraid.MraidOrientation;
import com.mopub.mraid.MraidScreenMetrics;
import com.mopub.mraid.MraidWebViewDebugListener;
import com.mopub.mraid.PlacementType;
import com.mopub.mraid.ViewState;
import java.lang.ref.WeakReference;
import java.net.URI;

public class MraidController {
    private final AdReport mAdReport;
    @NonNull
    private final WeakReference<Activity> mWeakActivity;
    @NonNull
    private final Context mContext;
    @NonNull
    private final PlacementType mPlacementType;
    @NonNull
    private final FrameLayout mDefaultAdContainer;
    @NonNull
    private final CloseableLayout mCloseableAdContainer;
    @Nullable
    private ViewGroup mRootView;
    @NonNull
    private final ScreenMetricsWaiter mScreenMetricsWaiter;
    @NonNull
    private final MraidScreenMetrics mScreenMetrics;
    @NonNull
    private ViewState mViewState = ViewState.LOADING;
    @Nullable
    private MraidListener mMraidListener;
    @Nullable
    private UseCustomCloseListener mOnCloseButtonListener;
    @Nullable
    private MraidWebViewDebugListener mDebugListener;
    @Nullable
    private MraidBridge.MraidWebView mMraidWebView;
    @Nullable
    private MraidBridge.MraidWebView mTwoPartWebView;
    @NonNull
    private final MraidBridge mMraidBridge;
    @NonNull
    private final MraidBridge mTwoPartBridge;
    @NonNull
    private OrientationBroadcastReceiver mOrientationBroadcastReceiver = new OrientationBroadcastReceiver();
    @Nullable
    private Integer mOriginalActivityOrientation;
    private boolean mAllowOrientationChange = true;
    private MraidOrientation mForceOrientation = MraidOrientation.NONE;
    private final MraidNativeCommandHandler mMraidNativeCommandHandler;
    private boolean mIsPaused;
    private final MraidBridge.MraidBridgeListener mMraidBridgeListener = new MraidBridge.MraidBridgeListener(){

        @Override
        public void onPageLoaded() {
            MraidController.this.handlePageLoad();
        }

        @Override
        public void onPageFailedToLoad() {
            if (MraidController.this.mMraidListener != null) {
                MraidController.this.mMraidListener.onFailedToLoad();
            }
        }

        @Override
        public void onVisibilityChanged(boolean isVisible) {
            if (!MraidController.this.mTwoPartBridge.isAttached()) {
                MraidController.this.mMraidBridge.notifyViewability(isVisible);
            }
        }

        @Override
        public boolean onJsAlert(@NonNull String message, @NonNull JsResult result) {
            return MraidController.this.handleJsAlert(message, result);
        }

        @Override
        public boolean onConsoleMessage(@NonNull ConsoleMessage consoleMessage) {
            return MraidController.this.handleConsoleMessage(consoleMessage);
        }

        @Override
        public void onClose() {
            MraidController.this.handleClose();
        }

        @Override
        public void onResize(int width, int height, int offsetX, int offsetY, @NonNull CloseableLayout.ClosePosition closePosition, boolean allowOffscreen) throws MraidCommandException {
            MraidController.this.handleResize(width, height, offsetX, offsetY, closePosition, allowOffscreen);
        }

        @Override
        public void onExpand(@Nullable URI uri, boolean shouldUseCustomClose) throws MraidCommandException {
            MraidController.this.handleExpand(uri, shouldUseCustomClose);
        }

        @Override
        public void onUseCustomClose(boolean shouldUseCustomClose) {
            MraidController.this.handleCustomClose(shouldUseCustomClose);
        }

        @Override
        public void onSetOrientationProperties(boolean allowOrientationChange, MraidOrientation forceOrientation) throws MraidCommandException {
            MraidController.this.handleSetOrientationProperties(allowOrientationChange, forceOrientation);
        }

        @Override
        public void onOpen(@NonNull URI uri) {
            MraidController.this.handleOpen(uri.toString());
        }

        @Override
        public void onPlayVideo(@NonNull URI uri) {
            MraidController.this.handleShowVideo(uri.toString());
        }
    };
    private final MraidBridge.MraidBridgeListener mTwoPartBridgeListener = new MraidBridge.MraidBridgeListener(){

        @Override
        public void onPageLoaded() {
            MraidController.this.handleTwoPartPageLoad();
        }

        @Override
        public void onPageFailedToLoad() {
        }

        @Override
        public void onVisibilityChanged(boolean isVisible) {
            MraidController.this.mMraidBridge.notifyViewability(isVisible);
            MraidController.this.mTwoPartBridge.notifyViewability(isVisible);
        }

        @Override
        public boolean onJsAlert(@NonNull String message, @NonNull JsResult result) {
            return MraidController.this.handleJsAlert(message, result);
        }

        @Override
        public boolean onConsoleMessage(@NonNull ConsoleMessage consoleMessage) {
            return MraidController.this.handleConsoleMessage(consoleMessage);
        }

        @Override
        public void onResize(int width, int height, int offsetX, int offsetY, @NonNull CloseableLayout.ClosePosition closePosition, boolean allowOffscreen) throws MraidCommandException {
            throw new MraidCommandException("Not allowed to resize from an expanded state");
        }

        @Override
        public void onExpand(@Nullable URI uri, boolean shouldUseCustomClose) {
        }

        @Override
        public void onClose() {
            MraidController.this.handleClose();
        }

        @Override
        public void onUseCustomClose(boolean shouldUseCustomClose) {
            MraidController.this.handleCustomClose(shouldUseCustomClose);
        }

        @Override
        public void onSetOrientationProperties(boolean allowOrientationChange, MraidOrientation forceOrientation) throws MraidCommandException {
            MraidController.this.handleSetOrientationProperties(allowOrientationChange, forceOrientation);
        }

        @Override
        public void onOpen(URI uri) {
            MraidController.this.handleOpen(uri.toString());
        }

        @Override
        public void onPlayVideo(@NonNull URI uri) {
            MraidController.this.handleShowVideo(uri.toString());
        }
    };

    public MraidController(@NonNull Context context, @Nullable AdReport adReport, @NonNull PlacementType placementType) {
        this(context, adReport, placementType, new MraidBridge(adReport, placementType), new MraidBridge(adReport, PlacementType.INTERSTITIAL), new ScreenMetricsWaiter());
    }

    @VisibleForTesting
    MraidController(@NonNull Context context, @Nullable AdReport adReport, @NonNull PlacementType placementType, @NonNull MraidBridge bridge, @NonNull MraidBridge twoPartBridge, @NonNull ScreenMetricsWaiter screenMetricsWaiter) {
        this.mContext = context.getApplicationContext();
        Preconditions.checkNotNull(this.mContext);
        this.mAdReport = adReport;
        this.mWeakActivity = context instanceof Activity ? new WeakReference<Activity>((Activity)context) : new WeakReference<Object>(null);
        this.mPlacementType = placementType;
        this.mMraidBridge = bridge;
        this.mTwoPartBridge = twoPartBridge;
        this.mScreenMetricsWaiter = screenMetricsWaiter;
        this.mViewState = ViewState.LOADING;
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        this.mScreenMetrics = new MraidScreenMetrics(this.mContext, displayMetrics.density);
        this.mDefaultAdContainer = new FrameLayout(this.mContext);
        this.mCloseableAdContainer = new CloseableLayout(this.mContext);
        this.mCloseableAdContainer.setOnCloseListener(new CloseableLayout.OnCloseListener(){

            @Override
            public void onClose() {
                MraidController.this.handleClose();
            }
        });
        View dimmingView = new View(this.mContext);
        dimmingView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.mCloseableAdContainer.addView(dimmingView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mOrientationBroadcastReceiver.register(this.mContext);
        this.mMraidBridge.setMraidBridgeListener(this.mMraidBridgeListener);
        this.mTwoPartBridge.setMraidBridgeListener(this.mTwoPartBridgeListener);
        this.mMraidNativeCommandHandler = new MraidNativeCommandHandler();
    }

    public void setMraidListener(@Nullable MraidListener mraidListener) {
        this.mMraidListener = mraidListener;
    }

    public void setUseCustomCloseListener(@Nullable UseCustomCloseListener listener) {
        this.mOnCloseButtonListener = listener;
    }

    public void setDebugListener(@Nullable MraidWebViewDebugListener debugListener) {
        this.mDebugListener = debugListener;
    }

    public void loadContent(@NonNull String htmlData) {
        Preconditions.checkState(this.mMraidWebView == null, "loadContent should only be called once");
        this.mMraidWebView = new MraidBridge.MraidWebView(this.mContext);
        this.mMraidBridge.attachView(this.mMraidWebView);
        this.mDefaultAdContainer.addView((View)this.mMraidWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mMraidBridge.setContentHtml(htmlData);
    }

    private int getDisplayRotation() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        return wm.getDefaultDisplay().getRotation();
    }

    @VisibleForTesting
    boolean handleConsoleMessage(@NonNull ConsoleMessage consoleMessage) {
        if (this.mDebugListener != null) {
            return this.mDebugListener.onConsoleMessage(consoleMessage);
        }
        return true;
    }

    @VisibleForTesting
    boolean handleJsAlert(@NonNull String message, @NonNull JsResult result) {
        if (this.mDebugListener != null) {
            return this.mDebugListener.onJsAlert(message, result);
        }
        result.confirm();
        return true;
    }

    @Nullable
    private View getCurrentWebView() {
        return this.mTwoPartBridge.isAttached() ? this.mTwoPartWebView : this.mMraidWebView;
    }

    private boolean isInlineVideoAvailable() {
        Activity activity = (Activity)this.mWeakActivity.get();
        if (activity == null || this.getCurrentWebView() == null) {
            return false;
        }
        return this.mMraidNativeCommandHandler.isInlineVideoAvailable(activity, this.getCurrentWebView());
    }

    @VisibleForTesting
    void handlePageLoad() {
        this.setViewState(ViewState.DEFAULT, new Runnable(){

            @Override
            public void run() {
                MraidController.this.mMraidBridge.notifySupports(MraidController.this.mMraidNativeCommandHandler.isSmsAvailable(MraidController.this.mContext), MraidController.this.mMraidNativeCommandHandler.isTelAvailable(MraidController.this.mContext), MraidNativeCommandHandler.isCalendarAvailable(MraidController.this.mContext), MraidNativeCommandHandler.isStorePictureSupported(MraidController.this.mContext), MraidController.this.isInlineVideoAvailable());
                MraidController.this.mMraidBridge.notifyPlacementType(MraidController.this.mPlacementType);
                MraidController.this.mMraidBridge.notifyViewability(MraidController.this.mMraidBridge.isVisible());
                MraidController.this.mMraidBridge.notifyReady();
            }
        });
        if (this.mMraidListener != null) {
            this.mMraidListener.onLoaded((View)this.mDefaultAdContainer);
        }
    }

    @VisibleForTesting
    void handleTwoPartPageLoad() {
        this.updateScreenMetricsAsync(new Runnable(){

            @Override
            public void run() {
                MraidBridge mraidBridge = MraidController.this.mTwoPartBridge;
                boolean bl = MraidController.this.mMraidNativeCommandHandler.isSmsAvailable(MraidController.this.mContext);
                boolean bl2 = MraidController.this.mMraidNativeCommandHandler.isTelAvailable(MraidController.this.mContext);
                MraidController.this.mMraidNativeCommandHandler;
                boolean bl3 = MraidNativeCommandHandler.isCalendarAvailable(MraidController.this.mContext);
                MraidController.this.mMraidNativeCommandHandler;
                mraidBridge.notifySupports(bl, bl2, bl3, MraidNativeCommandHandler.isStorePictureSupported(MraidController.this.mContext), MraidController.this.isInlineVideoAvailable());
                MraidController.this.mTwoPartBridge.notifyViewState(MraidController.this.mViewState);
                MraidController.this.mTwoPartBridge.notifyPlacementType(MraidController.this.mPlacementType);
                MraidController.this.mTwoPartBridge.notifyViewability(MraidController.this.mTwoPartBridge.isVisible());
                MraidController.this.mTwoPartBridge.notifyReady();
            }
        });
    }

    private void updateScreenMetricsAsync(final @Nullable Runnable successRunnable) {
        this.mScreenMetricsWaiter.cancelLastRequest();
        final View currentWebView = this.getCurrentWebView();
        if (currentWebView == null) {
            return;
        }
        this.mScreenMetricsWaiter.waitFor(new View[]{this.mDefaultAdContainer, currentWebView}).start(new Runnable(){

            @Override
            public void run() {
                DisplayMetrics displayMetrics = MraidController.this.mContext.getResources().getDisplayMetrics();
                MraidController.this.mScreenMetrics.setScreenSize(displayMetrics.widthPixels, displayMetrics.heightPixels);
                int[] location = new int[2];
                ViewGroup rootView = MraidController.this.getRootView();
                rootView.getLocationOnScreen(location);
                MraidController.this.mScreenMetrics.setRootViewPosition(location[0], location[1], rootView.getWidth(), rootView.getHeight());
                MraidController.this.mDefaultAdContainer.getLocationOnScreen(location);
                MraidController.this.mScreenMetrics.setDefaultAdPosition(location[0], location[1], MraidController.this.mDefaultAdContainer.getWidth(), MraidController.this.mDefaultAdContainer.getHeight());
                currentWebView.getLocationOnScreen(location);
                MraidController.this.mScreenMetrics.setCurrentAdPosition(location[0], location[1], currentWebView.getWidth(), currentWebView.getHeight());
                MraidController.this.mMraidBridge.notifyScreenMetrics(MraidController.this.mScreenMetrics);
                if (MraidController.this.mTwoPartBridge.isAttached()) {
                    MraidController.this.mTwoPartBridge.notifyScreenMetrics(MraidController.this.mScreenMetrics);
                }
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }
        });
    }

    void handleOrientationChange(int currentRotation) {
        this.updateScreenMetricsAsync(null);
    }

    public void pause(boolean isFinishing) {
        this.mIsPaused = true;
        if (this.mMraidWebView != null) {
            WebViews.onPause(this.mMraidWebView, isFinishing);
        }
        if (this.mTwoPartWebView != null) {
            WebViews.onPause(this.mTwoPartWebView, isFinishing);
        }
    }

    public void resume() {
        this.mIsPaused = false;
        if (this.mMraidWebView != null) {
            WebViews.onResume(this.mMraidWebView);
        }
        if (this.mTwoPartWebView != null) {
            WebViews.onResume(this.mTwoPartWebView);
        }
    }

    public void destroy() {
        block5: {
            this.mScreenMetricsWaiter.cancelLastRequest();
            try {
                this.mOrientationBroadcastReceiver.unregister();
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("Receiver not registered")) break block5;
                throw e;
            }
        }
        if (!this.mIsPaused) {
            this.pause(true);
        }
        Views.removeFromParent((View)this.mCloseableAdContainer);
        this.mMraidBridge.detach();
        if (this.mMraidWebView != null) {
            this.mMraidWebView.destroy();
            this.mMraidWebView = null;
        }
        this.mTwoPartBridge.detach();
        if (this.mTwoPartWebView != null) {
            this.mTwoPartWebView.destroy();
            this.mTwoPartWebView = null;
        }
    }

    private void setViewState(@NonNull ViewState viewState) {
        this.setViewState(viewState, null);
    }

    private void setViewState(@NonNull ViewState viewState, @Nullable Runnable successRunnable) {
        MoPubLog.d("MRAID state set to " + (Object)((Object)viewState));
        this.mViewState = viewState;
        this.mMraidBridge.notifyViewState(viewState);
        if (this.mTwoPartBridge.isLoaded()) {
            this.mTwoPartBridge.notifyViewState(viewState);
        }
        if (this.mMraidListener != null) {
            if (viewState == ViewState.EXPANDED) {
                this.mMraidListener.onExpand();
            } else if (viewState == ViewState.HIDDEN) {
                this.mMraidListener.onClose();
            }
        }
        this.updateScreenMetricsAsync(successRunnable);
    }

    int clampInt(int min, int target, int max) {
        return Math.max(min, Math.min(target, max));
    }

    @VisibleForTesting
    void handleResize(int widthDips, int heightDips, int offsetXDips, int offsetYDips, @NonNull CloseableLayout.ClosePosition closePosition, boolean allowOffscreen) throws MraidCommandException {
        if (this.mMraidWebView == null) {
            throw new MraidCommandException("Unable to resize after the WebView is destroyed");
        }
        if (this.mViewState == ViewState.LOADING || this.mViewState == ViewState.HIDDEN) {
            return;
        }
        if (this.mViewState == ViewState.EXPANDED) {
            throw new MraidCommandException("Not allowed to resize from an already expanded ad");
        }
        if (this.mPlacementType == PlacementType.INTERSTITIAL) {
            throw new MraidCommandException("Not allowed to resize from an interstitial ad");
        }
        int width = Dips.dipsToIntPixels(widthDips, this.mContext);
        int height = Dips.dipsToIntPixels(heightDips, this.mContext);
        int offsetX = Dips.dipsToIntPixels(offsetXDips, this.mContext);
        int offsetY = Dips.dipsToIntPixels(offsetYDips, this.mContext);
        int left = this.mScreenMetrics.getDefaultAdRect().left + offsetX;
        int top = this.mScreenMetrics.getDefaultAdRect().top + offsetY;
        Rect resizeRect = new Rect(left, top, left + width, top + height);
        if (!allowOffscreen) {
            Rect bounds = this.mScreenMetrics.getRootViewRect();
            if (resizeRect.width() > bounds.width() || resizeRect.height() > bounds.height()) {
                throw new MraidCommandException("resizeProperties specified a size (" + widthDips + ", " + heightDips + ") and offset (" + offsetXDips + ", " + offsetYDips + ") that doesn't allow the ad to" + " appear within the max allowed size (" + this.mScreenMetrics.getRootViewRectDips().width() + ", " + this.mScreenMetrics.getRootViewRectDips().height() + ")");
            }
            int newLeft = this.clampInt(bounds.left, resizeRect.left, bounds.right - resizeRect.width());
            int newTop = this.clampInt(bounds.top, resizeRect.top, bounds.bottom - resizeRect.height());
            resizeRect.offsetTo(newLeft, newTop);
        }
        Rect closeRect = new Rect();
        this.mCloseableAdContainer.applyCloseRegionBounds(closePosition, resizeRect, closeRect);
        if (!this.mScreenMetrics.getRootViewRect().contains(closeRect)) {
            throw new MraidCommandException("resizeProperties specified a size (" + widthDips + ", " + heightDips + ") and offset (" + offsetXDips + ", " + offsetYDips + ") that doesn't allow the close" + " region to appear within the max allowed size (" + this.mScreenMetrics.getRootViewRectDips().width() + ", " + this.mScreenMetrics.getRootViewRectDips().height() + ")");
        }
        if (!resizeRect.contains(closeRect)) {
            throw new MraidCommandException("resizeProperties specified a size (" + widthDips + ", " + height + ") and offset (" + offsetXDips + ", " + offsetYDips + ") that don't allow the close region to appear " + "within the resized ad.");
        }
        this.mCloseableAdContainer.setCloseVisible(false);
        this.mCloseableAdContainer.setClosePosition(closePosition);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(resizeRect.width(), resizeRect.height());
        layoutParams.leftMargin = resizeRect.left - this.mScreenMetrics.getRootViewRect().left;
        layoutParams.topMargin = resizeRect.top - this.mScreenMetrics.getRootViewRect().top;
        if (this.mViewState == ViewState.DEFAULT) {
            this.mDefaultAdContainer.removeView((View)this.mMraidWebView);
            this.mDefaultAdContainer.setVisibility(4);
            this.mCloseableAdContainer.addView((View)this.mMraidWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.getRootView().addView((View)this.mCloseableAdContainer, (ViewGroup.LayoutParams)layoutParams);
        } else if (this.mViewState == ViewState.RESIZED) {
            this.mCloseableAdContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.mCloseableAdContainer.setClosePosition(closePosition);
        this.setViewState(ViewState.RESIZED);
    }

    void handleExpand(@Nullable URI uri, boolean shouldUseCustomClose) throws MraidCommandException {
        boolean isTwoPart;
        if (this.mMraidWebView == null) {
            throw new MraidCommandException("Unable to expand after the WebView is destroyed");
        }
        if (this.mPlacementType == PlacementType.INTERSTITIAL) {
            return;
        }
        if (this.mViewState != ViewState.DEFAULT && this.mViewState != ViewState.RESIZED) {
            return;
        }
        this.applyOrientation();
        boolean bl = isTwoPart = uri != null;
        if (isTwoPart) {
            this.mTwoPartWebView = new MraidBridge.MraidWebView(this.mContext);
            this.mTwoPartBridge.attachView(this.mTwoPartWebView);
            this.mTwoPartBridge.setContentUrl(uri.toString());
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        if (this.mViewState == ViewState.DEFAULT) {
            if (isTwoPart) {
                this.mCloseableAdContainer.addView((View)this.mTwoPartWebView, (ViewGroup.LayoutParams)layoutParams);
            } else {
                this.mDefaultAdContainer.removeView((View)this.mMraidWebView);
                this.mDefaultAdContainer.setVisibility(4);
                this.mCloseableAdContainer.addView((View)this.mMraidWebView, (ViewGroup.LayoutParams)layoutParams);
            }
            this.getRootView().addView((View)this.mCloseableAdContainer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        } else if (this.mViewState == ViewState.RESIZED && isTwoPart) {
            this.mCloseableAdContainer.removeView((View)this.mMraidWebView);
            this.mDefaultAdContainer.addView((View)this.mMraidWebView, (ViewGroup.LayoutParams)layoutParams);
            this.mDefaultAdContainer.setVisibility(4);
            this.mCloseableAdContainer.addView((View)this.mTwoPartWebView, (ViewGroup.LayoutParams)layoutParams);
        }
        this.mCloseableAdContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.handleCustomClose(shouldUseCustomClose);
        this.setViewState(ViewState.EXPANDED);
    }

    @VisibleForTesting
    void handleClose() {
        if (this.mMraidWebView == null) {
            return;
        }
        if (this.mViewState == ViewState.LOADING || this.mViewState == ViewState.HIDDEN) {
            return;
        }
        if (this.mViewState == ViewState.EXPANDED || this.mPlacementType == PlacementType.INTERSTITIAL) {
            this.unApplyOrientation();
        }
        if (this.mViewState == ViewState.RESIZED || this.mViewState == ViewState.EXPANDED) {
            if (this.mTwoPartBridge.isAttached() && this.mTwoPartWebView != null) {
                this.mCloseableAdContainer.removeView((View)this.mTwoPartWebView);
                this.mTwoPartBridge.detach();
            } else {
                this.mCloseableAdContainer.removeView((View)this.mMraidWebView);
                this.mDefaultAdContainer.addView((View)this.mMraidWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.mDefaultAdContainer.setVisibility(0);
            }
            this.getRootView().removeView((View)this.mCloseableAdContainer);
            this.setViewState(ViewState.DEFAULT);
        } else if (this.mViewState == ViewState.DEFAULT) {
            this.mDefaultAdContainer.setVisibility(4);
            this.setViewState(ViewState.HIDDEN);
        }
    }

    @NonNull
    @TargetApi(value=19)
    private ViewGroup getRootView() {
        if (this.mRootView == null) {
            if (Build.VERSION.SDK_INT >= 19) {
                Preconditions.checkState(this.mDefaultAdContainer.isAttachedToWindow());
            }
            this.mRootView = (ViewGroup)this.mDefaultAdContainer.getRootView().findViewById(0x1020002);
        }
        return this.mRootView;
    }

    @VisibleForTesting
    void handleShowVideo(@NonNull String videoUrl) {
        MraidVideoPlayerActivity.startMraid(this.mContext, videoUrl);
    }

    @VisibleForTesting
    void lockOrientation(int screenOrientation) throws MraidCommandException {
        Activity activity = (Activity)this.mWeakActivity.get();
        if (activity == null || !this.shouldAllowForceOrientation(this.mForceOrientation)) {
            throw new MraidCommandException("Attempted to lock orientation to unsupported value: " + this.mForceOrientation.name());
        }
        if (this.mOriginalActivityOrientation == null) {
            this.mOriginalActivityOrientation = activity.getRequestedOrientation();
        }
        activity.setRequestedOrientation(screenOrientation);
    }

    @VisibleForTesting
    void applyOrientation() throws MraidCommandException {
        if (this.mForceOrientation == MraidOrientation.NONE) {
            if (this.mAllowOrientationChange) {
                this.unApplyOrientation();
            } else {
                Activity activity = (Activity)this.mWeakActivity.get();
                if (activity == null) {
                    throw new MraidCommandException("Unable to set MRAID expand orientation to 'none'; expected passed in Activity Context.");
                }
                this.lockOrientation(DeviceUtils.getScreenOrientation(activity));
            }
        } else {
            this.lockOrientation(this.mForceOrientation.getActivityInfoOrientation());
        }
    }

    @VisibleForTesting
    void unApplyOrientation() {
        Activity activity = (Activity)this.mWeakActivity.get();
        if (activity != null && this.mOriginalActivityOrientation != null) {
            activity.setRequestedOrientation(this.mOriginalActivityOrientation.intValue());
        }
        this.mOriginalActivityOrientation = null;
    }

    @TargetApi(value=13)
    @VisibleForTesting
    boolean shouldAllowForceOrientation(MraidOrientation newOrientation) {
        ActivityInfo activityInfo;
        if (newOrientation == MraidOrientation.NONE) {
            return true;
        }
        Activity activity = (Activity)this.mWeakActivity.get();
        if (activity == null) {
            return false;
        }
        try {
            activityInfo = activity.getPackageManager().getActivityInfo(new ComponentName((Context)activity, activity.getClass()), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        int activityOrientation = activityInfo.screenOrientation;
        if (activityOrientation != -1) {
            return activityOrientation == newOrientation.getActivityInfoOrientation();
        }
        boolean containsNecessaryConfigChanges = Utils.bitMaskContainsFlag(activityInfo.configChanges, 128);
        if (Build.VERSION.SDK_INT >= 13) {
            containsNecessaryConfigChanges = containsNecessaryConfigChanges && Utils.bitMaskContainsFlag(activityInfo.configChanges, 1024);
        }
        return containsNecessaryConfigChanges;
    }

    @VisibleForTesting
    void handleCustomClose(boolean useCustomClose) {
        boolean wasUsingCustomClose;
        boolean bl = wasUsingCustomClose = !this.mCloseableAdContainer.isCloseVisible();
        if (useCustomClose == wasUsingCustomClose) {
            return;
        }
        this.mCloseableAdContainer.setCloseVisible(!useCustomClose);
        if (this.mOnCloseButtonListener != null) {
            this.mOnCloseButtonListener.useCustomCloseChanged(useCustomClose);
        }
    }

    @NonNull
    public FrameLayout getAdContainer() {
        return this.mDefaultAdContainer;
    }

    public void loadJavascript(@NonNull String javascript) {
        this.mMraidBridge.injectJavaScript(javascript);
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @VisibleForTesting
    void handleSetOrientationProperties(boolean allowOrientationChange, MraidOrientation forceOrientation) throws MraidCommandException {
        if (!this.shouldAllowForceOrientation(forceOrientation)) {
            throw new MraidCommandException("Unable to force orientation to " + (Object)((Object)forceOrientation));
        }
        this.mAllowOrientationChange = allowOrientationChange;
        this.mForceOrientation = forceOrientation;
        if (this.mViewState == ViewState.EXPANDED || this.mPlacementType == PlacementType.INTERSTITIAL) {
            this.applyOrientation();
        }
    }

    @VisibleForTesting
    void handleOpen(@NonNull String url) {
        if (this.mMraidListener != null) {
            this.mMraidListener.onOpen();
        }
        UrlHandler.Builder builder = new UrlHandler.Builder();
        if (this.mAdReport != null) {
            builder.withDspCreativeId(this.mAdReport.getDspCreativeId());
        }
        builder.withSupportedUrlActions(UrlAction.IGNORE_ABOUT_SCHEME, UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK).build().handleUrl(this.mContext, url);
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    ViewState getViewState() {
        return this.mViewState;
    }

    @Deprecated
    @VisibleForTesting
    void setViewStateForTesting(@NonNull ViewState viewState) {
        this.mViewState = viewState;
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    CloseableLayout getExpandedAdContainer() {
        return this.mCloseableAdContainer;
    }

    @Deprecated
    @VisibleForTesting
    void setRootView(FrameLayout rootView) {
        this.mRootView = rootView;
    }

    @Deprecated
    @VisibleForTesting
    void setRootViewSize(int width, int height) {
        this.mScreenMetrics.setRootViewPosition(0, 0, width, height);
    }

    @Deprecated
    @VisibleForTesting
    Integer getOriginalActivityOrientation() {
        return this.mOriginalActivityOrientation;
    }

    @Deprecated
    @VisibleForTesting
    boolean getAllowOrientationChange() {
        return this.mAllowOrientationChange;
    }

    @Deprecated
    @VisibleForTesting
    MraidOrientation getForceOrientation() {
        return this.mForceOrientation;
    }

    @Deprecated
    @VisibleForTesting
    void setOrientationBroadcastReceiver(OrientationBroadcastReceiver receiver) {
        this.mOrientationBroadcastReceiver = receiver;
    }

    @Deprecated
    @VisibleForTesting
    MraidBridge.MraidWebView getMraidWebView() {
        return this.mMraidWebView;
    }

    @Deprecated
    @VisibleForTesting
    MraidBridge.MraidWebView getTwoPartWebView() {
        return this.mTwoPartWebView;
    }

    @VisibleForTesting
    class OrientationBroadcastReceiver
    extends BroadcastReceiver {
        @Nullable
        private Context mContext;
        private int mLastRotation = -1;

        OrientationBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int orientation;
            if (this.mContext == null) {
                return;
            }
            if ("android.intent.action.CONFIGURATION_CHANGED".equals(intent.getAction()) && (orientation = MraidController.this.getDisplayRotation()) != this.mLastRotation) {
                this.mLastRotation = orientation;
                MraidController.this.handleOrientationChange(this.mLastRotation);
            }
        }

        public void register(@NonNull Context context) {
            Preconditions.checkNotNull(context);
            this.mContext = context.getApplicationContext();
            if (this.mContext != null) {
                this.mContext.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"));
            }
        }

        public void unregister() {
            if (this.mContext != null) {
                this.mContext.unregisterReceiver((BroadcastReceiver)this);
                this.mContext = null;
            }
        }
    }

    @VisibleForTesting
    static class ScreenMetricsWaiter {
        @NonNull
        private final Handler mHandler = new Handler();
        @Nullable
        private WaitRequest mLastWaitRequest;

        ScreenMetricsWaiter() {
        }

        WaitRequest waitFor(View ... views) {
            this.mLastWaitRequest = new WaitRequest(this.mHandler, views);
            return this.mLastWaitRequest;
        }

        void cancelLastRequest() {
            if (this.mLastWaitRequest != null) {
                this.mLastWaitRequest.cancel();
                this.mLastWaitRequest = null;
            }
        }

        static class WaitRequest {
            @NonNull
            private final View[] mViews;
            @NonNull
            private final Handler mHandler;
            @Nullable
            private Runnable mSuccessRunnable;
            int mWaitCount;
            private final Runnable mWaitingRunnable = new Runnable(){

                @Override
                public void run() {
                    for (final View view : WaitRequest.this.mViews) {
                        if (view.getHeight() > 0 || view.getWidth() > 0) {
                            WaitRequest.this.countDown();
                            continue;
                        }
                        view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                            public boolean onPreDraw() {
                                view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                                WaitRequest.this.countDown();
                                return true;
                            }
                        });
                    }
                }
            };

            private WaitRequest(@NonNull Handler handler, @NonNull View[] views) {
                this.mHandler = handler;
                this.mViews = views;
            }

            private void countDown() {
                --this.mWaitCount;
                if (this.mWaitCount == 0 && this.mSuccessRunnable != null) {
                    this.mSuccessRunnable.run();
                    this.mSuccessRunnable = null;
                }
            }

            void start(@NonNull Runnable successRunnable) {
                this.mSuccessRunnable = successRunnable;
                this.mWaitCount = this.mViews.length;
                this.mHandler.post(this.mWaitingRunnable);
            }

            void cancel() {
                this.mHandler.removeCallbacks(this.mWaitingRunnable);
                this.mSuccessRunnable = null;
            }
        }
    }

    public static interface UseCustomCloseListener {
        public void useCustomCloseChanged(boolean var1);
    }

    public static interface MraidListener {
        public void onLoaded(View var1);

        public void onFailedToLoad();

        public void onExpand();

        public void onOpen();

        public void onClose();
    }
}

