/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.mopub.common.AdReport;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.CustomEventBanner;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.factories.MraidControllerFactory;
import com.mopub.mraid.MraidController;
import com.mopub.mraid.MraidWebViewDebugListener;
import com.mopub.mraid.PlacementType;
import java.util.Map;

class MraidBanner
extends CustomEventBanner {
    @Nullable
    private MraidController mMraidController;
    @Nullable
    private CustomEventBanner.CustomEventBannerListener mBannerListener;
    @Nullable
    private MraidWebViewDebugListener mDebugListener;

    MraidBanner() {
    }

    @Override
    protected void loadBanner(@NonNull Context context, @NonNull CustomEventBanner.CustomEventBannerListener customEventBannerListener, @NonNull Map<String, Object> localExtras, @NonNull Map<String, String> serverExtras) {
        this.mBannerListener = customEventBannerListener;
        if (!this.extrasAreValid(serverExtras)) {
            this.mBannerListener.onBannerFailed(MoPubErrorCode.MRAID_LOAD_ERROR);
            return;
        }
        String htmlData = serverExtras.get("Html-Response-Body");
        try {
            AdReport adReport = (AdReport)localExtras.get("mopub-intent-ad-report");
            this.mMraidController = MraidControllerFactory.create(context, adReport, PlacementType.INLINE);
        }
        catch (ClassCastException e) {
            MoPubLog.w("MRAID banner creating failed:", e);
            this.mBannerListener.onBannerFailed(MoPubErrorCode.MRAID_LOAD_ERROR);
            return;
        }
        this.mMraidController.setDebugListener(this.mDebugListener);
        this.mMraidController.setMraidListener(new MraidController.MraidListener(){

            @Override
            public void onLoaded(View view) {
                AdViewController.setShouldHonorServerDimensions(view);
                MraidBanner.this.mBannerListener.onBannerLoaded(view);
            }

            @Override
            public void onFailedToLoad() {
                MraidBanner.this.mBannerListener.onBannerFailed(MoPubErrorCode.MRAID_LOAD_ERROR);
            }

            @Override
            public void onExpand() {
                MraidBanner.this.mBannerListener.onBannerExpanded();
                MraidBanner.this.mBannerListener.onBannerClicked();
            }

            @Override
            public void onOpen() {
                MraidBanner.this.mBannerListener.onBannerClicked();
            }

            @Override
            public void onClose() {
                MraidBanner.this.mBannerListener.onBannerCollapsed();
            }
        });
        this.mMraidController.loadContent(htmlData);
    }

    @Override
    protected void onInvalidate() {
        if (this.mMraidController != null) {
            this.mMraidController.setMraidListener(null);
            this.mMraidController.destroy();
        }
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("Html-Response-Body");
    }

    @VisibleForTesting
    public void setDebugListener(@Nullable MraidWebViewDebugListener debugListener) {
        this.mDebugListener = debugListener;
        if (this.mMraidController != null) {
            this.mMraidController.setDebugListener(debugListener);
        }
    }
}

