/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.drawable.GradientDrawable;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.BaseVideoViewController;
import com.mopub.mobileads.VastCompanionAdConfig;
import com.mopub.mobileads.VastErrorCode;
import com.mopub.mobileads.VastIconConfig;
import com.mopub.mobileads.VastVideoCloseButtonWidget;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.mobileads.VastVideoCtaButtonWidget;
import com.mopub.mobileads.VastVideoGradientStripWidget;
import com.mopub.mobileads.VastVideoProgressBarWidget;
import com.mopub.mobileads.VastVideoRadialCountdownWidget;
import com.mopub.mobileads.VastVideoView;
import com.mopub.mobileads.VastVideoViewCountdownRunnable;
import com.mopub.mobileads.VastVideoViewProgressRunnable;
import com.mopub.mobileads.VastWebView;
import com.mopub.network.TrackingRequest;
import java.io.Serializable;
import java.util.Map;

public class VastVideoViewController
extends BaseVideoViewController {
    static final String VAST_VIDEO_CONFIG = "vast_video_config";
    static final String CURRENT_POSITION = "current_position";
    static final String RESUMED_VAST_CONFIG = "resumed_vast_config";
    private static final long VIDEO_PROGRESS_TIMER_CHECKER_DELAY = 50L;
    private static final long VIDEO_COUNTDOWN_UPDATE_INTERVAL = 250L;
    private static final int SEEKER_POSITION_NOT_INITIALIZED = -1;
    public static final int WEBVIEW_PADDING = 16;
    static final int DEFAULT_VIDEO_DURATION_FOR_CLOSE_BUTTON = 5000;
    static final int MAX_VIDEO_DURATION_FOR_CLOSE_BUTTON = 16000;
    private final VastVideoConfig mVastVideoConfig;
    @NonNull
    private final VastVideoView mVideoView;
    @NonNull
    private VastVideoGradientStripWidget mTopGradientStripWidget;
    @NonNull
    private VastVideoGradientStripWidget mBottomGradientStripWidget;
    @NonNull
    private ImageView mBlurredLastVideoFrameImageView;
    @NonNull
    private VastVideoProgressBarWidget mProgressBarWidget;
    @NonNull
    private VastVideoRadialCountdownWidget mRadialCountdownWidget;
    @NonNull
    private VastVideoCtaButtonWidget mCtaButtonWidget;
    @NonNull
    private VastVideoCloseButtonWidget mCloseButtonWidget;
    @Nullable
    private VastCompanionAdConfig mVastCompanionAdConfig;
    @Nullable
    private final VastIconConfig mVastIconConfig;
    @NonNull
    private final View mLandscapeCompanionAdView;
    @NonNull
    private final View mPortraitCompanionAdView;
    @NonNull
    private final Map<String, VastCompanionAdConfig> mSocialActionsCompanionAds;
    @NonNull
    private View mAdsByView;
    @NonNull
    private final View mSocialActionsView;
    @NonNull
    private final View mIconView;
    @NonNull
    private final VastVideoViewProgressRunnable mProgressCheckerRunnable;
    @NonNull
    private final VastVideoViewCountdownRunnable mCountdownRunnable;
    @NonNull
    private final View.OnTouchListener mClickThroughListener;
    private int mShowCloseButtonDelay = 5000;
    private boolean mShowCloseButtonEventFired;
    private int mSeekerPositionOnPause = -1;
    private boolean mIsVideoFinishedPlaying;
    private boolean mVideoError;
    private boolean mHasSkipOffset = false;
    private boolean mIsCalibrationDone = false;
    private boolean mHasSocialActions = false;
    private int mDuration;
    private boolean mIsClosing = false;

    VastVideoViewController(final Activity activity, Bundle intentExtras, @Nullable Bundle savedInstanceState, long broadcastIdentifier, BaseVideoViewController.BaseVideoViewControllerListener baseVideoViewControllerListener) throws IllegalStateException {
        super((Context)activity, broadcastIdentifier, baseVideoViewControllerListener);
        Serializable resumedVastConfiguration = null;
        if (savedInstanceState != null) {
            resumedVastConfiguration = savedInstanceState.getSerializable(RESUMED_VAST_CONFIG);
        }
        Serializable serializable = intentExtras.getSerializable(VAST_VIDEO_CONFIG);
        if (resumedVastConfiguration != null && resumedVastConfiguration instanceof VastVideoConfig) {
            this.mVastVideoConfig = (VastVideoConfig)resumedVastConfiguration;
            this.mSeekerPositionOnPause = savedInstanceState.getInt(CURRENT_POSITION, -1);
        } else if (serializable != null && serializable instanceof VastVideoConfig) {
            this.mVastVideoConfig = (VastVideoConfig)serializable;
        } else {
            throw new IllegalStateException("VastVideoConfig is invalid");
        }
        if (this.mVastVideoConfig.getDiskMediaFileUrl() == null) {
            throw new IllegalStateException("VastVideoConfig does not have a video disk path");
        }
        this.mVastCompanionAdConfig = this.mVastVideoConfig.getVastCompanionAd(activity.getResources().getConfiguration().orientation);
        this.mSocialActionsCompanionAds = this.mVastVideoConfig.getSocialActionsCompanionAds();
        this.mVastIconConfig = this.mVastVideoConfig.getVastIconConfig();
        this.mClickThroughListener = new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 1 && VastVideoViewController.this.shouldAllowClickThrough()) {
                    VastVideoViewController.this.mIsClosing = true;
                    VastVideoViewController.this.broadcastAction("com.mopub.action.interstitial.click");
                    VastVideoViewController.this.mVastVideoConfig.handleClickForResult(activity, VastVideoViewController.this.mIsVideoFinishedPlaying ? VastVideoViewController.this.mDuration : VastVideoViewController.this.getCurrentPosition(), 1);
                }
                return true;
            }
        };
        this.getLayout().setBackgroundColor(-16777216);
        this.addBlurredLastVideoFrameImageView((Context)activity, 4);
        this.mVideoView = this.createVideoView((Context)activity, 0);
        this.mVideoView.requestFocus();
        this.mLandscapeCompanionAdView = this.createCompanionAdView((Context)activity, this.mVastVideoConfig.getVastCompanionAd(2), 4);
        this.mPortraitCompanionAdView = this.createCompanionAdView((Context)activity, this.mVastVideoConfig.getVastCompanionAd(1), 4);
        this.addTopGradientStripWidget((Context)activity);
        this.addProgressBarWidget((Context)activity, 4);
        this.addBottomGradientStripWidget((Context)activity);
        this.addRadialCountdownWidget((Context)activity, 4);
        this.mIconView = this.createIconView((Context)activity, this.mVastIconConfig, 4);
        this.mIconView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                VastVideoViewController.this.mAdsByView = VastVideoViewController.this.createAdsByView(activity);
                VastVideoViewController.this.mIconView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
        this.addCtaButtonWidget((Context)activity);
        int ctaHeight = Dips.dipsToIntPixels(38.0f, (Context)activity);
        this.mSocialActionsView = this.createSocialActionsView((Context)activity, this.mSocialActionsCompanionAds.get("socialActions"), ctaHeight, 6, (View)this.mCtaButtonWidget, 4, 16);
        this.addCloseButtonWidget((Context)activity, 8);
        Handler mainHandler = new Handler(Looper.getMainLooper());
        this.mProgressCheckerRunnable = new VastVideoViewProgressRunnable(this, this.mVastVideoConfig, mainHandler);
        this.mCountdownRunnable = new VastVideoViewCountdownRunnable(this, mainHandler);
    }

    @VisibleForTesting
    View createAdsByView(Activity activity) {
        return this.createSocialActionsView((Context)activity, this.mSocialActionsCompanionAds.get("adsBy"), this.mIconView.getHeight(), 1, this.mIconView, 0, 6);
    }

    @Deprecated
    @VisibleForTesting
    boolean getHasSocialActions() {
        return this.mHasSocialActions;
    }

    @Deprecated
    @VisibleForTesting
    View getSocialActionsView() {
        return this.mSocialActionsView;
    }

    @Override
    protected VideoView getVideoView() {
        return this.mVideoView;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        switch (this.mVastVideoConfig.getCustomForceOrientation()) {
            case FORCE_PORTRAIT: {
                this.getBaseVideoViewControllerListener().onSetRequestedOrientation(1);
                break;
            }
            case FORCE_LANDSCAPE: {
                this.getBaseVideoViewControllerListener().onSetRequestedOrientation(0);
                break;
            }
            case DEVICE_ORIENTATION: {
                break;
            }
            case UNDEFINED: {
                break;
            }
        }
        this.mVastVideoConfig.handleImpression(this.getContext(), this.getCurrentPosition());
        this.broadcastAction("com.mopub.action.interstitial.show");
    }

    @Override
    protected void onResume() {
        this.startRunnables();
        if (this.mSeekerPositionOnPause > 0) {
            this.mVideoView.seekTo(this.mSeekerPositionOnPause);
        }
        if (!this.mIsVideoFinishedPlaying) {
            this.mVideoView.start();
        }
        if (this.mSeekerPositionOnPause != -1) {
            this.mVastVideoConfig.handleResume(this.getContext(), this.mSeekerPositionOnPause);
        }
    }

    @Override
    protected void onPause() {
        this.stopRunnables();
        this.mSeekerPositionOnPause = this.getCurrentPosition();
        this.mVideoView.pause();
        if (!this.mIsVideoFinishedPlaying && !this.mIsClosing) {
            this.mVastVideoConfig.handlePause(this.getContext(), this.mSeekerPositionOnPause);
        }
    }

    @Override
    protected void onDestroy() {
        this.stopRunnables();
        this.broadcastAction("com.mopub.action.interstitial.dismiss");
        this.mVideoView.onDestroy();
    }

    @Override
    protected void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putInt(CURRENT_POSITION, this.mSeekerPositionOnPause);
        outState.putSerializable(RESUMED_VAST_CONFIG, (Serializable)this.mVastVideoConfig);
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        int orientation = this.getContext().getResources().getConfiguration().orientation;
        this.mVastCompanionAdConfig = this.mVastVideoConfig.getVastCompanionAd(orientation);
        if (this.mLandscapeCompanionAdView.getVisibility() == 0 || this.mPortraitCompanionAdView.getVisibility() == 0) {
            if (orientation == 1) {
                this.mLandscapeCompanionAdView.setVisibility(4);
                this.mPortraitCompanionAdView.setVisibility(0);
            } else {
                this.mPortraitCompanionAdView.setVisibility(4);
                this.mLandscapeCompanionAdView.setVisibility(0);
            }
            if (this.mVastCompanionAdConfig != null) {
                this.mVastCompanionAdConfig.handleImpression(this.getContext(), this.mDuration);
            }
        }
    }

    @Override
    protected void onBackPressed() {
    }

    @Override
    public boolean backButtonEnabled() {
        return this.mShowCloseButtonEventFired;
    }

    @Override
    void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1 && resultCode == -1) {
            this.getBaseVideoViewControllerListener().onFinish();
        }
    }

    private void adjustSkipOffset() {
        Integer skipOffsetMillis;
        int videoDuration = this.getDuration();
        if (this.mVastVideoConfig.isRewardedVideo()) {
            this.mShowCloseButtonDelay = videoDuration;
            return;
        }
        if (videoDuration < 16000) {
            this.mShowCloseButtonDelay = videoDuration;
        }
        if ((skipOffsetMillis = this.mVastVideoConfig.getSkipOffsetMillis(videoDuration)) != null) {
            this.mShowCloseButtonDelay = skipOffsetMillis;
            this.mHasSkipOffset = true;
        }
    }

    private VastVideoView createVideoView(final @NonNull Context context, int initialVisibility) {
        if (this.mVastVideoConfig.getDiskMediaFileUrl() == null) {
            throw new IllegalStateException("VastVideoConfig does not have a video disk path");
        }
        final VastVideoView videoView = new VastVideoView(context);
        videoView.setId((int)Utils.generateUniqueId());
        videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                VastVideoViewController.this.mDuration = VastVideoViewController.this.mVideoView.getDuration();
                VastVideoViewController.this.adjustSkipOffset();
                if (VastVideoViewController.this.mVastCompanionAdConfig == null || VastVideoViewController.this.mHasSocialActions) {
                    videoView.prepareBlurredLastVideoFrame(VastVideoViewController.this.mBlurredLastVideoFrameImageView, VastVideoViewController.this.mVastVideoConfig.getDiskMediaFileUrl());
                }
                VastVideoViewController.this.mProgressBarWidget.calibrateAndMakeVisible(VastVideoViewController.this.getDuration(), VastVideoViewController.this.mShowCloseButtonDelay);
                VastVideoViewController.this.mRadialCountdownWidget.calibrateAndMakeVisible(VastVideoViewController.this.mShowCloseButtonDelay);
                VastVideoViewController.this.mIsCalibrationDone = true;
            }
        });
        videoView.setOnTouchListener(this.mClickThroughListener);
        videoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                VastVideoViewController.this.stopRunnables();
                VastVideoViewController.this.makeVideoInteractable();
                VastVideoViewController.this.videoCompleted(false);
                VastVideoViewController.this.mIsVideoFinishedPlaying = true;
                if (VastVideoViewController.this.mVastVideoConfig.isRewardedVideo()) {
                    VastVideoViewController.this.broadcastAction("com.mopub.action.rewardedvideo.complete");
                }
                if (!VastVideoViewController.this.mVideoError && VastVideoViewController.this.mVastVideoConfig.getRemainingProgressTrackerCount() == 0) {
                    VastVideoViewController.this.mVastVideoConfig.handleComplete(VastVideoViewController.this.getContext(), VastVideoViewController.this.getCurrentPosition());
                }
                videoView.setVisibility(4);
                VastVideoViewController.this.mProgressBarWidget.setVisibility(8);
                if (VastVideoViewController.this.mHasSocialActions) {
                    if (VastVideoViewController.this.mBlurredLastVideoFrameImageView.getDrawable() != null) {
                        VastVideoViewController.this.mBlurredLastVideoFrameImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        VastVideoViewController.this.mBlurredLastVideoFrameImageView.setVisibility(0);
                    }
                } else {
                    VastVideoViewController.this.mIconView.setVisibility(8);
                }
                VastVideoViewController.this.mTopGradientStripWidget.notifyVideoComplete();
                VastVideoViewController.this.mBottomGradientStripWidget.notifyVideoComplete();
                VastVideoViewController.this.mCtaButtonWidget.notifyVideoComplete();
                if (VastVideoViewController.this.mVastCompanionAdConfig != null) {
                    int orientation = context.getResources().getConfiguration().orientation;
                    if (orientation == 1) {
                        VastVideoViewController.this.mPortraitCompanionAdView.setVisibility(0);
                    } else {
                        VastVideoViewController.this.mLandscapeCompanionAdView.setVisibility(0);
                    }
                    VastVideoViewController.this.mVastCompanionAdConfig.handleImpression(context, VastVideoViewController.this.mDuration);
                } else if (VastVideoViewController.this.mBlurredLastVideoFrameImageView.getDrawable() != null) {
                    VastVideoViewController.this.mBlurredLastVideoFrameImageView.setVisibility(0);
                }
            }
        });
        videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
                if (videoView.retryMediaPlayer(mediaPlayer, what, extra, VastVideoViewController.this.mVastVideoConfig.getDiskMediaFileUrl())) {
                    return true;
                }
                VastVideoViewController.this.stopRunnables();
                VastVideoViewController.this.makeVideoInteractable();
                VastVideoViewController.this.videoError(false);
                VastVideoViewController.this.mVideoError = true;
                VastVideoViewController.this.mVastVideoConfig.handleError(VastVideoViewController.this.getContext(), VastErrorCode.GENERAL_LINEAR_AD_ERROR, VastVideoViewController.this.getCurrentPosition());
                return false;
            }
        });
        videoView.setVideoPath(this.mVastVideoConfig.getDiskMediaFileUrl());
        videoView.setVisibility(initialVisibility);
        return videoView;
    }

    private void addTopGradientStripWidget(@NonNull Context context) {
        boolean hasCompanionAd = this.mVastCompanionAdConfig != null;
        this.mTopGradientStripWidget = new VastVideoGradientStripWidget(context, GradientDrawable.Orientation.TOP_BOTTOM, this.mVastVideoConfig.getCustomForceOrientation(), hasCompanionAd, 0, 6, this.getLayout().getId());
        this.getLayout().addView((View)this.mTopGradientStripWidget);
    }

    private void addBottomGradientStripWidget(@NonNull Context context) {
        boolean hasCompanionAd = this.mVastCompanionAdConfig != null;
        this.mBottomGradientStripWidget = new VastVideoGradientStripWidget(context, GradientDrawable.Orientation.BOTTOM_TOP, this.mVastVideoConfig.getCustomForceOrientation(), hasCompanionAd, 8, 2, this.mProgressBarWidget.getId());
        this.getLayout().addView((View)this.mBottomGradientStripWidget);
    }

    private void addProgressBarWidget(@NonNull Context context, int initialVisibility) {
        this.mProgressBarWidget = new VastVideoProgressBarWidget(context);
        this.mProgressBarWidget.setAnchorId(this.mVideoView.getId());
        this.mProgressBarWidget.setVisibility(initialVisibility);
        this.getLayout().addView((View)this.mProgressBarWidget);
    }

    private void addRadialCountdownWidget(@NonNull Context context, int initialVisibility) {
        this.mRadialCountdownWidget = new VastVideoRadialCountdownWidget(context);
        this.mRadialCountdownWidget.setVisibility(initialVisibility);
        this.getLayout().addView((View)this.mRadialCountdownWidget);
    }

    private void addCtaButtonWidget(@NonNull Context context) {
        boolean hasCompanionAd = this.mVastCompanionAdConfig != null;
        boolean hasClickthroughUrl = !TextUtils.isEmpty((CharSequence)this.mVastVideoConfig.getClickThroughUrl());
        this.mCtaButtonWidget = new VastVideoCtaButtonWidget(context, this.mVideoView.getId(), hasCompanionAd, hasClickthroughUrl);
        this.getLayout().addView((View)this.mCtaButtonWidget);
        this.mCtaButtonWidget.setOnTouchListener(this.mClickThroughListener);
        String customCtaText = this.mVastVideoConfig.getCustomCtaText();
        if (customCtaText != null) {
            this.mCtaButtonWidget.updateCtaText(customCtaText);
        }
    }

    private void addCloseButtonWidget(@NonNull Context context, int initialVisibility) {
        String customCloseIconUrl;
        this.mCloseButtonWidget = new VastVideoCloseButtonWidget(context);
        this.mCloseButtonWidget.setVisibility(initialVisibility);
        this.getLayout().addView((View)this.mCloseButtonWidget);
        View.OnTouchListener closeOnTouchListener = new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                int currentPosition = VastVideoViewController.this.mIsVideoFinishedPlaying ? VastVideoViewController.this.mDuration : VastVideoViewController.this.getCurrentPosition();
                if (motionEvent.getAction() == 1) {
                    VastVideoViewController.this.mIsClosing = true;
                    VastVideoViewController.this.mVastVideoConfig.handleClose(VastVideoViewController.this.getContext(), currentPosition);
                    VastVideoViewController.this.getBaseVideoViewControllerListener().onFinish();
                }
                return true;
            }
        };
        this.mCloseButtonWidget.setOnTouchListenerToContent(closeOnTouchListener);
        String customSkipText = this.mVastVideoConfig.getCustomSkipText();
        if (customSkipText != null) {
            this.mCloseButtonWidget.updateCloseButtonText(customSkipText);
        }
        if ((customCloseIconUrl = this.mVastVideoConfig.getCustomCloseIconUrl()) != null) {
            this.mCloseButtonWidget.updateCloseButtonIcon(customCloseIconUrl);
        }
    }

    private void addBlurredLastVideoFrameImageView(@NonNull Context context, int initialVisibility) {
        this.mBlurredLastVideoFrameImageView = new ImageView(context);
        this.mBlurredLastVideoFrameImageView.setVisibility(initialVisibility);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.getLayout().addView((View)this.mBlurredLastVideoFrameImageView, (ViewGroup.LayoutParams)layoutParams);
    }

    @NonNull
    @VisibleForTesting
    View createCompanionAdView(@NonNull Context context, @Nullable VastCompanionAdConfig vastCompanionAdConfig, int initialVisibility) {
        Preconditions.checkNotNull(context);
        if (vastCompanionAdConfig == null) {
            View emptyView = new View(context);
            emptyView.setVisibility(4);
            return emptyView;
        }
        RelativeLayout relativeLayout = new RelativeLayout(context);
        relativeLayout.setGravity(17);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.getLayout().addView((View)relativeLayout, (ViewGroup.LayoutParams)layoutParams);
        VastWebView companionView = this.createCompanionVastWebView(context, vastCompanionAdConfig);
        companionView.setVisibility(initialVisibility);
        RelativeLayout.LayoutParams companionAdLayout = new RelativeLayout.LayoutParams(Dips.dipsToIntPixels(vastCompanionAdConfig.getWidth() + 16, context), Dips.dipsToIntPixels(vastCompanionAdConfig.getHeight() + 16, context));
        companionAdLayout.addRule(13, -1);
        relativeLayout.addView((View)companionView, (ViewGroup.LayoutParams)companionAdLayout);
        return companionView;
    }

    @NonNull
    @VisibleForTesting
    View createSocialActionsView(@NonNull Context context, @Nullable VastCompanionAdConfig vastCompanionAdConfig, int anchorHeight, int layoutVerb, @NonNull View anchorView, int initialVisibility, int leftMarginDips) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(anchorView);
        if (vastCompanionAdConfig == null) {
            View emptyView = new View(context);
            emptyView.setVisibility(4);
            return emptyView;
        }
        this.mHasSocialActions = true;
        this.mCtaButtonWidget.setHasSocialActions(this.mHasSocialActions);
        VastWebView companionView = this.createCompanionVastWebView(context, vastCompanionAdConfig);
        int width = Dips.dipsToIntPixels(vastCompanionAdConfig.getWidth(), context);
        int height = Dips.dipsToIntPixels(vastCompanionAdConfig.getHeight(), context);
        int offset = (anchorHeight - height) / 2;
        int leftMargin = Dips.dipsToIntPixels(leftMarginDips, context);
        RelativeLayout.LayoutParams companionAdLayout = new RelativeLayout.LayoutParams(width, height);
        companionAdLayout.addRule(layoutVerb, anchorView.getId());
        companionAdLayout.addRule(6, anchorView.getId());
        companionAdLayout.setMargins(leftMargin, offset, 0, 0);
        RelativeLayout relativeLayout = new RelativeLayout(context);
        relativeLayout.setGravity(16);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        relativeLayout.addView((View)companionView, (ViewGroup.LayoutParams)layoutParams);
        this.getLayout().addView((View)relativeLayout, (ViewGroup.LayoutParams)companionAdLayout);
        companionView.setVisibility(initialVisibility);
        return companionView;
    }

    @NonNull
    @VisibleForTesting
    View createIconView(final @NonNull Context context, final @Nullable VastIconConfig vastIconConfig, int initialVisibility) {
        Preconditions.checkNotNull(context);
        if (vastIconConfig == null) {
            return new View(context);
        }
        VastWebView iconView = VastWebView.createView(context, vastIconConfig.getVastResource());
        iconView.setVastWebViewClickListener(new VastWebView.VastWebViewClickListener(){

            @Override
            public void onVastWebViewClick() {
                TrackingRequest.makeVastTrackingHttpRequest(vastIconConfig.getClickTrackingUris(), null, VastVideoViewController.this.getCurrentPosition(), VastVideoViewController.this.getNetworkMediaFileUrl(), context);
                vastIconConfig.handleClick(VastVideoViewController.this.getContext(), null, VastVideoViewController.this.mVastVideoConfig.getDspCreativeId());
            }
        });
        iconView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                vastIconConfig.handleClick(VastVideoViewController.this.getContext(), url, VastVideoViewController.this.mVastVideoConfig.getDspCreativeId());
                return true;
            }
        });
        iconView.setVisibility(initialVisibility);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(Dips.asIntPixels(vastIconConfig.getWidth(), context), Dips.asIntPixels(vastIconConfig.getHeight(), context));
        int leftMargin = Dips.dipsToIntPixels(12.0f, context);
        int topMargin = Dips.dipsToIntPixels(12.0f, context);
        layoutParams.setMargins(leftMargin, topMargin, 0, 0);
        this.getLayout().addView((View)iconView, (ViewGroup.LayoutParams)layoutParams);
        return iconView;
    }

    int getDuration() {
        return this.mVideoView.getDuration();
    }

    int getCurrentPosition() {
        return this.mVideoView.getCurrentPosition();
    }

    void makeVideoInteractable() {
        this.mShowCloseButtonEventFired = true;
        this.mRadialCountdownWidget.setVisibility(8);
        this.mCloseButtonWidget.setVisibility(0);
        this.mCtaButtonWidget.notifyVideoSkippable();
        this.mSocialActionsView.setVisibility(0);
    }

    boolean shouldBeInteractable() {
        return !this.mShowCloseButtonEventFired && this.getCurrentPosition() >= this.mShowCloseButtonDelay;
    }

    void updateCountdown() {
        if (this.mIsCalibrationDone) {
            this.mRadialCountdownWidget.updateCountdownProgress(this.mShowCloseButtonDelay, this.getCurrentPosition());
        }
    }

    void updateProgressBar() {
        this.mProgressBarWidget.updateProgress(this.getCurrentPosition());
    }

    String getNetworkMediaFileUrl() {
        if (this.mVastVideoConfig == null) {
            return null;
        }
        return this.mVastVideoConfig.getNetworkMediaFileUrl();
    }

    void handleIconDisplay(int currentPosition) {
        if (this.mVastIconConfig == null || currentPosition < this.mVastIconConfig.getOffsetMS()) {
            return;
        }
        this.mIconView.setVisibility(0);
        this.mVastIconConfig.handleImpression(this.getContext(), currentPosition, this.getNetworkMediaFileUrl());
        if (this.mVastIconConfig.getDurationMS() == null) {
            return;
        }
        if (currentPosition >= this.mVastIconConfig.getOffsetMS() + this.mVastIconConfig.getDurationMS()) {
            this.mIconView.setVisibility(8);
        }
    }

    private boolean shouldAllowClickThrough() {
        return this.mShowCloseButtonEventFired;
    }

    private void startRunnables() {
        this.mProgressCheckerRunnable.startRepeating(50L);
        this.mCountdownRunnable.startRepeating(250L);
    }

    private void stopRunnables() {
        this.mProgressCheckerRunnable.stop();
        this.mCountdownRunnable.stop();
    }

    @NonNull
    private VastWebView createCompanionVastWebView(final @NonNull Context context, final @NonNull VastCompanionAdConfig vastCompanionAdConfig) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(vastCompanionAdConfig);
        VastWebView companionView = VastWebView.createView(context, vastCompanionAdConfig.getVastResource());
        companionView.setVastWebViewClickListener(new VastWebView.VastWebViewClickListener(){

            @Override
            public void onVastWebViewClick() {
                VastVideoViewController.this.broadcastAction("com.mopub.action.interstitial.click");
                TrackingRequest.makeVastTrackingHttpRequest(vastCompanionAdConfig.getClickTrackers(), null, VastVideoViewController.this.mDuration, null, context);
                vastCompanionAdConfig.handleClick(context, 1, null, VastVideoViewController.this.mVastVideoConfig.getDspCreativeId());
            }
        });
        companionView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                vastCompanionAdConfig.handleClick(context, 1, url, VastVideoViewController.this.mVastVideoConfig.getDspCreativeId());
                return true;
            }
        });
        return companionView;
    }

    @Deprecated
    @VisibleForTesting
    VastVideoViewProgressRunnable getProgressCheckerRunnable() {
        return this.mProgressCheckerRunnable;
    }

    @Deprecated
    @VisibleForTesting
    VastVideoViewCountdownRunnable getCountdownRunnable() {
        return this.mCountdownRunnable;
    }

    @Deprecated
    @VisibleForTesting
    boolean getHasSkipOffset() {
        return this.mHasSkipOffset;
    }

    @Deprecated
    @VisibleForTesting
    int getShowCloseButtonDelay() {
        return this.mShowCloseButtonDelay;
    }

    @Deprecated
    @VisibleForTesting
    boolean isShowCloseButtonEventFired() {
        return this.mShowCloseButtonEventFired;
    }

    @Deprecated
    @VisibleForTesting
    void setCloseButtonVisible(boolean visible) {
        this.mShowCloseButtonEventFired = visible;
    }

    @Deprecated
    @VisibleForTesting
    boolean isVideoFinishedPlaying() {
        return this.mIsVideoFinishedPlaying;
    }

    @Deprecated
    @VisibleForTesting
    boolean isCalibrationDone() {
        return this.mIsCalibrationDone;
    }

    @Deprecated
    @VisibleForTesting
    View getLandscapeCompanionAdView() {
        return this.mLandscapeCompanionAdView;
    }

    @Deprecated
    @VisibleForTesting
    View getPortraitCompanionAdView() {
        return this.mPortraitCompanionAdView;
    }

    @Deprecated
    @VisibleForTesting
    boolean getVideoError() {
        return this.mVideoError;
    }

    @Deprecated
    @VisibleForTesting
    void setVideoError() {
        this.mVideoError = true;
    }

    @Deprecated
    @VisibleForTesting
    View getIconView() {
        return this.mIconView;
    }

    @Deprecated
    @VisibleForTesting
    VastVideoGradientStripWidget getTopGradientStripWidget() {
        return this.mTopGradientStripWidget;
    }

    @Deprecated
    @VisibleForTesting
    VastVideoGradientStripWidget getBottomGradientStripWidget() {
        return this.mBottomGradientStripWidget;
    }

    @Deprecated
    @VisibleForTesting
    VastVideoProgressBarWidget getProgressBarWidget() {
        return this.mProgressBarWidget;
    }

    @Deprecated
    @VisibleForTesting
    void setProgressBarWidget(@NonNull VastVideoProgressBarWidget progressBarWidget) {
        this.mProgressBarWidget = progressBarWidget;
    }

    @Deprecated
    @VisibleForTesting
    VastVideoRadialCountdownWidget getRadialCountdownWidget() {
        return this.mRadialCountdownWidget;
    }

    @Deprecated
    @VisibleForTesting
    void setRadialCountdownWidget(@NonNull VastVideoRadialCountdownWidget radialCountdownWidget) {
        this.mRadialCountdownWidget = radialCountdownWidget;
    }

    @Deprecated
    @VisibleForTesting
    VastVideoCtaButtonWidget getCtaButtonWidget() {
        return this.mCtaButtonWidget;
    }

    @Deprecated
    @VisibleForTesting
    VastVideoCloseButtonWidget getCloseButtonWidget() {
        return this.mCloseButtonWidget;
    }

    @Deprecated
    @VisibleForTesting
    ImageView getBlurredLastVideoFrameImageView() {
        return this.mBlurredLastVideoFrameImageView;
    }

    @Deprecated
    @VisibleForTesting
    VastVideoView getVastVideoView() {
        return this.mVideoView;
    }

    @Deprecated
    @VisibleForTesting
    void setIsClosing(boolean isClosing) {
        this.mIsClosing = isClosing;
    }
}

