/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.MoPubBrowser;
import com.mopub.common.Preconditions;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlHandler;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.Intents;
import com.mopub.common.util.Strings;
import com.mopub.exceptions.IntentNotResolvableException;
import com.mopub.mobileads.VastAbsoluteProgressTracker;
import com.mopub.mobileads.VastCompanionAdConfig;
import com.mopub.mobileads.VastErrorCode;
import com.mopub.mobileads.VastFractionalProgressTracker;
import com.mopub.mobileads.VastIconConfig;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.VideoViewabilityTracker;
import com.mopub.network.TrackingRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VastVideoConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final ArrayList<VastTracker> mImpressionTrackers;
    @NonNull
    private final ArrayList<VastFractionalProgressTracker> mFractionalTrackers;
    @NonNull
    private final ArrayList<VastAbsoluteProgressTracker> mAbsoluteTrackers;
    @NonNull
    private final ArrayList<VastTracker> mPauseTrackers;
    @NonNull
    private final ArrayList<VastTracker> mResumeTrackers;
    @NonNull
    private final ArrayList<VastTracker> mCompleteTrackers;
    @NonNull
    private final ArrayList<VastTracker> mCloseTrackers;
    @NonNull
    private final ArrayList<VastTracker> mSkipTrackers;
    @NonNull
    private final ArrayList<VastTracker> mClickTrackers;
    @NonNull
    private final ArrayList<VastTracker> mErrorTrackers;
    @Nullable
    private String mClickThroughUrl;
    @Nullable
    private String mNetworkMediaFileUrl;
    @Nullable
    private String mDiskMediaFileUrl;
    @Nullable
    private String mSkipOffset;
    @Nullable
    private VastCompanionAdConfig mLandscapeVastCompanionAdConfig;
    @Nullable
    private VastCompanionAdConfig mPortraitVastCompanionAdConfig;
    @NonNull
    private Map<String, VastCompanionAdConfig> mSocialActionsCompanionAds;
    @Nullable
    private VastIconConfig mVastIconConfig;
    private boolean mIsRewardedVideo = false;
    @Nullable
    private String mCustomCtaText;
    @Nullable
    private String mCustomSkipText;
    @Nullable
    private String mCustomCloseIconUrl;
    @NonNull
    private DeviceUtils.ForceOrientation mCustomForceOrientation = DeviceUtils.ForceOrientation.FORCE_LANDSCAPE;
    @Nullable
    private VideoViewabilityTracker mVideoViewabilityTracker;
    private String mDspCreativeId;
    private boolean mIsForceOrientationSet;

    public VastVideoConfig() {
        this.mImpressionTrackers = new ArrayList();
        this.mFractionalTrackers = new ArrayList();
        this.mAbsoluteTrackers = new ArrayList();
        this.mPauseTrackers = new ArrayList();
        this.mResumeTrackers = new ArrayList();
        this.mCompleteTrackers = new ArrayList();
        this.mCloseTrackers = new ArrayList();
        this.mSkipTrackers = new ArrayList();
        this.mClickTrackers = new ArrayList();
        this.mErrorTrackers = new ArrayList();
        this.mSocialActionsCompanionAds = new HashMap<String, VastCompanionAdConfig>();
    }

    public void setDspCreativeId(@NonNull String dspCreativeId) {
        this.mDspCreativeId = dspCreativeId;
    }

    public String getDspCreativeId() {
        return this.mDspCreativeId;
    }

    public void addImpressionTrackers(@NonNull List<VastTracker> impressionTrackers) {
        Preconditions.checkNotNull(impressionTrackers, "impressionTrackers cannot be null");
        this.mImpressionTrackers.addAll(impressionTrackers);
    }

    public void addFractionalTrackers(@NonNull List<VastFractionalProgressTracker> fractionalTrackers) {
        Preconditions.checkNotNull(fractionalTrackers, "fractionalTrackers cannot be null");
        this.mFractionalTrackers.addAll(fractionalTrackers);
        Collections.sort(this.mFractionalTrackers);
    }

    public void addAbsoluteTrackers(@NonNull List<VastAbsoluteProgressTracker> absoluteTrackers) {
        Preconditions.checkNotNull(absoluteTrackers, "absoluteTrackers cannot be null");
        this.mAbsoluteTrackers.addAll(absoluteTrackers);
        Collections.sort(this.mAbsoluteTrackers);
    }

    public void addCompleteTrackers(@NonNull List<VastTracker> completeTrackers) {
        Preconditions.checkNotNull(completeTrackers, "completeTrackers cannot be null");
        this.mCompleteTrackers.addAll(completeTrackers);
    }

    public void addPauseTrackers(@NonNull List<VastTracker> pauseTrackers) {
        Preconditions.checkNotNull(pauseTrackers, "pauseTrackers cannot be null");
        this.mPauseTrackers.addAll(pauseTrackers);
    }

    public void addResumeTrackers(@NonNull List<VastTracker> resumeTrackers) {
        Preconditions.checkNotNull(resumeTrackers, "resumeTrackers cannot be null");
        this.mResumeTrackers.addAll(resumeTrackers);
    }

    public void addCloseTrackers(@NonNull List<VastTracker> closeTrackers) {
        Preconditions.checkNotNull(closeTrackers, "closeTrackers cannot be null");
        this.mCloseTrackers.addAll(closeTrackers);
    }

    public void addSkipTrackers(@NonNull List<VastTracker> skipTrackers) {
        Preconditions.checkNotNull(skipTrackers, "skipTrackers cannot be null");
        this.mSkipTrackers.addAll(skipTrackers);
    }

    public void addClickTrackers(@NonNull List<VastTracker> clickTrackers) {
        Preconditions.checkNotNull(clickTrackers, "clickTrackers cannot be null");
        this.mClickTrackers.addAll(clickTrackers);
    }

    public void addErrorTrackers(@NonNull List<VastTracker> errorTrackers) {
        Preconditions.checkNotNull(errorTrackers, "errorTrackers cannot be null");
        this.mErrorTrackers.addAll(errorTrackers);
    }

    public void setClickThroughUrl(@Nullable String clickThroughUrl) {
        this.mClickThroughUrl = clickThroughUrl;
    }

    public void setNetworkMediaFileUrl(@Nullable String networkMediaFileUrl) {
        this.mNetworkMediaFileUrl = networkMediaFileUrl;
    }

    public void setDiskMediaFileUrl(@Nullable String diskMediaFileUrl) {
        this.mDiskMediaFileUrl = diskMediaFileUrl;
    }

    public void setVastCompanionAd(@Nullable VastCompanionAdConfig landscapeVastCompanionAdConfig, @Nullable VastCompanionAdConfig portraitVastCompanionAdConfig) {
        this.mLandscapeVastCompanionAdConfig = landscapeVastCompanionAdConfig;
        this.mPortraitVastCompanionAdConfig = portraitVastCompanionAdConfig;
    }

    public void setSocialActionsCompanionAds(@NonNull Map<String, VastCompanionAdConfig> socialActionsCompanionAds) {
        this.mSocialActionsCompanionAds = socialActionsCompanionAds;
    }

    public void setVastIconConfig(@Nullable VastIconConfig vastIconConfig) {
        this.mVastIconConfig = vastIconConfig;
    }

    public void setCustomCtaText(@Nullable String customCtaText) {
        if (customCtaText != null) {
            this.mCustomCtaText = customCtaText;
        }
    }

    public void setCustomSkipText(@Nullable String customSkipText) {
        if (customSkipText != null) {
            this.mCustomSkipText = customSkipText;
        }
    }

    public void setCustomCloseIconUrl(@Nullable String customCloseIconUrl) {
        if (customCloseIconUrl != null) {
            this.mCustomCloseIconUrl = customCloseIconUrl;
        }
    }

    public void setCustomForceOrientation(@Nullable DeviceUtils.ForceOrientation customForceOrientation) {
        if (customForceOrientation != null && customForceOrientation != DeviceUtils.ForceOrientation.UNDEFINED) {
            this.mCustomForceOrientation = customForceOrientation;
            this.mIsForceOrientationSet = true;
        }
    }

    public void setSkipOffset(@Nullable String skipOffset) {
        if (skipOffset != null) {
            this.mSkipOffset = skipOffset;
        }
    }

    public void setVideoViewabilityTracker(@Nullable VideoViewabilityTracker videoViewabilityTracker) {
        if (videoViewabilityTracker != null) {
            this.mVideoViewabilityTracker = videoViewabilityTracker;
        }
    }

    public void setIsRewardedVideo(boolean isRewardedVideo) {
        this.mIsRewardedVideo = isRewardedVideo;
    }

    @NonNull
    public List<VastTracker> getImpressionTrackers() {
        return this.mImpressionTrackers;
    }

    @NonNull
    public ArrayList<VastAbsoluteProgressTracker> getAbsoluteTrackers() {
        return this.mAbsoluteTrackers;
    }

    @NonNull
    public ArrayList<VastFractionalProgressTracker> getFractionalTrackers() {
        return this.mFractionalTrackers;
    }

    @NonNull
    public List<VastTracker> getPauseTrackers() {
        return this.mPauseTrackers;
    }

    @NonNull
    public List<VastTracker> getResumeTrackers() {
        return this.mResumeTrackers;
    }

    @NonNull
    public List<VastTracker> getCompleteTrackers() {
        return this.mCompleteTrackers;
    }

    @NonNull
    public List<VastTracker> getCloseTrackers() {
        return this.mCloseTrackers;
    }

    @NonNull
    public List<VastTracker> getSkipTrackers() {
        return this.mSkipTrackers;
    }

    @NonNull
    public List<VastTracker> getClickTrackers() {
        return this.mClickTrackers;
    }

    @NonNull
    public List<VastTracker> getErrorTrackers() {
        return this.mErrorTrackers;
    }

    @Nullable
    public String getClickThroughUrl() {
        return this.mClickThroughUrl;
    }

    @Nullable
    public String getNetworkMediaFileUrl() {
        return this.mNetworkMediaFileUrl;
    }

    @Nullable
    public String getDiskMediaFileUrl() {
        return this.mDiskMediaFileUrl;
    }

    @Nullable
    public VastCompanionAdConfig getVastCompanionAd(int orientation) {
        switch (orientation) {
            case 1: {
                return this.mPortraitVastCompanionAdConfig;
            }
            case 2: {
                return this.mLandscapeVastCompanionAdConfig;
            }
        }
        return this.mLandscapeVastCompanionAdConfig;
    }

    @NonNull
    public Map<String, VastCompanionAdConfig> getSocialActionsCompanionAds() {
        return this.mSocialActionsCompanionAds;
    }

    @Nullable
    public VastIconConfig getVastIconConfig() {
        return this.mVastIconConfig;
    }

    @Nullable
    public String getCustomCtaText() {
        return this.mCustomCtaText;
    }

    @Nullable
    public String getCustomSkipText() {
        return this.mCustomSkipText;
    }

    @Nullable
    public String getCustomCloseIconUrl() {
        return this.mCustomCloseIconUrl;
    }

    @Nullable
    public VideoViewabilityTracker getVideoViewabilityTracker() {
        return this.mVideoViewabilityTracker;
    }

    public boolean isCustomForceOrientationSet() {
        return this.mIsForceOrientationSet;
    }

    public boolean hasCompanionAd() {
        return this.mLandscapeVastCompanionAdConfig != null && this.mPortraitVastCompanionAdConfig != null;
    }

    @NonNull
    public DeviceUtils.ForceOrientation getCustomForceOrientation() {
        return this.mCustomForceOrientation;
    }

    @Nullable
    public String getSkipOffsetString() {
        return this.mSkipOffset;
    }

    public boolean isRewardedVideo() {
        return this.mIsRewardedVideo;
    }

    public void handleImpression(@NonNull Context context, int contentPlayHead) {
        Preconditions.checkNotNull(context, "context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mImpressionTrackers, null, contentPlayHead, this.mNetworkMediaFileUrl, context);
    }

    public void handleClickForResult(@NonNull Activity activity, int contentPlayHead, int requestCode) {
        this.handleClick((Context)activity, contentPlayHead, requestCode);
    }

    public void handleClickWithoutResult(@NonNull Context context, int contentPlayHead) {
        this.handleClick(context.getApplicationContext(), contentPlayHead, null);
    }

    private void handleClick(final @NonNull Context context, int contentPlayHead, final @Nullable Integer requestCode) {
        Preconditions.checkNotNull(context, "context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mClickTrackers, null, contentPlayHead, this.mNetworkMediaFileUrl, context);
        if (TextUtils.isEmpty((CharSequence)this.mClickThroughUrl)) {
            return;
        }
        new UrlHandler.Builder().withDspCreativeId(this.mDspCreativeId).withSupportedUrlActions(UrlAction.IGNORE_ABOUT_SCHEME, UrlAction.OPEN_APP_MARKET, UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK).withResultActions(new UrlHandler.ResultActions(){

            @Override
            public void urlHandlingSucceeded(@NonNull String url, @NonNull UrlAction urlAction) {
                if (urlAction == UrlAction.OPEN_IN_APP_BROWSER) {
                    Bundle bundle = new Bundle();
                    bundle.putString("URL", url);
                    bundle.putString("mopub-dsp-creative-id", VastVideoConfig.this.mDspCreativeId);
                    Class<MoPubBrowser> clazz = MoPubBrowser.class;
                    Intent intent = Intents.getStartActivityIntent(context, clazz, bundle);
                    try {
                        if (context instanceof Activity) {
                            Preconditions.checkNotNull(requestCode);
                            ((Activity)context).startActivityForResult(intent, requestCode.intValue());
                        } else {
                            Intents.startActivity(context, intent);
                        }
                    }
                    catch (ActivityNotFoundException e) {
                        MoPubLog.d("Activity " + clazz.getName() + " not found. Did you " + "declare it in your AndroidManifest.xml?");
                    }
                    catch (IntentNotResolvableException e) {
                        MoPubLog.d("Activity " + clazz.getName() + " not found. Did you " + "declare it in your AndroidManifest.xml?");
                    }
                }
            }

            @Override
            public void urlHandlingFailed(@NonNull String url, @NonNull UrlAction lastFailedUrlAction) {
            }
        }).withoutMoPubBrowser().build().handleUrl(context, this.mClickThroughUrl);
    }

    public void handleResume(@NonNull Context context, int contentPlayHead) {
        Preconditions.checkNotNull(context, "context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mResumeTrackers, null, contentPlayHead, this.mNetworkMediaFileUrl, context);
    }

    public void handlePause(@NonNull Context context, int contentPlayHead) {
        Preconditions.checkNotNull(context, "context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mPauseTrackers, null, contentPlayHead, this.mNetworkMediaFileUrl, context);
    }

    public void handleClose(@NonNull Context context, int contentPlayHead) {
        Preconditions.checkNotNull(context, "context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mCloseTrackers, null, contentPlayHead, this.mNetworkMediaFileUrl, context);
        TrackingRequest.makeVastTrackingHttpRequest(this.mSkipTrackers, null, contentPlayHead, this.mNetworkMediaFileUrl, context);
    }

    public void handleComplete(@NonNull Context context, int contentPlayHead) {
        Preconditions.checkNotNull(context, "context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mCompleteTrackers, null, contentPlayHead, this.mNetworkMediaFileUrl, context);
    }

    public void handleError(@NonNull Context context, @Nullable VastErrorCode errorCode, int contentPlayHead) {
        Preconditions.checkNotNull(context, "context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mErrorTrackers, errorCode, contentPlayHead, this.mNetworkMediaFileUrl, context);
    }

    @NonNull
    public List<VastTracker> getUntriggeredTrackersBefore(int currentPositionMillis, int videoLengthMillis) {
        if (Preconditions.NoThrow.checkArgument(videoLengthMillis > 0)) {
            VastFractionalProgressTracker tracker;
            VastAbsoluteProgressTracker tracker2;
            float progressFraction = (float)currentPositionMillis / (float)videoLengthMillis;
            ArrayList<VastTracker> untriggeredTrackers = new ArrayList<VastTracker>();
            VastAbsoluteProgressTracker absoluteTest = new VastAbsoluteProgressTracker("", currentPositionMillis);
            int absoluteTrackerCount = this.mAbsoluteTrackers.size();
            for (int i = 0; i < absoluteTrackerCount && (tracker2 = this.mAbsoluteTrackers.get(i)).compareTo(absoluteTest) <= 0; ++i) {
                if (tracker2.isTracked()) continue;
                untriggeredTrackers.add(tracker2);
            }
            VastFractionalProgressTracker fractionalTest = new VastFractionalProgressTracker("", progressFraction);
            int fractionalTrackerCount = this.mFractionalTrackers.size();
            for (int i = 0; i < fractionalTrackerCount && (tracker = this.mFractionalTrackers.get(i)).compareTo(fractionalTest) <= 0; ++i) {
                if (tracker.isTracked()) continue;
                untriggeredTrackers.add(tracker);
            }
            return untriggeredTrackers;
        }
        return Collections.emptyList();
    }

    public int getRemainingProgressTrackerCount() {
        return this.getUntriggeredTrackersBefore(Integer.MAX_VALUE, Integer.MAX_VALUE).size();
    }

    @Nullable
    public Integer getSkipOffsetMillis(int videoDuration) {
        if (this.mSkipOffset != null) {
            try {
                Integer skipOffsetMilliseconds;
                if (Strings.isAbsoluteTracker(this.mSkipOffset)) {
                    skipOffsetMilliseconds = Strings.parseAbsoluteOffset(this.mSkipOffset);
                } else if (Strings.isPercentageTracker(this.mSkipOffset)) {
                    float percentage = Float.parseFloat(this.mSkipOffset.replace("%", "")) / 100.0f;
                    skipOffsetMilliseconds = Math.round((float)videoDuration * percentage);
                } else {
                    MoPubLog.d(String.format("Invalid VAST skipoffset format: %s", this.mSkipOffset));
                    return null;
                }
                if (skipOffsetMilliseconds != null) {
                    if (skipOffsetMilliseconds < videoDuration) {
                        return skipOffsetMilliseconds;
                    }
                    return videoDuration;
                }
            }
            catch (NumberFormatException e) {
                MoPubLog.d(String.format("Failed to parse skipoffset %s", this.mSkipOffset));
            }
        }
        return null;
    }
}

