/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.VastCompanionAdXmlManager;
import com.mopub.mobileads.VastExtensionParentXmlManager;
import com.mopub.mobileads.VastLinearXmlManager;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

abstract class VastBaseInLineWrapperXmlManager {
    private static final String IMPRESSION_TRACKER = "Impression";
    private static final String COMPANION = "Companion";
    private static final String LINEAR = "Linear";
    private static final String CREATIVES = "Creatives";
    private static final String CREATIVE = "Creative";
    private static final String COMPANION_ADS = "CompanionAds";
    private static final String ERROR = "Error";
    private static final String EXTENSIONS = "Extensions";
    @NonNull
    protected final Node mNode;

    VastBaseInLineWrapperXmlManager(@NonNull Node node) {
        Preconditions.checkNotNull(node);
        this.mNode = node;
    }

    @NonNull
    List<VastTracker> getImpressionTrackers() {
        List<Node> impressionNodes = XmlUtils.getMatchingChildNodes(this.mNode, IMPRESSION_TRACKER);
        ArrayList<VastTracker> impressionTrackers = new ArrayList<VastTracker>();
        for (Node impressionNode : impressionNodes) {
            String uri = XmlUtils.getNodeValue(impressionNode);
            if (TextUtils.isEmpty((CharSequence)uri)) continue;
            impressionTrackers.add(new VastTracker(uri));
        }
        return impressionTrackers;
    }

    @NonNull
    List<VastTracker> getErrorTrackers() {
        ArrayList<VastTracker> errorTrackers = new ArrayList<VastTracker>();
        List<Node> errorNodes = XmlUtils.getMatchingChildNodes(this.mNode, ERROR);
        if (errorNodes == null) {
            return errorTrackers;
        }
        for (Node error : errorNodes) {
            String tracker = XmlUtils.getNodeValue(error);
            if (TextUtils.isEmpty((CharSequence)tracker)) continue;
            errorTrackers.add(new VastTracker(tracker, true));
        }
        return errorTrackers;
    }

    @NonNull
    List<VastLinearXmlManager> getLinearXmlManagers() {
        ArrayList<VastLinearXmlManager> linearXmlManagers = new ArrayList<VastLinearXmlManager>();
        Node creativesNode = XmlUtils.getFirstMatchingChildNode(this.mNode, CREATIVES);
        if (creativesNode == null) {
            return linearXmlManagers;
        }
        List<Node> creativeNodes = XmlUtils.getMatchingChildNodes(creativesNode, CREATIVE);
        if (creativeNodes == null) {
            return linearXmlManagers;
        }
        for (Node creativeNode : creativeNodes) {
            Node linearNode = XmlUtils.getFirstMatchingChildNode(creativeNode, LINEAR);
            if (linearNode == null) continue;
            linearXmlManagers.add(new VastLinearXmlManager(linearNode));
        }
        return linearXmlManagers;
    }

    @NonNull
    List<VastCompanionAdXmlManager> getCompanionAdXmlManagers() {
        ArrayList<VastCompanionAdXmlManager> companionAdXmlManagers = new ArrayList<VastCompanionAdXmlManager>();
        Node creativesNode = XmlUtils.getFirstMatchingChildNode(this.mNode, CREATIVES);
        if (creativesNode == null) {
            return companionAdXmlManagers;
        }
        List<Node> creativeNodes = XmlUtils.getMatchingChildNodes(creativesNode, CREATIVE);
        if (creativeNodes == null) {
            return companionAdXmlManagers;
        }
        for (Node creativeNode : creativeNodes) {
            List<Node> companionAdsNodes;
            Node companionAds = XmlUtils.getFirstMatchingChildNode(creativeNode, COMPANION_ADS);
            if (companionAds == null || (companionAdsNodes = XmlUtils.getMatchingChildNodes(companionAds, COMPANION)) == null) continue;
            for (Node companionNode : companionAdsNodes) {
                companionAdXmlManagers.add(new VastCompanionAdXmlManager(companionNode));
            }
        }
        return companionAdXmlManagers;
    }

    @Nullable
    VastExtensionParentXmlManager getVastExtensionParentXmlManager() {
        Node vastExtensionsNode = XmlUtils.getFirstMatchingChildNode(this.mNode, EXTENSIONS);
        if (vastExtensionsNode == null) {
            return null;
        }
        return new VastExtensionParentXmlManager(vastExtensionsNode);
    }
}

