/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.VastTracker;
import java.io.Serializable;
import java.util.Locale;

public class VastAbsoluteProgressTracker
extends VastTracker
implements Comparable<VastAbsoluteProgressTracker>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final int mTrackingMilliseconds;

    public VastAbsoluteProgressTracker(@NonNull String trackingUrl, int trackingMilliseconds) {
        super(trackingUrl);
        Preconditions.checkArgument(trackingMilliseconds >= 0);
        this.mTrackingMilliseconds = trackingMilliseconds;
    }

    public int getTrackingMilliseconds() {
        return this.mTrackingMilliseconds;
    }

    @Override
    public int compareTo(@NonNull VastAbsoluteProgressTracker other) {
        int you = other.getTrackingMilliseconds();
        int me = this.getTrackingMilliseconds();
        return me - you;
    }

    public String toString() {
        return String.format(Locale.US, "%dms: %s", this.mTrackingMilliseconds, this.mTrackingUrl);
    }
}

