/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import com.mopub.common.MoPubReward;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.CustomEventRewardedVideo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class RewardedVideoData {
    @NonNull
    private final Map<String, CustomEventRewardedVideo> mAdUnitToCustomEventMap = new TreeMap<String, CustomEventRewardedVideo>();
    @NonNull
    private final Map<String, MoPubReward> mAdUnitToRewardMap = new TreeMap<String, MoPubReward>();
    @NonNull
    private final Map<String, String> mAdUnitToServerCompletionUrlMap = new TreeMap<String, String>();
    @NonNull
    private final Map<Class<? extends CustomEventRewardedVideo>, MoPubReward> mCustomEventToRewardMap = new HashMap<Class<? extends CustomEventRewardedVideo>, MoPubReward>();
    @NonNull
    private final Map<TwoPartKey, Set<String>> mCustomEventToMoPubIdMap = new HashMap<TwoPartKey, Set<String>>();
    @NonNull
    private final Set<CustomEventRewardedVideo.CustomEventRewardedVideoListener> mAdNetworkListeners = new HashSet<CustomEventRewardedVideo.CustomEventRewardedVideoListener>();
    @Nullable
    private String mCurrentAdUnitId;
    @Nullable
    private String mCustomerId;

    RewardedVideoData() {
    }

    @Nullable
    CustomEventRewardedVideo getCustomEvent(@NonNull String moPubId) {
        return this.mAdUnitToCustomEventMap.get(moPubId);
    }

    @Nullable
    MoPubReward getMoPubReward(@Nullable String moPubId) {
        return this.mAdUnitToRewardMap.get(moPubId);
    }

    @Nullable
    String getServerCompletionUrl(@Nullable String moPubId) {
        if (TextUtils.isEmpty((CharSequence)moPubId)) {
            return null;
        }
        return this.mAdUnitToServerCompletionUrlMap.get(moPubId);
    }

    @Nullable
    MoPubReward getLastShownMoPubReward(@NonNull Class<? extends CustomEventRewardedVideo> customEventClass) {
        return this.mCustomEventToRewardMap.get(customEventClass);
    }

    @NonNull
    Set<String> getMoPubIdsForAdNetwork(@NonNull Class<? extends CustomEventRewardedVideo> customEventClass, @Nullable String adNetworkId) {
        if (adNetworkId == null) {
            HashSet<String> allIds = new HashSet<String>();
            for (Map.Entry<TwoPartKey, Set<String>> entry : this.mCustomEventToMoPubIdMap.entrySet()) {
                Class<? extends CustomEventRewardedVideo> clazz = entry.getKey().customEventClass;
                if (customEventClass != clazz) continue;
                allIds.addAll((Collection<String>)entry.getValue());
            }
            return allIds;
        }
        TwoPartKey key = new TwoPartKey(customEventClass, adNetworkId);
        return this.mCustomEventToMoPubIdMap.containsKey((Object)key) ? this.mCustomEventToMoPubIdMap.get((Object)key) : Collections.emptySet();
    }

    void updateAdUnitCustomEventMapping(@NonNull String moPubId, @NonNull CustomEventRewardedVideo customEvent, @Nullable CustomEventRewardedVideo.CustomEventRewardedVideoListener listener, @NonNull String adNetworkId) {
        this.mAdUnitToCustomEventMap.put(moPubId, customEvent);
        this.mAdNetworkListeners.add(listener);
        this.associateCustomEventWithMoPubId(customEvent.getClass(), adNetworkId, moPubId);
    }

    void updateAdUnitRewardMapping(@NonNull String moPubId, @Nullable String currencyName, @Nullable String currencyAmount) {
        int intCurrencyAmount;
        Preconditions.checkNotNull(moPubId);
        if (currencyName == null || currencyAmount == null) {
            this.mAdUnitToRewardMap.remove(moPubId);
            return;
        }
        try {
            intCurrencyAmount = Integer.parseInt(currencyAmount);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (intCurrencyAmount < 0) {
            return;
        }
        this.mAdUnitToRewardMap.put(moPubId, MoPubReward.success(currencyName, intCurrencyAmount));
    }

    void updateAdUnitToServerCompletionUrlMapping(@NonNull String moPubId, @Nullable String serverCompletionUrl) {
        Preconditions.checkNotNull(moPubId);
        this.mAdUnitToServerCompletionUrlMap.put(moPubId, serverCompletionUrl);
    }

    void updateCustomEventLastShownRewardMapping(@NonNull Class<? extends CustomEventRewardedVideo> customEventClass, @Nullable MoPubReward moPubReward) {
        Preconditions.checkNotNull(customEventClass);
        this.mCustomEventToRewardMap.put(customEventClass, moPubReward);
    }

    void associateCustomEventWithMoPubId(@NonNull Class<? extends CustomEventRewardedVideo> customEventClass, @NonNull String adNetworkId, @NonNull String moPubId) {
        Set<String> moPubIds;
        TwoPartKey newCustomEventMapping = new TwoPartKey(customEventClass, adNetworkId);
        Iterator<Map.Entry<TwoPartKey, Set<String>>> entryIterator = this.mCustomEventToMoPubIdMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<TwoPartKey, Set<String>> entry = entryIterator.next();
            if (entry.getKey().equals((Object)newCustomEventMapping) || !entry.getValue().contains(moPubId)) continue;
            entry.getValue().remove(moPubId);
            if (!entry.getValue().isEmpty()) break;
            entryIterator.remove();
            break;
        }
        if ((moPubIds = this.mCustomEventToMoPubIdMap.get((Object)newCustomEventMapping)) == null) {
            moPubIds = new HashSet<String>();
            this.mCustomEventToMoPubIdMap.put(newCustomEventMapping, moPubIds);
        }
        moPubIds.add(moPubId);
    }

    void setCurrentAdUnitId(@Nullable String currentAdUnitId) {
        this.mCurrentAdUnitId = currentAdUnitId;
    }

    @Nullable
    String getCurrentAdUnitId() {
        return this.mCurrentAdUnitId;
    }

    void setCustomerId(@Nullable String customerId) {
        this.mCustomerId = customerId;
    }

    @Nullable
    String getCustomerId() {
        return this.mCustomerId;
    }

    private static class TwoPartKey
    extends Pair<Class<? extends CustomEventRewardedVideo>, String> {
        @NonNull
        final Class<? extends CustomEventRewardedVideo> customEventClass;
        @NonNull
        final String adNetworkId;

        public TwoPartKey(@NonNull Class<? extends CustomEventRewardedVideo> customEventClass, @NonNull String adNetworkId) {
            super(customEventClass, (Object)adNetworkId);
            this.customEventClass = customEventClass;
            this.adNetworkId = adNetworkId;
        }
    }
}

