/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.RewardedVideoCompletionRequest;
import com.mopub.network.Networking;
import com.mopub.volley.DefaultRetryPolicy;
import com.mopub.volley.Request;
import com.mopub.volley.RequestQueue;
import com.mopub.volley.RetryPolicy;
import com.mopub.volley.VolleyError;

public class RewardedVideoCompletionRequestHandler
implements RewardedVideoCompletionRequest.RewardedVideoCompletionRequestListener {
    static final int[] RETRY_TIMES = new int[]{5000, 10000, 20000, 40000, 60000};
    static final int REQUEST_TIMEOUT_DELAY = 1000;
    static final int MAX_RETRIES = 17;
    private static final String CUSTOMER_ID_KEY = "&customer_id=";
    private static final String SDK_VERSION_KEY = "&nv=";
    private static final String API_VERSION_KEY = "&v=";
    @NonNull
    private final String mUrl;
    @NonNull
    private final Handler mHandler;
    @NonNull
    private final RequestQueue mRequestQueue;
    private int mRetryCount;
    private volatile boolean mShouldStop;

    RewardedVideoCompletionRequestHandler(@NonNull Context context, @NonNull String url, @Nullable String customerId) {
        this(context, url, customerId, new Handler());
    }

    RewardedVideoCompletionRequestHandler(@NonNull Context context, @NonNull String url, @Nullable String customerId, @NonNull Handler handler) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(url);
        this.mUrl = RewardedVideoCompletionRequestHandler.appendParameters(url, customerId);
        this.mRetryCount = 0;
        this.mHandler = handler;
        this.mRequestQueue = Networking.getRequestQueue(context);
    }

    void makeRewardedVideoCompletionRequest() {
        if (this.mShouldStop) {
            this.mRequestQueue.cancelAll((Object)this.mUrl);
            return;
        }
        RewardedVideoCompletionRequest rewardedVideoCompletionRequest = new RewardedVideoCompletionRequest(this.mUrl, (RetryPolicy)new DefaultRetryPolicy(RewardedVideoCompletionRequestHandler.getTimeout(this.mRetryCount) - 1000, 0, 0.0f), this);
        rewardedVideoCompletionRequest.setTag(this.mUrl);
        this.mRequestQueue.add((Request)rewardedVideoCompletionRequest);
        if (this.mRetryCount >= 17) {
            MoPubLog.d("Exceeded number of retries for rewarded video completion request.");
            return;
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                RewardedVideoCompletionRequestHandler.this.makeRewardedVideoCompletionRequest();
            }
        }, (long)RewardedVideoCompletionRequestHandler.getTimeout(this.mRetryCount));
        ++this.mRetryCount;
    }

    @Override
    public void onResponse(Integer response) {
        if (response != null && (response < 500 || response >= 600)) {
            this.mShouldStop = true;
        }
    }

    public void onErrorResponse(VolleyError volleyError) {
        if (volleyError != null && volleyError.networkResponse != null && (volleyError.networkResponse.statusCode < 500 || volleyError.networkResponse.statusCode >= 600)) {
            this.mShouldStop = true;
        }
    }

    public static void makeRewardedVideoCompletionRequest(@Nullable Context context, @Nullable String url, @Nullable String customerId) {
        if (TextUtils.isEmpty((CharSequence)url) || context == null) {
            return;
        }
        new RewardedVideoCompletionRequestHandler(context, url, customerId).makeRewardedVideoCompletionRequest();
    }

    static int getTimeout(int retryCount) {
        if (retryCount >= 0 && retryCount < RETRY_TIMES.length) {
            return RETRY_TIMES[retryCount];
        }
        return RETRY_TIMES[RETRY_TIMES.length - 1];
    }

    private static String appendParameters(@NonNull String url, @Nullable String customerId) {
        Preconditions.checkNotNull(url);
        return url + CUSTOMER_ID_KEY + (customerId == null ? "" : Uri.encode((String)customerId)) + SDK_VERSION_KEY + Uri.encode((String)"4.7.1") + API_VERSION_KEY + 1;
    }

    @Deprecated
    @VisibleForTesting
    boolean getShouldStop() {
        return this.mShouldStop;
    }

    @Deprecated
    @VisibleForTesting
    int getRetryCount() {
        return this.mRetryCount;
    }

    @Deprecated
    @VisibleForTesting
    void setRetryCount(int retryCount) {
        this.mRetryCount = retryCount;
    }
}

