/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.os.Handler;
import android.support.annotation.NonNull;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;

public abstract class RepeatingHandlerRunnable
implements Runnable {
    @NonNull
    protected final Handler mHandler;
    private volatile boolean mIsRunning;
    protected volatile long mUpdateIntervalMillis;

    public RepeatingHandlerRunnable(@NonNull Handler handler) {
        Preconditions.checkNotNull(handler);
        this.mHandler = handler;
    }

    @Override
    public void run() {
        if (this.mIsRunning) {
            this.doWork();
            this.mHandler.postDelayed((Runnable)this, this.mUpdateIntervalMillis);
        }
    }

    public abstract void doWork();

    public void startRepeating(long intervalMillis) {
        Preconditions.checkArgument(intervalMillis > 0L, "intervalMillis must be greater than 0. Saw: %d", intervalMillis);
        this.mUpdateIntervalMillis = intervalMillis;
        if (!this.mIsRunning) {
            this.mIsRunning = true;
            this.mHandler.post((Runnable)this);
        }
    }

    public void stop() {
        this.mIsRunning = false;
    }

    @VisibleForTesting
    boolean shouldBeRunning() {
        return this.mIsRunning;
    }
}

