/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.AdFormat;
import com.mopub.common.AdReport;
import com.mopub.common.ClientMetadata;
import com.mopub.common.MediationSettings;
import com.mopub.common.MoPubReward;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.MoPubCollections;
import com.mopub.common.util.Reflection;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.AdRequestStatusMapping;
import com.mopub.mobileads.CustomEventRewardedVideo;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubRewardedVideoListener;
import com.mopub.mobileads.RewardedVideoCompletionRequestHandler;
import com.mopub.mobileads.RewardedVideoData;
import com.mopub.mobileads.WebViewAdUrlGenerator;
import com.mopub.network.AdRequest;
import com.mopub.network.AdResponse;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.MoPubRequestQueue;
import com.mopub.network.Networking;
import com.mopub.network.TrackingRequest;
import com.mopub.volley.NoConnectionError;
import com.mopub.volley.VolleyError;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MoPubRewardedVideoManager {
    private static MoPubRewardedVideoManager sInstance;
    private static final int DEFAULT_LOAD_TIMEOUT = 30000;
    public static final int API_VERSION = 1;
    @NonNull
    private final Handler mCallbackHandler;
    @NonNull
    private WeakReference<Activity> mMainActivity;
    @NonNull
    private final Context mContext;
    @NonNull
    private final AdRequestStatusMapping mAdRequestStatus;
    @NonNull
    private final RewardedVideoData mRewardedVideoData;
    @Nullable
    private MoPubRewardedVideoListener mVideoListener;
    private final long mBroadcastIdentifier;
    @NonNull
    private final Set<MediationSettings> mGlobalMediationSettings;
    @NonNull
    private final Map<String, Set<MediationSettings>> mInstanceMediationSettings;
    @NonNull
    private final Handler mCustomEventTimeoutHandler;
    @NonNull
    private final Map<String, Runnable> mTimeoutMap;

    private MoPubRewardedVideoManager(@NonNull Activity mainActivity, MediationSettings ... mediationSettings) {
        this.mMainActivity = new WeakReference<Activity>(mainActivity);
        this.mContext = mainActivity.getApplicationContext();
        this.mRewardedVideoData = new RewardedVideoData();
        this.mCallbackHandler = new Handler(Looper.getMainLooper());
        this.mGlobalMediationSettings = new HashSet<MediationSettings>();
        MoPubCollections.addAllNonNull(this.mGlobalMediationSettings, mediationSettings);
        this.mInstanceMediationSettings = new HashMap<String, Set<MediationSettings>>();
        this.mCustomEventTimeoutHandler = new Handler();
        this.mTimeoutMap = new HashMap<String, Runnable>();
        this.mBroadcastIdentifier = Utils.generateUniqueId();
        this.mAdRequestStatus = new AdRequestStatusMapping();
    }

    public static synchronized void init(@NonNull Activity mainActivity, MediationSettings ... mediationSettings) {
        if (sInstance == null) {
            sInstance = new MoPubRewardedVideoManager(mainActivity, mediationSettings);
        } else {
            MoPubLog.e("Tried to call initializeRewardedVideo more than once. Only the first initialization call has any effect.");
        }
    }

    public static void updateActivity(@NonNull Activity activity) {
        if (sInstance != null) {
            MoPubRewardedVideoManager.sInstance.mMainActivity = new WeakReference<Activity>(activity);
        } else {
            MoPubRewardedVideoManager.logErrorNotInitialized();
        }
    }

    @Nullable
    public static <T extends MediationSettings> T getGlobalMediationSettings(@NonNull Class<T> clazz) {
        if (sInstance == null) {
            MoPubRewardedVideoManager.logErrorNotInitialized();
            return null;
        }
        for (MediationSettings mediationSettings : MoPubRewardedVideoManager.sInstance.mGlobalMediationSettings) {
            if (!clazz.equals(mediationSettings.getClass())) continue;
            return (T)((MediationSettings)clazz.cast(mediationSettings));
        }
        return null;
    }

    @Nullable
    public static <T extends MediationSettings> T getInstanceMediationSettings(@NonNull Class<T> clazz, @NonNull String adUnitId) {
        if (sInstance == null) {
            MoPubRewardedVideoManager.logErrorNotInitialized();
            return null;
        }
        Set<MediationSettings> instanceMediationSettings = MoPubRewardedVideoManager.sInstance.mInstanceMediationSettings.get(adUnitId);
        if (instanceMediationSettings == null) {
            return null;
        }
        for (MediationSettings mediationSettings : instanceMediationSettings) {
            if (!clazz.equals(mediationSettings.getClass())) continue;
            return (T)((MediationSettings)clazz.cast(mediationSettings));
        }
        return null;
    }

    public static void setVideoListener(@Nullable MoPubRewardedVideoListener listener) {
        if (sInstance != null) {
            MoPubRewardedVideoManager.sInstance.mVideoListener = listener;
        } else {
            MoPubRewardedVideoManager.logErrorNotInitialized();
        }
    }

    public static void loadVideo(@NonNull String adUnitId, @Nullable RequestParameters requestParameters, MediationSettings ... mediationSettings) {
        String customerId;
        if (sInstance == null) {
            MoPubRewardedVideoManager.logErrorNotInitialized();
            return;
        }
        HashSet newInstanceMediationSettings = new HashSet();
        MoPubCollections.addAllNonNull(newInstanceMediationSettings, mediationSettings);
        MoPubRewardedVideoManager.sInstance.mInstanceMediationSettings.put(adUnitId, newInstanceMediationSettings);
        String string = customerId = requestParameters == null ? null : requestParameters.mCustomerId;
        if (!TextUtils.isEmpty((CharSequence)customerId)) {
            MoPubRewardedVideoManager.sInstance.mRewardedVideoData.setCustomerId(customerId);
        }
        WebViewAdUrlGenerator urlGenerator = new WebViewAdUrlGenerator(MoPubRewardedVideoManager.sInstance.mContext, false);
        String adUrlString = urlGenerator.withAdUnitId(adUnitId).withKeywords(requestParameters == null ? null : requestParameters.mKeywords).withLocation(requestParameters == null ? null : requestParameters.mLocation).generateUrlString("ads.mopub.com");
        MoPubRewardedVideoManager.loadVideo(adUnitId, adUrlString);
    }

    private static void loadVideo(@NonNull String adUnitId, @NonNull String adUrlString) {
        if (sInstance == null) {
            MoPubRewardedVideoManager.logErrorNotInitialized();
            return;
        }
        if (MoPubRewardedVideoManager.sInstance.mAdRequestStatus.isLoading(adUnitId)) {
            MoPubLog.d(String.format(Locale.US, "Did not queue rewarded video request for ad unit %s. A request is already pending.", adUnitId));
            return;
        }
        AdRequest request = new AdRequest(adUrlString, AdFormat.REWARDED_VIDEO, adUnitId, MoPubRewardedVideoManager.sInstance.mContext, new RewardedVideoRequestListener(sInstance, adUnitId));
        MoPubRequestQueue requestQueue = Networking.getRequestQueue(MoPubRewardedVideoManager.sInstance.mContext);
        requestQueue.add(request);
        MoPubRewardedVideoManager.sInstance.mAdRequestStatus.markLoading(adUnitId);
    }

    public static boolean hasVideo(@NonNull String adUnitId) {
        if (sInstance != null) {
            CustomEventRewardedVideo customEvent = MoPubRewardedVideoManager.sInstance.mRewardedVideoData.getCustomEvent(adUnitId);
            return MoPubRewardedVideoManager.isPlayable(adUnitId, customEvent);
        }
        MoPubRewardedVideoManager.logErrorNotInitialized();
        return false;
    }

    public static void showVideo(@NonNull String adUnitId) {
        if (sInstance != null) {
            CustomEventRewardedVideo customEvent = MoPubRewardedVideoManager.sInstance.mRewardedVideoData.getCustomEvent(adUnitId);
            if (MoPubRewardedVideoManager.isPlayable(adUnitId, customEvent)) {
                MoPubRewardedVideoManager.sInstance.mRewardedVideoData.updateCustomEventLastShownRewardMapping(customEvent.getClass(), MoPubRewardedVideoManager.sInstance.mRewardedVideoData.getMoPubReward(adUnitId));
                MoPubRewardedVideoManager.sInstance.mRewardedVideoData.setCurrentAdUnitId(adUnitId);
                MoPubRewardedVideoManager.sInstance.mAdRequestStatus.markPlayed(adUnitId);
                customEvent.showVideo();
            } else {
                sInstance.failover(adUnitId, MoPubErrorCode.VIDEO_NOT_AVAILABLE);
            }
        } else {
            MoPubRewardedVideoManager.logErrorNotInitialized();
        }
    }

    private static boolean isPlayable(String adUnitId, @Nullable CustomEventRewardedVideo customEvent) {
        return sInstance != null && MoPubRewardedVideoManager.sInstance.mAdRequestStatus.canPlay(adUnitId) && customEvent != null && customEvent.hasVideoAvailable();
    }

    private void onAdSuccess(AdResponse adResponse, String adUnitId) {
        String customEventClassName;
        this.mAdRequestStatus.markLoaded(adUnitId, adResponse.getFailoverUrl(), adResponse.getImpressionTrackingUrl(), adResponse.getClickTrackingUrl());
        Integer timeoutMillis = adResponse.getAdTimeoutMillis();
        if (timeoutMillis == null || timeoutMillis <= 0) {
            timeoutMillis = 30000;
        }
        if ((customEventClassName = adResponse.getCustomEventClassName()) == null) {
            MoPubLog.e("Couldn't create custom event, class name was null.");
            this.failover(adUnitId, MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        CustomEventRewardedVideo oldRewardedVideo = this.mRewardedVideoData.getCustomEvent(adUnitId);
        if (oldRewardedVideo != null) {
            oldRewardedVideo.onInvalidate();
        }
        try {
            final CustomEventRewardedVideo customEvent = Reflection.instantiateClassWithEmptyConstructor(customEventClassName, CustomEventRewardedVideo.class);
            TreeMap<String, Object> localExtras = new TreeMap<String, Object>();
            localExtras.put("com_mopub_ad_unit_id", adUnitId);
            localExtras.put("Rewarded-Video-Currency-Name", adResponse.getRewardedVideoCurrencyName());
            localExtras.put("Rewarded-Video-Currency-Value-String", adResponse.getRewardedVideoCurrencyAmount());
            localExtras.put("mopub-intent-ad-report", new AdReport(adUnitId, ClientMetadata.getInstance(this.mContext), adResponse));
            localExtras.put("broadcastIdentifier", this.mBroadcastIdentifier);
            localExtras.put("Rewarded-Video-Customer-Id", this.mRewardedVideoData.getCustomerId());
            this.mRewardedVideoData.updateAdUnitRewardMapping(adUnitId, adResponse.getRewardedVideoCurrencyName(), adResponse.getRewardedVideoCurrencyAmount());
            this.mRewardedVideoData.updateAdUnitToServerCompletionUrlMapping(adUnitId, adResponse.getRewardedVideoCompletionUrl());
            Activity mainActivity = (Activity)this.mMainActivity.get();
            if (mainActivity == null) {
                MoPubLog.d("Could not load custom event because Activity reference was null. Call MoPub#updateActivity before requesting more rewarded videos.");
                this.mAdRequestStatus.markFail(adUnitId);
                return;
            }
            Runnable timeout = new Runnable(){

                @Override
                public void run() {
                    MoPubLog.d("Custom Event failed to load rewarded video in a timely fashion.");
                    MoPubRewardedVideoManager.onRewardedVideoLoadFailure(customEvent.getClass(), customEvent.getAdNetworkId(), MoPubErrorCode.NETWORK_TIMEOUT);
                    customEvent.onInvalidate();
                }
            };
            this.mCustomEventTimeoutHandler.postDelayed(timeout, (long)timeoutMillis.intValue());
            this.mTimeoutMap.put(adUnitId, timeout);
            customEvent.loadCustomEvent(mainActivity, localExtras, adResponse.getServerExtras());
            CustomEventRewardedVideo.CustomEventRewardedVideoListener listener = customEvent.getVideoListenerForSdk();
            String adNetworkId = customEvent.getAdNetworkId();
            this.mRewardedVideoData.updateAdUnitCustomEventMapping(adUnitId, customEvent, listener, adNetworkId);
        }
        catch (Exception e) {
            MoPubLog.e(String.format(Locale.US, "Couldn't create custom event with class name %s", customEventClassName));
            this.failover(adUnitId, MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
        }
    }

    private void onAdError(@NonNull VolleyError volleyError, @NonNull String adUnitId) {
        MoPubErrorCode errorCode = MoPubErrorCode.INTERNAL_ERROR;
        if (volleyError instanceof MoPubNetworkError) {
            MoPubNetworkError err = (MoPubNetworkError)volleyError;
            switch (err.getReason()) {
                case NO_FILL: 
                case WARMING_UP: {
                    errorCode = MoPubErrorCode.NO_FILL;
                    break;
                }
                default: {
                    errorCode = MoPubErrorCode.INTERNAL_ERROR;
                }
            }
        }
        if (volleyError instanceof NoConnectionError) {
            errorCode = MoPubErrorCode.NO_CONNECTION;
        }
        this.failover(adUnitId, errorCode);
    }

    private void failover(@NonNull String adUnitId, @NonNull MoPubErrorCode errorCode) {
        String failoverUrl = this.mAdRequestStatus.getFailoverUrl(adUnitId);
        this.mAdRequestStatus.markFail(adUnitId);
        if (failoverUrl != null) {
            MoPubRewardedVideoManager.loadVideo(adUnitId, failoverUrl);
        } else if (this.mVideoListener != null) {
            this.mVideoListener.onRewardedVideoLoadFailure(adUnitId, errorCode);
        }
    }

    private void cancelTimeouts(@NonNull String moPubId) {
        Runnable runnable = this.mTimeoutMap.remove(moPubId);
        if (runnable != null) {
            this.mCustomEventTimeoutHandler.removeCallbacks(runnable);
        }
    }

    public static <T extends CustomEventRewardedVideo> void onRewardedVideoLoadSuccess(@NonNull Class<T> customEventClass, @NonNull String thirdPartyId) {
        MoPubRewardedVideoManager.postToInstance(new ForEachMoPubIdRunnable(customEventClass, thirdPartyId){

            @Override
            protected void forEach(@NonNull String moPubId) {
                sInstance.cancelTimeouts(moPubId);
                if (sInstance.mVideoListener != null) {
                    sInstance.mVideoListener.onRewardedVideoLoadSuccess(moPubId);
                }
            }
        });
    }

    public static <T extends CustomEventRewardedVideo> void onRewardedVideoLoadFailure(@NonNull Class<T> customEventClass, String thirdPartyId, final MoPubErrorCode errorCode) {
        MoPubRewardedVideoManager.postToInstance(new ForEachMoPubIdRunnable(customEventClass, thirdPartyId){

            @Override
            protected void forEach(@NonNull String moPubId) {
                sInstance.cancelTimeouts(moPubId);
                sInstance.failover(moPubId, errorCode);
            }
        });
    }

    public static <T extends CustomEventRewardedVideo> void onRewardedVideoStarted(@NonNull Class<T> customEventClass, String thirdPartyId) {
        final String currentAdUnitId = MoPubRewardedVideoManager.sInstance.mRewardedVideoData.getCurrentAdUnitId();
        if (TextUtils.isEmpty((CharSequence)currentAdUnitId)) {
            MoPubRewardedVideoManager.postToInstance(new ForEachMoPubIdRunnable(customEventClass, thirdPartyId){

                @Override
                protected void forEach(@NonNull String moPubId) {
                    MoPubRewardedVideoManager.onRewardedVideoStartedAction(moPubId);
                }
            });
        } else {
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoStartedAction(currentAdUnitId);
                }
            });
        }
    }

    private static void onRewardedVideoStartedAction(@NonNull String adUnitId) {
        Preconditions.checkNotNull(adUnitId);
        if (MoPubRewardedVideoManager.sInstance.mVideoListener != null) {
            MoPubRewardedVideoManager.sInstance.mVideoListener.onRewardedVideoStarted(adUnitId);
        }
        TrackingRequest.makeTrackingHttpRequest(MoPubRewardedVideoManager.sInstance.mAdRequestStatus.getImpressionTrackerUrlString(adUnitId), MoPubRewardedVideoManager.sInstance.mContext);
        MoPubRewardedVideoManager.sInstance.mAdRequestStatus.clearImpressionUrl(adUnitId);
    }

    public static <T extends CustomEventRewardedVideo> void onRewardedVideoPlaybackError(@NonNull Class<T> customEventClass, String thirdPartyId, final MoPubErrorCode errorCode) {
        final String currentAdUnitId = MoPubRewardedVideoManager.sInstance.mRewardedVideoData.getCurrentAdUnitId();
        if (TextUtils.isEmpty((CharSequence)currentAdUnitId)) {
            MoPubRewardedVideoManager.postToInstance(new ForEachMoPubIdRunnable(customEventClass, thirdPartyId){

                @Override
                protected void forEach(@NonNull String moPubId) {
                    MoPubRewardedVideoManager.onRewardedVideoPlaybackErrorAction(moPubId, errorCode);
                }
            });
        } else {
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoPlaybackErrorAction(currentAdUnitId, errorCode);
                }
            });
        }
    }

    private static void onRewardedVideoPlaybackErrorAction(@NonNull String adUnitId, @NonNull MoPubErrorCode errorCode) {
        Preconditions.checkNotNull(adUnitId);
        Preconditions.checkNotNull((Object)errorCode);
        if (MoPubRewardedVideoManager.sInstance.mVideoListener != null) {
            MoPubRewardedVideoManager.sInstance.mVideoListener.onRewardedVideoPlaybackError(adUnitId, errorCode);
        }
    }

    public static <T extends CustomEventRewardedVideo> void onRewardedVideoClicked(@NonNull Class<T> customEventClass, String thirdPartyId) {
        final String currentAdUnitId = MoPubRewardedVideoManager.sInstance.mRewardedVideoData.getCurrentAdUnitId();
        if (TextUtils.isEmpty((CharSequence)currentAdUnitId)) {
            MoPubRewardedVideoManager.postToInstance(new ForEachMoPubIdRunnable(customEventClass, thirdPartyId){

                @Override
                protected void forEach(@NonNull String moPubId) {
                    MoPubRewardedVideoManager.onRewardedVideoClickedAction(moPubId);
                }
            });
        } else {
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoClickedAction(currentAdUnitId);
                }
            });
        }
    }

    private static void onRewardedVideoClickedAction(@NonNull String adUnitId) {
        Preconditions.checkNotNull(adUnitId);
        TrackingRequest.makeTrackingHttpRequest(MoPubRewardedVideoManager.sInstance.mAdRequestStatus.getClickTrackerUrlString(adUnitId), MoPubRewardedVideoManager.sInstance.mContext);
        MoPubRewardedVideoManager.sInstance.mAdRequestStatus.clearClickUrl(adUnitId);
    }

    public static <T extends CustomEventRewardedVideo> void onRewardedVideoClosed(@NonNull Class<T> customEventClass, String thirdPartyId) {
        final String currentAdUnitId = MoPubRewardedVideoManager.sInstance.mRewardedVideoData.getCurrentAdUnitId();
        if (TextUtils.isEmpty((CharSequence)currentAdUnitId)) {
            MoPubRewardedVideoManager.postToInstance(new ForEachMoPubIdRunnable(customEventClass, thirdPartyId){

                @Override
                protected void forEach(@NonNull String moPubId) {
                    MoPubRewardedVideoManager.onRewardedVideoClosedAction(moPubId);
                }
            });
        } else {
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoClosedAction(currentAdUnitId);
                }
            });
        }
    }

    private static void onRewardedVideoClosedAction(@NonNull String adUnitId) {
        Preconditions.checkNotNull(adUnitId);
        if (MoPubRewardedVideoManager.sInstance.mVideoListener != null) {
            MoPubRewardedVideoManager.sInstance.mVideoListener.onRewardedVideoClosed(adUnitId);
        }
    }

    public static <T extends CustomEventRewardedVideo> void onRewardedVideoCompleted(final @NonNull Class<T> customEventClass, final String thirdPartyId, final @NonNull MoPubReward moPubReward) {
        String currentAdUnitId = MoPubRewardedVideoManager.sInstance.mRewardedVideoData.getCurrentAdUnitId();
        final String serverCompletionUrl = MoPubRewardedVideoManager.sInstance.mRewardedVideoData.getServerCompletionUrl(currentAdUnitId);
        if (TextUtils.isEmpty((CharSequence)serverCompletionUrl)) {
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    MoPubReward chosenReward = MoPubRewardedVideoManager.chooseReward(sInstance.mRewardedVideoData.getLastShownMoPubReward(customEventClass), moPubReward);
                    Set<String> moPubIds = sInstance.mRewardedVideoData.getMoPubIdsForAdNetwork(customEventClass, thirdPartyId);
                    HashSet<String> rewarded = new HashSet<String>(moPubIds);
                    if (sInstance.mVideoListener != null) {
                        sInstance.mVideoListener.onRewardedVideoCompleted(rewarded, chosenReward);
                    }
                }
            });
        } else {
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    RewardedVideoCompletionRequestHandler.makeRewardedVideoCompletionRequest(sInstance.mContext, serverCompletionUrl, sInstance.mRewardedVideoData.getCustomerId());
                }
            });
        }
    }

    @VisibleForTesting
    static MoPubReward chooseReward(@Nullable MoPubReward moPubReward, @NonNull MoPubReward networkReward) {
        if (!networkReward.isSuccessful()) {
            return networkReward;
        }
        return moPubReward != null ? moPubReward : networkReward;
    }

    private static void postToInstance(@NonNull Runnable runnable) {
        if (sInstance != null) {
            MoPubRewardedVideoManager.sInstance.mCallbackHandler.post(runnable);
        }
    }

    private static void logErrorNotInitialized() {
        MoPubLog.e("MoPub rewarded video was not initialized. You must call MoPub.initializeRewardedVideo() before loading or attempting to play video ads.");
    }

    @Deprecated
    @VisibleForTesting
    @Nullable
    static RewardedVideoData getRewardedVideoData() {
        if (sInstance != null) {
            return MoPubRewardedVideoManager.sInstance.mRewardedVideoData;
        }
        return null;
    }

    private static abstract class ForEachMoPubIdRunnable
    implements Runnable {
        @NonNull
        private final Class<? extends CustomEventRewardedVideo> mCustomEventClass;
        @NonNull
        private final String mThirdPartyId;

        ForEachMoPubIdRunnable(@NonNull Class<? extends CustomEventRewardedVideo> customEventClass, @NonNull String thirdPartyId) {
            Preconditions.checkNotNull(customEventClass);
            Preconditions.checkNotNull(thirdPartyId);
            this.mCustomEventClass = customEventClass;
            this.mThirdPartyId = thirdPartyId;
        }

        protected abstract void forEach(@NonNull String var1);

        @Override
        public void run() {
            Set<String> moPubIds = sInstance.mRewardedVideoData.getMoPubIdsForAdNetwork(this.mCustomEventClass, this.mThirdPartyId);
            for (String moPubId : moPubIds) {
                this.forEach(moPubId);
            }
        }
    }

    public static final class RequestParameters {
        @Nullable
        public final String mKeywords;
        @Nullable
        public final Location mLocation;
        @Nullable
        public final String mCustomerId;

        public RequestParameters(@Nullable String keywords) {
            this(keywords, null);
        }

        public RequestParameters(@Nullable String keywords, @Nullable Location location) {
            this(keywords, location, null);
        }

        public RequestParameters(@Nullable String keywords, @Nullable Location location, @Nullable String customerId) {
            this.mKeywords = keywords;
            this.mLocation = location;
            this.mCustomerId = customerId;
        }
    }

    public static class RewardedVideoRequestListener
    implements AdRequest.Listener {
        public final String adUnitId;
        private final MoPubRewardedVideoManager mVideoManager;

        public RewardedVideoRequestListener(MoPubRewardedVideoManager videoManager, String adUnitId) {
            this.adUnitId = adUnitId;
            this.mVideoManager = videoManager;
        }

        @Override
        public void onSuccess(AdResponse response) {
            this.mVideoManager.onAdSuccess(response, this.adUnitId);
        }

        public void onErrorResponse(VolleyError volleyError) {
            this.mVideoManager.onAdError(volleyError, this.adUnitId);
        }
    }
}

