/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.LifecycleListener;
import com.mopub.common.MoPubReward;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.CustomEventRewardedVideo;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubRewardedVideoManager;
import com.mopub.mobileads.RewardedVastVideoInterstitial;
import java.util.Map;

public class MoPubRewardedVideo
extends CustomEventRewardedVideo {
    @NonNull
    private static final String MOPUB_REWARDED_VIDEO_ID = "mopub_rewarded_video_id";
    @NonNull
    private RewardedVastVideoInterstitial mRewardedVastVideoInterstitial = new RewardedVastVideoInterstitial();
    @Nullable
    private String mRewardedVideoCurrencyName;
    private int mRewardedVideoCurrencyAmount;
    private boolean mIsLoaded;

    @Override
    @Nullable
    protected CustomEventRewardedVideo.CustomEventRewardedVideoListener getVideoListenerForSdk() {
        return null;
    }

    @Override
    @Nullable
    protected LifecycleListener getLifecycleListener() {
        return null;
    }

    @Override
    @NonNull
    protected String getAdNetworkId() {
        return MOPUB_REWARDED_VIDEO_ID;
    }

    @Override
    protected void onInvalidate() {
        this.mRewardedVastVideoInterstitial.onInvalidate();
        this.mIsLoaded = false;
    }

    @Override
    protected boolean checkAndInitializeSdk(@NonNull Activity launcherActivity, @NonNull Map<String, Object> localExtras, @NonNull Map<String, String> serverExtras) throws Exception {
        return false;
    }

    @Override
    protected void loadWithSdkInitialized(@NonNull Activity activity, @NonNull Map<String, Object> localExtras, @NonNull Map<String, String> serverExtras) throws Exception {
        Preconditions.checkNotNull(activity, "activity cannot be null");
        Preconditions.checkNotNull(localExtras, "localExtras cannot be null");
        Preconditions.checkNotNull(serverExtras, "serverExtras cannot be null");
        Object rewardedVideoCurrencyName = localExtras.get("Rewarded-Video-Currency-Name");
        if (rewardedVideoCurrencyName instanceof String) {
            this.mRewardedVideoCurrencyName = (String)rewardedVideoCurrencyName;
        } else {
            MoPubLog.d("No currency name specified for rewarded video. Using the default name.");
            this.mRewardedVideoCurrencyName = "";
        }
        Object rewardedVideoCurrencyAmount = localExtras.get("Rewarded-Video-Currency-Value-String");
        if (rewardedVideoCurrencyAmount instanceof String) {
            try {
                this.mRewardedVideoCurrencyAmount = Integer.parseInt((String)rewardedVideoCurrencyAmount);
            }
            catch (NumberFormatException e) {
                MoPubLog.d("Unable to convert currency amount: " + rewardedVideoCurrencyAmount + ". Using the default reward amount: " + 0);
                this.mRewardedVideoCurrencyAmount = 0;
            }
        } else {
            MoPubLog.d("No currency amount specified for rewarded video. Using the default reward amount: 0");
            this.mRewardedVideoCurrencyAmount = 0;
        }
        if (this.mRewardedVideoCurrencyAmount < 0) {
            MoPubLog.d("Negative currency amount specified for rewarded video. Using the default reward amount: 0");
            this.mRewardedVideoCurrencyAmount = 0;
        }
        this.mRewardedVastVideoInterstitial.loadInterstitial((Context)activity, new MoPubRewardedVideoListener(), localExtras, serverExtras);
    }

    @Override
    protected boolean hasVideoAvailable() {
        return this.mIsLoaded;
    }

    @Override
    protected void showVideo() {
        if (this.hasVideoAvailable()) {
            MoPubLog.d("Showing MoPub rewarded video.");
            this.mRewardedVastVideoInterstitial.showInterstitial();
        } else {
            MoPubLog.d("Unable to show MoPub rewarded video");
        }
    }

    @Deprecated
    @VisibleForTesting
    void setRewardedVastVideoInterstitial(@NonNull RewardedVastVideoInterstitial rewardedVastVideoInterstitial) {
        this.mRewardedVastVideoInterstitial = rewardedVastVideoInterstitial;
    }

    @Deprecated
    @VisibleForTesting
    @Nullable
    String getRewardedVideoCurrencyName() {
        return this.mRewardedVideoCurrencyName;
    }

    @Deprecated
    @VisibleForTesting
    int getRewardedVideoCurrencyAmount() {
        return this.mRewardedVideoCurrencyAmount;
    }

    @Deprecated
    @VisibleForTesting
    void setIsLoaded(boolean isLoaded) {
        this.mIsLoaded = isLoaded;
    }

    private class MoPubRewardedVideoListener
    implements CustomEventInterstitial.CustomEventInterstitialListener,
    RewardedVastVideoInterstitial.CustomEventRewardedVideoInterstitialListener {
        private MoPubRewardedVideoListener() {
        }

        @Override
        public void onInterstitialLoaded() {
            MoPubRewardedVideo.this.mIsLoaded = true;
            MoPubRewardedVideoManager.onRewardedVideoLoadSuccess(MoPubRewardedVideo.class, MoPubRewardedVideo.MOPUB_REWARDED_VIDEO_ID);
        }

        @Override
        public void onInterstitialFailed(MoPubErrorCode errorCode) {
            switch (errorCode) {
                case VIDEO_PLAYBACK_ERROR: {
                    MoPubRewardedVideoManager.onRewardedVideoPlaybackError(MoPubRewardedVideo.class, MoPubRewardedVideo.MOPUB_REWARDED_VIDEO_ID, errorCode);
                    break;
                }
                default: {
                    MoPubRewardedVideoManager.onRewardedVideoLoadFailure(MoPubRewardedVideo.class, MoPubRewardedVideo.MOPUB_REWARDED_VIDEO_ID, errorCode);
                }
            }
        }

        @Override
        public void onInterstitialShown() {
            MoPubRewardedVideoManager.onRewardedVideoStarted(MoPubRewardedVideo.class, MoPubRewardedVideo.MOPUB_REWARDED_VIDEO_ID);
        }

        @Override
        public void onInterstitialClicked() {
            MoPubRewardedVideoManager.onRewardedVideoClicked(MoPubRewardedVideo.class, MoPubRewardedVideo.MOPUB_REWARDED_VIDEO_ID);
        }

        @Override
        public void onLeaveApplication() {
        }

        @Override
        public void onInterstitialDismissed() {
            MoPubRewardedVideoManager.onRewardedVideoClosed(MoPubRewardedVideo.class, MoPubRewardedVideo.MOPUB_REWARDED_VIDEO_ID);
        }

        @Override
        public void onVideoComplete() {
            if (MoPubRewardedVideo.this.mRewardedVideoCurrencyName == null) {
                MoPubLog.d("No rewarded video was loaded, so no reward is possible");
            } else {
                MoPubRewardedVideoManager.onRewardedVideoCompleted(MoPubRewardedVideo.class, MoPubRewardedVideo.MOPUB_REWARDED_VIDEO_ID, MoPubReward.success(MoPubRewardedVideo.this.mRewardedVideoCurrencyName, MoPubRewardedVideo.this.mRewardedVideoCurrencyAmount));
            }
        }
    }
}

