/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.text.TextUtils;
import com.mopub.common.AdFormat;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.CustomEventInterstitialAdapter;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubView;
import com.mopub.mobileads.factories.CustomEventInterstitialAdapterFactory;
import java.util.Map;

public class MoPubInterstitial
implements CustomEventInterstitialAdapter.CustomEventInterstitialAdapterListener {
    private MoPubInterstitialView mInterstitialView;
    private CustomEventInterstitialAdapter mCustomEventInterstitialAdapter;
    private InterstitialAdListener mInterstitialAdListener;
    private Activity mActivity;
    private String mAdUnitId;
    private InterstitialState mCurrentInterstitialState;
    private boolean mIsDestroyed;

    public MoPubInterstitial(Activity activity, String id) {
        this.mActivity = activity;
        this.mAdUnitId = id;
        this.mInterstitialView = new MoPubInterstitialView((Context)this.mActivity);
        this.mInterstitialView.setAdUnitId(this.mAdUnitId);
        this.mCurrentInterstitialState = InterstitialState.NOT_READY;
    }

    public void load() {
        this.resetCurrentInterstitial();
        this.mInterstitialView.loadAd();
    }

    public void forceRefresh() {
        this.resetCurrentInterstitial();
        this.mInterstitialView.forceRefresh();
    }

    private void resetCurrentInterstitial() {
        this.mCurrentInterstitialState = InterstitialState.NOT_READY;
        if (this.mCustomEventInterstitialAdapter != null) {
            this.mCustomEventInterstitialAdapter.invalidate();
            this.mCustomEventInterstitialAdapter = null;
        }
        this.mIsDestroyed = false;
    }

    public boolean isReady() {
        return this.mCurrentInterstitialState.isReady();
    }

    boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    public boolean show() {
        switch (this.mCurrentInterstitialState) {
            case CUSTOM_EVENT_AD_READY: {
                this.showCustomEventInterstitial();
                return true;
            }
        }
        return false;
    }

    private void showCustomEventInterstitial() {
        if (this.mCustomEventInterstitialAdapter != null) {
            this.mCustomEventInterstitialAdapter.showInterstitial();
        }
    }

    Integer getAdTimeoutDelay() {
        return this.mInterstitialView.getAdTimeoutDelay();
    }

    MoPubInterstitialView getMoPubInterstitialView() {
        return this.mInterstitialView;
    }

    public void setKeywords(String keywords) {
        this.mInterstitialView.setKeywords(keywords);
    }

    public String getKeywords() {
        return this.mInterstitialView.getKeywords();
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public Location getLocation() {
        return this.mInterstitialView.getLocation();
    }

    public void destroy() {
        this.mIsDestroyed = true;
        if (this.mCustomEventInterstitialAdapter != null) {
            this.mCustomEventInterstitialAdapter.invalidate();
            this.mCustomEventInterstitialAdapter = null;
        }
        this.mInterstitialView.setBannerAdListener(null);
        this.mInterstitialView.destroy();
    }

    public void setInterstitialAdListener(InterstitialAdListener listener) {
        this.mInterstitialAdListener = listener;
    }

    public InterstitialAdListener getInterstitialAdListener() {
        return this.mInterstitialAdListener;
    }

    public void setTesting(boolean testing) {
        this.mInterstitialView.setTesting(testing);
    }

    public boolean getTesting() {
        return this.mInterstitialView.getTesting();
    }

    public void setLocalExtras(Map<String, Object> extras) {
        this.mInterstitialView.setLocalExtras(extras);
    }

    public Map<String, Object> getLocalExtras() {
        return this.mInterstitialView.getLocalExtras();
    }

    @Override
    public void onCustomEventInterstitialLoaded() {
        if (this.mIsDestroyed) {
            return;
        }
        this.mCurrentInterstitialState = InterstitialState.CUSTOM_EVENT_AD_READY;
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialLoaded(this);
        }
    }

    @Override
    public void onCustomEventInterstitialFailed(MoPubErrorCode errorCode) {
        if (this.isDestroyed()) {
            return;
        }
        this.mCurrentInterstitialState = InterstitialState.NOT_READY;
        this.mInterstitialView.loadFailUrl(errorCode);
    }

    @Override
    public void onCustomEventInterstitialShown() {
        if (this.isDestroyed()) {
            return;
        }
        this.mInterstitialView.trackImpression();
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialShown(this);
        }
    }

    @Override
    public void onCustomEventInterstitialClicked() {
        if (this.isDestroyed()) {
            return;
        }
        this.mInterstitialView.registerClick();
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialClicked(this);
        }
    }

    @Override
    public void onCustomEventInterstitialDismissed() {
        if (this.isDestroyed()) {
            return;
        }
        this.mCurrentInterstitialState = InterstitialState.NOT_READY;
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialDismissed(this);
        }
    }

    @Deprecated
    @VisibleForTesting
    void setInterstitialView(MoPubInterstitialView interstitialView) {
        this.mInterstitialView = interstitialView;
    }

    public class MoPubInterstitialView
    extends MoPubView {
        public MoPubInterstitialView(Context context) {
            super(context);
            this.setAutorefreshEnabled(false);
        }

        @Override
        public AdFormat getAdFormat() {
            return AdFormat.INTERSTITIAL;
        }

        @Override
        protected void loadCustomEvent(String customEventClassName, Map<String, String> serverExtras) {
            if (this.mAdViewController == null) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)customEventClassName)) {
                MoPubLog.d("Couldn't invoke custom event because the server did not specify one.");
                this.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
                return;
            }
            if (MoPubInterstitial.this.mCustomEventInterstitialAdapter != null) {
                MoPubInterstitial.this.mCustomEventInterstitialAdapter.invalidate();
            }
            MoPubLog.d("Loading custom event interstitial adapter.");
            MoPubInterstitial.this.mCustomEventInterstitialAdapter = CustomEventInterstitialAdapterFactory.create(MoPubInterstitial.this, customEventClassName, serverExtras, this.mAdViewController.getBroadcastIdentifier(), this.mAdViewController.getAdReport());
            MoPubInterstitial.this.mCustomEventInterstitialAdapter.setAdapterListener(MoPubInterstitial.this);
            MoPubInterstitial.this.mCustomEventInterstitialAdapter.loadInterstitial();
        }

        protected void trackImpression() {
            MoPubLog.d("Tracking impression for interstitial.");
            if (this.mAdViewController != null) {
                this.mAdViewController.trackImpression();
            }
        }

        @Override
        protected void adFailed(MoPubErrorCode errorCode) {
            if (MoPubInterstitial.this.mInterstitialAdListener != null) {
                MoPubInterstitial.this.mInterstitialAdListener.onInterstitialFailed(MoPubInterstitial.this, errorCode);
            }
        }
    }

    public static interface InterstitialAdListener {
        public void onInterstitialLoaded(MoPubInterstitial var1);

        public void onInterstitialFailed(MoPubInterstitial var1, MoPubErrorCode var2);

        public void onInterstitialShown(MoPubInterstitial var1);

        public void onInterstitialClicked(MoPubInterstitial var1);

        public void onInterstitialDismissed(MoPubInterstitial var1);
    }

    private static enum InterstitialState {
        CUSTOM_EVENT_AD_READY,
        NOT_READY;


        boolean isReady() {
            return this != NOT_READY;
        }
    }
}

