/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.view.View;
import com.mopub.common.AdReport;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.CustomEventBanner;
import com.mopub.mobileads.HtmlBannerWebView;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.factories.HtmlBannerWebViewFactory;
import java.util.Map;

public class HtmlBanner
extends CustomEventBanner {
    private HtmlBannerWebView mHtmlBannerWebView;

    @Override
    protected void loadBanner(Context context, CustomEventBanner.CustomEventBannerListener customEventBannerListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        AdReport adReport;
        Boolean isScrollable;
        String clickthroughUrl;
        String redirectUrl;
        String htmlData;
        if (this.extrasAreValid(serverExtras)) {
            htmlData = serverExtras.get("Html-Response-Body");
            redirectUrl = serverExtras.get("Redirect-Url");
            clickthroughUrl = serverExtras.get("Clickthrough-Url");
            isScrollable = Boolean.valueOf(serverExtras.get("Scrollable"));
            try {
                adReport = (AdReport)localExtras.get("mopub-intent-ad-report");
            }
            catch (ClassCastException e) {
                MoPubLog.e("LocalExtras contained an incorrect type.");
                customEventBannerListener.onBannerFailed(MoPubErrorCode.INTERNAL_ERROR);
                return;
            }
        } else {
            customEventBannerListener.onBannerFailed(MoPubErrorCode.NETWORK_INVALID_STATE);
            return;
        }
        this.mHtmlBannerWebView = HtmlBannerWebViewFactory.create(context, adReport, customEventBannerListener, isScrollable, redirectUrl, clickthroughUrl);
        AdViewController.setShouldHonorServerDimensions((View)this.mHtmlBannerWebView);
        this.mHtmlBannerWebView.loadHtmlResponse(htmlData);
    }

    @Override
    protected void onInvalidate() {
        if (this.mHtmlBannerWebView != null) {
            this.mHtmlBannerWebView.destroy();
        }
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("Html-Response-Body");
    }
}

