/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.AdReport;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubInterstitial;
import com.mopub.mobileads.factories.CustomEventInterstitialFactory;
import java.util.Map;
import java.util.TreeMap;

public class CustomEventInterstitialAdapter
implements CustomEventInterstitial.CustomEventInterstitialListener {
    public static final int DEFAULT_INTERSTITIAL_TIMEOUT_DELAY = 30000;
    private final MoPubInterstitial mMoPubInterstitial;
    private boolean mInvalidated;
    private CustomEventInterstitialAdapterListener mCustomEventInterstitialAdapterListener;
    private CustomEventInterstitial mCustomEventInterstitial;
    private Context mContext;
    private Map<String, Object> mLocalExtras;
    private Map<String, String> mServerExtras;
    private final Handler mHandler;
    private final Runnable mTimeout;

    public CustomEventInterstitialAdapter(@NonNull MoPubInterstitial moPubInterstitial, @NonNull String className, @NonNull Map<String, String> serverExtras, long broadcastIdentifier, @Nullable AdReport adReport) {
        Preconditions.checkNotNull(serverExtras);
        this.mHandler = new Handler();
        this.mMoPubInterstitial = moPubInterstitial;
        this.mContext = this.mMoPubInterstitial.getActivity();
        this.mTimeout = new Runnable(){

            @Override
            public void run() {
                MoPubLog.d("Third-party network timed out.");
                CustomEventInterstitialAdapter.this.onInterstitialFailed(MoPubErrorCode.NETWORK_TIMEOUT);
                CustomEventInterstitialAdapter.this.invalidate();
            }
        };
        MoPubLog.d("Attempting to invoke custom event: " + className);
        try {
            this.mCustomEventInterstitial = CustomEventInterstitialFactory.create(className);
        }
        catch (Exception exception) {
            MoPubLog.d("Couldn't locate or instantiate custom event: " + className + ".");
            this.mMoPubInterstitial.onCustomEventInterstitialFailed(MoPubErrorCode.ADAPTER_NOT_FOUND);
            return;
        }
        this.mServerExtras = new TreeMap<String, String>(serverExtras);
        this.mLocalExtras = this.mMoPubInterstitial.getLocalExtras();
        if (this.mMoPubInterstitial.getLocation() != null) {
            this.mLocalExtras.put("location", this.mMoPubInterstitial.getLocation());
        }
        this.mLocalExtras.put("broadcastIdentifier", broadcastIdentifier);
        this.mLocalExtras.put("mopub-intent-ad-report", adReport);
    }

    void loadInterstitial() {
        if (this.isInvalidated() || this.mCustomEventInterstitial == null) {
            return;
        }
        this.mHandler.postDelayed(this.mTimeout, (long)this.getTimeoutDelayMilliseconds());
        try {
            this.mCustomEventInterstitial.loadInterstitial(this.mContext, this, this.mLocalExtras, this.mServerExtras);
        }
        catch (Exception e) {
            MoPubLog.d("Loading a custom event interstitial threw an exception.", e);
            this.onInterstitialFailed(MoPubErrorCode.INTERNAL_ERROR);
        }
    }

    void showInterstitial() {
        if (this.isInvalidated() || this.mCustomEventInterstitial == null) {
            return;
        }
        try {
            this.mCustomEventInterstitial.showInterstitial();
        }
        catch (Exception e) {
            MoPubLog.d("Showing a custom event interstitial threw an exception.", e);
            this.onInterstitialFailed(MoPubErrorCode.INTERNAL_ERROR);
        }
    }

    void invalidate() {
        if (this.mCustomEventInterstitial != null) {
            try {
                this.mCustomEventInterstitial.onInvalidate();
            }
            catch (Exception e) {
                MoPubLog.d("Invalidating a custom event interstitial threw an exception.", e);
            }
        }
        this.mCustomEventInterstitial = null;
        this.mContext = null;
        this.mServerExtras = null;
        this.mLocalExtras = null;
        this.mCustomEventInterstitialAdapterListener = null;
        this.mInvalidated = true;
    }

    boolean isInvalidated() {
        return this.mInvalidated;
    }

    void setAdapterListener(CustomEventInterstitialAdapterListener listener) {
        this.mCustomEventInterstitialAdapterListener = listener;
    }

    private void cancelTimeout() {
        this.mHandler.removeCallbacks(this.mTimeout);
    }

    private int getTimeoutDelayMilliseconds() {
        if (this.mMoPubInterstitial == null || this.mMoPubInterstitial.getAdTimeoutDelay() == null || this.mMoPubInterstitial.getAdTimeoutDelay() < 0) {
            return 30000;
        }
        return this.mMoPubInterstitial.getAdTimeoutDelay() * 1000;
    }

    @Override
    public void onInterstitialLoaded() {
        if (this.isInvalidated()) {
            return;
        }
        this.cancelTimeout();
        if (this.mCustomEventInterstitialAdapterListener != null) {
            this.mCustomEventInterstitialAdapterListener.onCustomEventInterstitialLoaded();
        }
    }

    @Override
    public void onInterstitialFailed(MoPubErrorCode errorCode) {
        if (this.isInvalidated()) {
            return;
        }
        if (this.mCustomEventInterstitialAdapterListener != null) {
            if (errorCode == null) {
                errorCode = MoPubErrorCode.UNSPECIFIED;
            }
            this.cancelTimeout();
            this.mCustomEventInterstitialAdapterListener.onCustomEventInterstitialFailed(errorCode);
        }
    }

    @Override
    public void onInterstitialShown() {
        if (this.isInvalidated()) {
            return;
        }
        if (this.mCustomEventInterstitialAdapterListener != null) {
            this.mCustomEventInterstitialAdapterListener.onCustomEventInterstitialShown();
        }
    }

    @Override
    public void onInterstitialClicked() {
        if (this.isInvalidated()) {
            return;
        }
        if (this.mCustomEventInterstitialAdapterListener != null) {
            this.mCustomEventInterstitialAdapterListener.onCustomEventInterstitialClicked();
        }
    }

    @Override
    public void onLeaveApplication() {
        this.onInterstitialClicked();
    }

    @Override
    public void onInterstitialDismissed() {
        if (this.isInvalidated()) {
            return;
        }
        if (this.mCustomEventInterstitialAdapterListener != null) {
            this.mCustomEventInterstitialAdapterListener.onCustomEventInterstitialDismissed();
        }
    }

    @Deprecated
    void setCustomEventInterstitial(CustomEventInterstitial interstitial) {
        this.mCustomEventInterstitial = interstitial;
    }

    static interface CustomEventInterstitialAdapterListener {
        public void onCustomEventInterstitialLoaded();

        public void onCustomEventInterstitialFailed(MoPubErrorCode var1);

        public void onCustomEventInterstitialShown();

        public void onCustomEventInterstitialClicked();

        public void onCustomEventInterstitialDismissed();
    }
}

