/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.mopub.common.AdReport;
import com.mopub.common.CloseableLayout;

abstract class BaseInterstitialActivity
extends Activity {
    protected AdReport mAdReport;
    private CloseableLayout mCloseableLayout;
    private Long mBroadcastIdentifier;

    BaseInterstitialActivity() {
    }

    public abstract View getAdView();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.mBroadcastIdentifier = BaseInterstitialActivity.getBroadcastIdentifierFromIntent(intent);
        this.mAdReport = BaseInterstitialActivity.getAdReportFromIntent(intent);
        this.requestWindowFeature(1);
        this.getWindow().addFlags(1024);
        View adView = this.getAdView();
        this.mCloseableLayout = new CloseableLayout((Context)this);
        this.mCloseableLayout.setOnCloseListener(new CloseableLayout.OnCloseListener(){

            @Override
            public void onClose() {
                BaseInterstitialActivity.this.finish();
            }
        });
        this.mCloseableLayout.addView(adView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.setContentView((View)this.mCloseableLayout);
    }

    protected void onDestroy() {
        this.mCloseableLayout.removeAllViews();
        super.onDestroy();
    }

    Long getBroadcastIdentifier() {
        return this.mBroadcastIdentifier;
    }

    protected void showInterstitialCloseButton() {
        this.mCloseableLayout.setCloseVisible(true);
    }

    protected void hideInterstitialCloseButton() {
        this.mCloseableLayout.setCloseVisible(false);
    }

    protected static Long getBroadcastIdentifierFromIntent(Intent intent) {
        if (intent.hasExtra("broadcastIdentifier")) {
            return intent.getLongExtra("broadcastIdentifier", -1L);
        }
        return null;
    }

    @Nullable
    protected static AdReport getAdReportFromIntent(Intent intent) {
        try {
            return (AdReport)intent.getSerializableExtra("mopub-intent-ad-report");
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    static enum JavaScriptWebViewCallbacks {
        WEB_VIEW_DID_APPEAR("webviewDidAppear();"),
        WEB_VIEW_DID_CLOSE("webviewDidClose();");

        private String mJavascript;

        private JavaScriptWebViewCallbacks(String javascript) {
            this.mJavascript = javascript;
        }

        protected String getJavascript() {
            return this.mJavascript;
        }

        protected String getUrl() {
            return "javascript:" + this.mJavascript;
        }
    }
}

