/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import java.util.concurrent.TimeUnit;

public class Timer {
    private long mStopTimeNanos;
    private long mStartTimeNanos;
    private State mState = State.STOPPED;

    public void start() {
        this.mStartTimeNanos = System.nanoTime();
        this.mState = State.STARTED;
    }

    public void stop() {
        if (this.mState != State.STARTED) {
            throw new IllegalStateException("EventTimer was not started.");
        }
        this.mState = State.STOPPED;
        this.mStopTimeNanos = System.nanoTime();
    }

    public long getTime() {
        long endTime = this.mState == State.STARTED ? System.nanoTime() : this.mStopTimeNanos;
        return TimeUnit.MILLISECONDS.convert(endTime - this.mStartTimeNanos, TimeUnit.NANOSECONDS);
    }

    private static enum State {
        STARTED,
        STOPPED;

    }
}

