/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.event;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.event.BaseEvent;
import com.mopub.common.event.EventRecorder;
import com.mopub.common.event.EventSampler;
import com.mopub.common.event.EventSerializer;
import com.mopub.common.logging.MoPubLog;
import com.mopub.network.ScribeBackoffPolicy;
import com.mopub.network.ScribeRequest;
import com.mopub.network.ScribeRequestManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ScribeEventRecorder
implements EventRecorder {
    private static final String SCRIBE_URL = "https://analytics.mopub.com/i/jot/exchange_client_event";
    private static final int QUEUE_MAX_SIZE = 500;
    private static final int EVENT_COUNT_SEND_THRESHHOLD = 100;
    private static final int POLLING_PERIOD_MS = 120000;
    @NonNull
    private final EventSampler mEventSampler;
    @NonNull
    private final Queue<BaseEvent> mEventQueue;
    @NonNull
    private final EventSerializer mEventSerializer;
    @NonNull
    private final ScribeRequestManager mScribeRequestManager;
    @NonNull
    private final Handler mPollHandler;
    @NonNull
    private final PollingRunnable mPollingRunnable;

    ScribeEventRecorder(@NonNull Looper looper) {
        this(new EventSampler(), new LinkedList<BaseEvent>(), new EventSerializer(), new ScribeRequestManager(looper), new Handler(looper));
    }

    @VisibleForTesting
    ScribeEventRecorder(@NonNull EventSampler eventSampler, @NonNull Queue<BaseEvent> eventQueue, @NonNull EventSerializer eventSerializer, @NonNull ScribeRequestManager scribeRequestManager, @NonNull Handler handler) {
        this.mEventSampler = eventSampler;
        this.mEventQueue = eventQueue;
        this.mEventSerializer = eventSerializer;
        this.mScribeRequestManager = scribeRequestManager;
        this.mPollHandler = handler;
        this.mPollingRunnable = new PollingRunnable();
    }

    @Override
    public void record(@NonNull BaseEvent baseEvent) {
        if (!this.mEventSampler.sample(baseEvent)) {
            return;
        }
        if (this.mEventQueue.size() >= 500) {
            MoPubLog.d("EventQueue is at max capacity. Event \"" + (Object)((Object)baseEvent.getName()) + "\" is being dropped.");
            return;
        }
        this.mEventQueue.add(baseEvent);
        if (this.mEventQueue.size() >= 100) {
            this.sendEvents();
        }
        this.scheduleNextPoll();
    }

    @VisibleForTesting
    void sendEvents() {
        if (this.mScribeRequestManager.isAtCapacity()) {
            return;
        }
        final List<BaseEvent> events = this.dequeueEvents();
        if (events.isEmpty()) {
            return;
        }
        this.mScribeRequestManager.makeRequest(new ScribeRequest.ScribeRequestFactory(){

            @Override
            public ScribeRequest createRequest(ScribeRequest.Listener listener) {
                return new ScribeRequest(ScribeEventRecorder.SCRIBE_URL, events, ScribeEventRecorder.this.mEventSerializer, listener);
            }
        }, new ScribeBackoffPolicy());
    }

    @VisibleForTesting
    @NonNull
    List<BaseEvent> dequeueEvents() {
        ArrayList<BaseEvent> baseEvents = new ArrayList<BaseEvent>();
        while (this.mEventQueue.peek() != null && baseEvents.size() < 100) {
            baseEvents.add(this.mEventQueue.poll());
        }
        return baseEvents;
    }

    @VisibleForTesting
    void scheduleNextPoll() {
        if (this.mPollHandler.hasMessages(0) || this.mEventQueue.isEmpty()) {
            return;
        }
        this.mPollHandler.postDelayed((Runnable)this.mPollingRunnable, 120000L);
    }

    class PollingRunnable
    implements Runnable {
        PollingRunnable() {
        }

        @Override
        public void run() {
            ScribeEventRecorder.this.sendEvents();
            ScribeEventRecorder.this.scheduleNextPoll();
        }
    }
}

