/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.event;

import android.support.annotation.NonNull;
import com.mopub.common.ClientMetadata;
import com.mopub.common.Preconditions;
import com.mopub.common.event.BaseEvent;
import com.mopub.common.event.ErrorEvent;
import com.mopub.common.logging.MoPubLog;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventSerializer {
    @NonNull
    public JSONArray serializeAsJson(@NonNull List<BaseEvent> events) {
        Preconditions.checkNotNull(events);
        JSONArray jsonArray = new JSONArray();
        for (BaseEvent event : events) {
            try {
                jsonArray.put((Object)this.serializeAsJson(event));
            }
            catch (JSONException e) {
                MoPubLog.d("Failed to serialize event \"" + (Object)((Object)event.getName()) + "\" to JSON: ", e);
            }
        }
        return jsonArray;
    }

    @NonNull
    public JSONObject serializeAsJson(@NonNull BaseEvent event) throws JSONException {
        Preconditions.checkNotNull(event);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("_category_", (Object)event.getScribeCategory().getCategory());
        jsonObject.put("ts", (Object)event.getTimestampUtcMs());
        jsonObject.put("name", (Object)event.getName().getName());
        jsonObject.put("name_category", (Object)event.getCategory().getCategory());
        BaseEvent.SdkProduct sdkProduct = event.getSdkProduct();
        jsonObject.put("sdk_product", sdkProduct == null ? null : Integer.valueOf(sdkProduct.getType()));
        jsonObject.put("sdk_version", (Object)event.getSdkVersion());
        jsonObject.put("ad_unit_id", (Object)event.getAdUnitId());
        jsonObject.put("ad_creative_id", (Object)event.getAdCreativeId());
        jsonObject.put("ad_type", (Object)event.getAdType());
        jsonObject.put("ad_network_type", (Object)event.getAdNetworkType());
        jsonObject.put("ad_width_px", (Object)event.getAdWidthPx());
        jsonObject.put("ad_height_px", (Object)event.getAdHeightPx());
        jsonObject.put("dsp_creative_id", (Object)event.getDspCreativeId());
        BaseEvent.AppPlatform appPlatform = event.getAppPlatform();
        jsonObject.put("app_platform", appPlatform == null ? null : Integer.valueOf(appPlatform.getType()));
        jsonObject.put("app_name", (Object)event.getAppName());
        jsonObject.put("app_package_name", (Object)event.getAppPackageName());
        jsonObject.put("app_version", (Object)event.getAppVersion());
        jsonObject.put("client_advertising_id", (Object)event.getObfuscatedClientAdvertisingId());
        jsonObject.put("client_do_not_track", (Object)event.getClientDoNotTrack());
        jsonObject.put("device_manufacturer", (Object)event.getDeviceManufacturer());
        jsonObject.put("device_model", (Object)event.getDeviceModel());
        jsonObject.put("device_product", (Object)event.getDeviceProduct());
        jsonObject.put("device_os_version", (Object)event.getDeviceOsVersion());
        jsonObject.put("device_screen_width_px", (Object)event.getDeviceScreenWidthDip());
        jsonObject.put("device_screen_height_px", (Object)event.getDeviceScreenHeightDip());
        jsonObject.put("geo_lat", (Object)event.getGeoLat());
        jsonObject.put("geo_lon", (Object)event.getGeoLon());
        jsonObject.put("geo_accuracy_radius_meters", (Object)event.getGeoAccuracy());
        jsonObject.put("perf_duration_ms", (Object)event.getPerformanceDurationMs());
        ClientMetadata.MoPubNetworkType moPubNetworkType = event.getNetworkType();
        jsonObject.put("network_type", moPubNetworkType == null ? null : Integer.valueOf(moPubNetworkType.getId()));
        jsonObject.put("network_operator_code", (Object)event.getNetworkOperatorCode());
        jsonObject.put("network_operator_name", (Object)event.getNetworkOperatorName());
        jsonObject.put("network_iso_country_code", (Object)event.getNetworkIsoCountryCode());
        jsonObject.put("network_sim_code", (Object)event.getNetworkSimCode());
        jsonObject.put("network_sim_operator_name", (Object)event.getNetworkSimOperatorName());
        jsonObject.put("network_sim_iso_country_code", (Object)event.getNetworkSimIsoCountryCode());
        jsonObject.put("req_id", (Object)event.getRequestId());
        jsonObject.put("req_status_code", (Object)event.getRequestStatusCode());
        jsonObject.put("req_uri", (Object)event.getRequestUri());
        jsonObject.put("req_retries", (Object)event.getRequestRetries());
        jsonObject.put("timestamp_client", (Object)event.getTimestampUtcMs());
        if (event instanceof ErrorEvent) {
            ErrorEvent errorEvent = (ErrorEvent)event;
            jsonObject.put("error_exception_class_name", (Object)errorEvent.getErrorExceptionClassName());
            jsonObject.put("error_message", (Object)errorEvent.getErrorMessage());
            jsonObject.put("error_stack_trace", (Object)errorEvent.getErrorStackTrace());
            jsonObject.put("error_file_name", (Object)errorEvent.getErrorFileName());
            jsonObject.put("error_class_name", (Object)errorEvent.getErrorClassName());
            jsonObject.put("error_method_name", (Object)errorEvent.getErrorMethodName());
            jsonObject.put("error_line_number", (Object)errorEvent.getErrorLineNumber());
        }
        return jsonObject;
    }
}

