/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.event;

import android.support.annotation.NonNull;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.event.BaseEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class EventSampler {
    @VisibleForTesting
    static final int MAX_SIZE = 100;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CAPACITY = 135;
    @NonNull
    private Random mRandom;
    @NonNull
    private LinkedHashMap<String, Boolean> mSampleDecisionsCache;

    public EventSampler() {
        this(new Random());
    }

    @VisibleForTesting
    public EventSampler(@NonNull Random random) {
        this.mRandom = random;
        this.mSampleDecisionsCache = new LinkedHashMap<String, Boolean>(135, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
                return this.size() > 100;
            }
        };
    }

    boolean sample(@NonNull BaseEvent baseEvent) {
        Preconditions.checkNotNull(baseEvent);
        String requestId = baseEvent.getRequestId();
        if (requestId == null) {
            return this.mRandom.nextDouble() < baseEvent.getSamplingRate();
        }
        Boolean existingSample = this.mSampleDecisionsCache.get(requestId);
        if (existingSample != null) {
            return existingSample;
        }
        boolean newSample = this.mRandom.nextDouble() < baseEvent.getSamplingRate();
        this.mSampleDecisionsCache.put(requestId, newSample);
        return newSample;
    }

    @VisibleForTesting
    int getCacheSize() {
        return this.mSampleDecisionsCache.size();
    }
}

