/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.event;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.event.BaseEvent;
import com.mopub.common.event.EventDetails;
import com.mopub.common.logging.MoPubLog;

public class Event
extends BaseEvent {
    private Event(@NonNull Builder builder) {
        super(builder);
    }

    @Nullable
    public static BaseEvent createEventFromDetails(@NonNull BaseEvent.Name name, @NonNull BaseEvent.Category category, @NonNull BaseEvent.SamplingRate samplingRate, @Nullable EventDetails eventDetails) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)category);
        Preconditions.checkNotNull((Object)samplingRate);
        if (eventDetails == null) {
            MoPubLog.d("Unable to log event due to no details present");
            return null;
        }
        return new Builder(name, category, samplingRate.getSamplingRate()).withAdUnitId(eventDetails.getAdUnitId()).withAdCreativeId(eventDetails.getDspCreativeId()).withAdType(eventDetails.getAdType()).withAdNetworkType(eventDetails.getAdNetworkType()).withAdWidthPx(eventDetails.getAdWidthPx()).withAdHeightPx(eventDetails.getAdHeightPx()).withGeoLat(eventDetails.getGeoLatitude()).withGeoLon(eventDetails.getGeoLongitude()).withGeoAccuracy(eventDetails.getGeoAccuracy()).withPerformanceDurationMs(eventDetails.getPerformanceDurationMs()).withRequestId(eventDetails.getRequestId()).withRequestStatusCode(eventDetails.getRequestStatusCode()).withRequestUri(eventDetails.getRequestUri()).build();
    }

    public static class Builder
    extends BaseEvent.Builder {
        public Builder(@NonNull BaseEvent.Name name, @NonNull BaseEvent.Category category, double samplingRate) {
            super(BaseEvent.ScribeCategory.EXCHANGE_CLIENT_EVENT, name, category, samplingRate);
        }

        @Override
        @NonNull
        public Event build() {
            return new Event(this);
        }
    }
}

